/*
 * Decompiled with CFR 0.152.
 */
package mod.beethoven92.betterendforge.common.world.feature;

import java.util.Random;
import java.util.function.Function;
import mod.beethoven92.betterendforge.common.block.HydrothermalVentBlock;
import mod.beethoven92.betterendforge.common.init.ModBlocks;
import mod.beethoven92.betterendforge.common.init.ModFeatures;
import mod.beethoven92.betterendforge.common.init.ModTags;
import mod.beethoven92.betterendforge.common.util.BlockHelper;
import mod.beethoven92.betterendforge.common.util.FeatureHelper;
import mod.beethoven92.betterendforge.common.util.ModMathHelper;
import mod.beethoven92.betterendforge.common.util.sdf.SDF;
import mod.beethoven92.betterendforge.common.util.sdf.operator.SDFCoordModify;
import mod.beethoven92.betterendforge.common.util.sdf.operator.SDFDisplacement;
import mod.beethoven92.betterendforge.common.util.sdf.operator.SDFInvert;
import mod.beethoven92.betterendforge.common.util.sdf.operator.SDFRotation;
import mod.beethoven92.betterendforge.common.util.sdf.operator.SDFScale3D;
import mod.beethoven92.betterendforge.common.util.sdf.operator.SDFSmoothUnion;
import mod.beethoven92.betterendforge.common.util.sdf.operator.SDFSubtraction;
import mod.beethoven92.betterendforge.common.util.sdf.operator.SDFTranslate;
import mod.beethoven92.betterendforge.common.util.sdf.operator.SDFUnary;
import mod.beethoven92.betterendforge.common.util.sdf.operator.SDFUnion;
import mod.beethoven92.betterendforge.common.util.sdf.primitive.SDFCappedCone;
import mod.beethoven92.betterendforge.common.util.sdf.primitive.SDFFlatland;
import mod.beethoven92.betterendforge.common.util.sdf.primitive.SDFSphere;
import mod.beethoven92.betterendforge.common.world.generator.OpenSimplexNoise;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.material.Material;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class GeyserFeature
extends Feature<NoFeatureConfig> {
    protected static final Function<BlockState, Boolean> REPLACE1;
    protected static final Function<BlockState, Boolean> REPLACE2;
    private static final Function<BlockState, Boolean> IGNORE;
    private static final Direction[] HORIZONTAL;

    public GeyserFeature() {
        super(NoFeatureConfig.field_236558_a_);
    }

    public boolean generate(ISeedReader world, ChunkGenerator generator, Random rand, BlockPos pos, NoFeatureConfig config) {
        int i;
        if ((pos = FeatureHelper.getPosOnSurfaceWG(world, pos)).func_177956_o() < 10) {
            return false;
        }
        BlockPos.Mutable bpos = new BlockPos.Mutable().func_189533_g((Vector3i)pos);
        bpos.func_185336_p(bpos.func_177956_o() - 1);
        BlockState state = world.func_180495_p((BlockPos)bpos);
        while (state.func_235714_a_(ModTags.GEN_TERRAIN) || !state.func_204520_s().func_206888_e() && bpos.func_177956_o() > 5) {
            bpos.func_185336_p(bpos.func_177956_o() - 1);
            state = world.func_180495_p((BlockPos)bpos);
        }
        if (pos.func_177956_o() - bpos.func_177956_o() < 25) {
            return false;
        }
        int halfHeight = ModMathHelper.randRange(10, 20, rand);
        float radius1 = (float)halfHeight * 0.5f;
        float radius2 = (float)halfHeight * 0.1f + 0.5f;
        SDF sdf = new SDFCappedCone().setHeight(halfHeight).setRadius1(radius1).setRadius2(radius2).setBlock((Block)ModBlocks.SULPHURIC_ROCK.stone.get());
        sdf = new SDFTranslate().setTranslate(0.0f, halfHeight - 3, 0.0f).setSource(sdf);
        int count = halfHeight;
        for (int i2 = 0; i2 < count; ++i2) {
            int py = i2 << 1;
            float delta = (float)i2 / (float)(count - 1);
            float radius = MathHelper.func_219799_g((float)delta, (float)radius1, (float)radius2) * 1.3f;
            SDF bowl = new SDFCappedCone().setHeight(radius).setRadius1(0.0f).setRadius2(radius).setBlock((Block)ModBlocks.SULPHURIC_ROCK.stone.get());
            SDF brimstone = new SDFCappedCone().setHeight(radius).setRadius1(0.0f).setRadius2(radius).setBlock((Block)ModBlocks.BRIMSTONE.get());
            brimstone = new SDFTranslate().setTranslate(0.0f, 2.0f, 0.0f).setSource(brimstone);
            bowl = new SDFSubtraction().setSourceA(bowl).setSourceB(brimstone);
            bowl = new SDFUnion().setSourceA(brimstone).setSourceB(bowl);
            Direction[] water = new SDFCappedCone().setHeight(radius).setRadius1(0.0f).setRadius2(radius).setBlock(Blocks.field_150355_j);
            water = new SDFTranslate().setTranslate(0.0f, 4.0f, 0.0f).setSource((SDF)water);
            bowl = new SDFSubtraction().setSourceA(bowl).setSourceB((SDF)water);
            bowl = new SDFUnion().setSourceA((SDF)water).setSourceB(bowl);
            OpenSimplexNoise noise1 = new OpenSimplexNoise(rand.nextLong());
            OpenSimplexNoise noise2 = new OpenSimplexNoise(rand.nextLong());
            bowl = new SDFCoordModify().setFunction(vec -> {
                float dx = (float)noise1.eval((double)vec.func_195899_a() * 0.1, (double)vec.func_195900_b() * 0.1, (double)vec.func_195902_c() * 0.1);
                float dz = (float)noise2.eval((double)vec.func_195899_a() * 0.1, (double)vec.func_195900_b() * 0.1, (double)vec.func_195902_c() * 0.1);
                vec.func_195905_a(vec.func_195899_a() + dx, vec.func_195900_b(), vec.func_195902_c() + dz);
            }).setSource(bowl);
            SDF cut = new SDFFlatland().setBlock(Blocks.field_150350_a);
            cut = new SDFInvert().setSource(cut);
            cut = new SDFTranslate().setTranslate(0.0f, radius - 2.0f, 0.0f).setSource(cut);
            bowl = new SDFSubtraction().setSourceA(bowl).setSourceB(cut);
            bowl = new SDFTranslate().setTranslate(radius, (float)py - radius, 0.0f).setSource(bowl);
            bowl = new SDFRotation().setRotation(Vector3f.field_229181_d_, (float)i2 * 4.0f).setSource(bowl);
            sdf = new SDFUnion().setSourceA(sdf).setSourceB(bowl);
        }
        sdf.setReplaceFunction(REPLACE2).fillRecursive((IWorld)world, pos);
        radius2 *= 0.5f;
        if (radius2 < 0.7f) {
            radius2 = 0.7f;
        }
        OpenSimplexNoise noise = new OpenSimplexNoise(rand.nextLong());
        SDFCappedCone obj1 = new SDFCappedCone().setHeight(halfHeight + 5).setRadius1(radius1 * 0.5f).setRadius2(radius2);
        sdf = new SDFTranslate().setTranslate(0.0f, halfHeight - 13, 0.0f).setSource(obj1);
        sdf = new SDFDisplacement().setFunction(vec -> Float.valueOf((float)noise.eval(vec.func_195899_a() * 0.3f, vec.func_195900_b() * 0.3f, vec.func_195902_c() * 0.3f) * 0.5f)).setSource(sdf);
        SDFSphere obj2 = new SDFSphere().setRadius(radius1);
        SDFUnary cave = new SDFScale3D().setScale(1.5f, 1.0f, 1.5f).setSource(obj2);
        cave = new SDFDisplacement().setFunction(vec -> Float.valueOf((float)noise.eval(vec.func_195899_a() * 0.1f, vec.func_195900_b() * 0.1f, vec.func_195902_c() * 0.1f) * 2.0f)).setSource(cave);
        cave = new SDFTranslate().setTranslate(0.0f, -halfHeight - 10, 0.0f).setSource(cave);
        sdf = new SDFSmoothUnion().setRadius(5.0f).setSourceA(cave).setSourceB(sdf);
        obj1.setBlock(Blocks.field_150355_j);
        obj2.setBlock(Blocks.field_150355_j);
        sdf.setReplaceFunction(REPLACE2);
        sdf.fillRecursive((IWorld)world, pos);
        obj1.setBlock((Block)ModBlocks.BRIMSTONE.get());
        obj2.setBlock((Block)ModBlocks.BRIMSTONE.get());
        new SDFDisplacement().setFunction(vec -> Float.valueOf(-2.0f)).setSource(sdf).setReplaceFunction(REPLACE1).fillRecursiveIgnore((IWorld)world, pos, IGNORE);
        obj1.setBlock((Block)ModBlocks.SULPHURIC_ROCK.stone.get());
        obj2.setBlock((Block)ModBlocks.SULPHURIC_ROCK.stone.get());
        new SDFDisplacement().setFunction(vec -> Float.valueOf(-4.0f)).setSource(cave).setReplaceFunction(REPLACE1).fillRecursiveIgnore((IWorld)world, pos, IGNORE);
        obj1.setBlock(Blocks.field_150377_bs);
        obj2.setBlock(Blocks.field_150377_bs);
        new SDFDisplacement().setFunction(vec -> Float.valueOf(-6.0f)).setSource(cave).setReplaceFunction(REPLACE1).fillRecursiveIgnore((IWorld)world, pos, IGNORE);
        BlockHelper.setWithoutUpdate((IWorldWriter)world, pos, Blocks.field_150355_j);
        BlockPos.Mutable mut = new BlockPos.Mutable().func_189533_g((Vector3i)pos);
        count = FeatureHelper.getYOnSurface(world, pos.func_177958_n(), pos.func_177952_p()) - pos.func_177956_o();
        for (i = 0; i < count; ++i) {
            BlockHelper.setWithoutUpdate((IWorldWriter)world, (BlockPos)mut, Blocks.field_150355_j);
            for (Direction dir : BlockHelper.HORIZONTAL_DIRECTIONS) {
                BlockHelper.setWithoutUpdate((IWorldWriter)world, mut.func_177972_a(dir), Blocks.field_150355_j);
            }
            mut.func_185336_p(mut.func_177956_o() + 1);
        }
        for (i = 0; i < 150; ++i) {
            mut.func_189533_g((Vector3i)pos).func_196234_d(ModMathHelper.floor(rand.nextGaussian() * 4.0 + 0.5), -halfHeight - 10, ModMathHelper.floor(rand.nextGaussian() * 4.0 + 0.5));
            float distRaw = ModMathHelper.length(mut.func_177958_n() - pos.func_177958_n(), mut.func_177952_p() - pos.func_177952_p());
            int dist = ModMathHelper.floor(6.0f - distRaw) + rand.nextInt(2);
            if (dist < 0) continue;
            state = world.func_180495_p((BlockPos)mut);
            while (!state.func_204520_s().func_206888_e() || state.func_185904_a().equals(Material.field_203243_f)) {
                mut.func_185336_p(mut.func_177956_o() - 1);
                state = world.func_180495_p((BlockPos)mut);
            }
            if (!state.func_235714_a_(ModTags.GEN_TERRAIN) || world.func_180495_p(mut.func_177984_a()).func_203425_a((Block)ModBlocks.HYDROTHERMAL_VENT.get())) continue;
            for (int j = 0; j <= dist; ++j) {
                BlockHelper.setWithoutUpdate((IWorldWriter)world, (BlockPos)mut, (Block)ModBlocks.SULPHURIC_ROCK.stone.get());
                ModMathHelper.shuffle(HORIZONTAL, rand);
                for (Direction dir : HORIZONTAL) {
                    BlockPos p = mut.func_177972_a(dir);
                    if (!rand.nextBoolean() || !world.func_180495_p(p).func_203425_a(Blocks.field_150355_j)) continue;
                    BlockHelper.setWithoutUpdate((IWorldWriter)world, p, (BlockState)((Block)ModBlocks.TUBE_WORM.get()).func_176223_P().func_206870_a((Property)HorizontalBlock.field_185512_D, (Comparable)dir));
                }
                mut.func_185336_p(mut.func_177956_o() + 1);
            }
            state = (BlockState)((Block)ModBlocks.HYDROTHERMAL_VENT.get()).func_176223_P().func_206870_a((Property)HydrothermalVentBlock.ACTIVATED, (Comparable)Boolean.valueOf(distRaw < 2.0f));
            BlockHelper.setWithoutUpdate((IWorldWriter)world, (BlockPos)mut, state);
            mut.func_185336_p(mut.func_177956_o() + 1);
            state = world.func_180495_p((BlockPos)mut);
            while (state.func_203425_a(Blocks.field_150355_j)) {
                BlockHelper.setWithoutUpdate((IWorldWriter)world, (BlockPos)mut, ((Block)ModBlocks.VENT_BUBBLE_COLUMN.get()).func_176223_P());
                mut.func_185336_p(mut.func_177956_o() + 1);
                state = world.func_180495_p((BlockPos)mut);
            }
        }
        for (i = 0; i < 10; ++i) {
            mut.func_189533_g((Vector3i)pos).func_196234_d(ModMathHelper.floor(rand.nextGaussian() * 0.7 + 0.5), -halfHeight - 10, ModMathHelper.floor(rand.nextGaussian() * 0.7 + 0.5));
            float distRaw = ModMathHelper.length(mut.func_177958_n() - pos.func_177958_n(), mut.func_177952_p() - pos.func_177952_p());
            int dist = ModMathHelper.floor(6.0f - distRaw) + rand.nextInt(2);
            if (dist < 0) continue;
            state = world.func_180495_p((BlockPos)mut);
            while (state.func_203425_a(Blocks.field_150355_j)) {
                mut.func_185336_p(mut.func_177956_o() - 1);
                state = world.func_180495_p((BlockPos)mut);
            }
            if (!state.func_235714_a_(ModTags.GEN_TERRAIN)) continue;
            for (int j = 0; j <= dist; ++j) {
                BlockHelper.setWithoutUpdate((IWorldWriter)world, (BlockPos)mut, (Block)ModBlocks.SULPHURIC_ROCK.stone.get());
                mut.func_185336_p(mut.func_177956_o() + 1);
            }
            state = (BlockState)((Block)ModBlocks.HYDROTHERMAL_VENT.get()).func_176223_P().func_206870_a((Property)HydrothermalVentBlock.ACTIVATED, (Comparable)Boolean.valueOf(distRaw < 2.0f));
            BlockHelper.setWithoutUpdate((IWorldWriter)world, (BlockPos)mut, state);
            mut.func_185336_p(mut.func_177956_o() + 1);
            state = world.func_180495_p((BlockPos)mut);
            while (state.func_203425_a(Blocks.field_150355_j)) {
                BlockHelper.setWithoutUpdate((IWorldWriter)world, (BlockPos)mut, ((Block)ModBlocks.VENT_BUBBLE_COLUMN.get()).func_176223_P());
                mut.func_185336_p(mut.func_177956_o() + 1);
                state = world.func_180495_p((BlockPos)mut);
            }
        }
        ModFeatures.SULPHURIC_LAKE.func_241855_a(world, generator, rand, pos, null);
        double distance = (double)radius1 * 1.7;
        BlockPos start = pos.func_177963_a(-distance, (double)(-halfHeight - 15) - distance, -distance);
        BlockPos end = pos.func_177963_a(distance, (double)(-halfHeight - 5) + distance, distance);
        BlockHelper.fixBlocks((IWorld)world, start, end);
        return true;
    }

    static {
        HORIZONTAL = BlockHelper.makeHorizontal();
        REPLACE1 = state -> state.func_196958_f() || state.func_235714_a_(ModTags.GEN_TERRAIN);
        REPLACE2 = state -> {
            if (state.func_235714_a_(ModTags.GEN_TERRAIN) || state.func_203425_a((Block)ModBlocks.HYDROTHERMAL_VENT.get()) || state.func_203425_a((Block)ModBlocks.SULPHUR_CRYSTAL.get())) {
                return true;
            }
            if (state.func_185904_a().equals(Material.field_151585_k)) {
                return true;
            }
            return state.func_185904_a().func_76222_j();
        };
        IGNORE = state -> state.func_203425_a(Blocks.field_150355_j) || state.func_203425_a(Blocks.field_201941_jj) || state.func_203425_a((Block)ModBlocks.SULPHURIC_ROCK.stone.get()) || state.func_203425_a((Block)ModBlocks.BRIMSTONE.get());
    }
}

