/*
 * Decompiled with CFR 0.152.
 */
package mod.beethoven92.betterendforge.common.world.feature;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Random;
import java.util.function.Function;
import mod.beethoven92.betterendforge.common.init.ModTags;
import mod.beethoven92.betterendforge.common.util.FeatureHelper;
import mod.beethoven92.betterendforge.common.util.ModMathHelper;
import mod.beethoven92.betterendforge.common.util.sdf.SDF;
import mod.beethoven92.betterendforge.common.util.sdf.operator.SDFDisplacement;
import mod.beethoven92.betterendforge.common.util.sdf.operator.SDFRotation;
import mod.beethoven92.betterendforge.common.util.sdf.primitive.SDFTorus;
import mod.beethoven92.betterendforge.common.world.generator.OpenSimplexNoise;
import mod.beethoven92.betterendforge.data.AABBAcc;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class ArchFeature
extends Feature<NoFeatureConfig> {
    private Function<BlockPos, BlockState> surfaceFunction;
    private Block block;

    public ArchFeature(Block block, Function<BlockPos, BlockState> surfaceFunction) {
        super(NoFeatureConfig.field_236558_a_);
        this.surfaceFunction = surfaceFunction;
        this.block = block;
    }

    public boolean generate(ISeedReader level, ChunkGenerator generator, Random random, BlockPos origin, NoFeatureConfig config) {
        ISeedReader world = level;
        BlockPos pos = FeatureHelper.getPosOnSurfaceWG(world, new BlockPos(origin.func_177958_n() & 0xFFFFFFF0 | 7, 0, origin.func_177952_p() & 0xFFFFFFF0 | 7));
        if (!world.func_180495_p(pos.func_177979_c(5)).func_235714_a_(ModTags.GEN_TERRAIN)) {
            return false;
        }
        float bigRadius = ModMathHelper.randRange(10.0f, 20.0f, random);
        float smallRadius = ModMathHelper.randRange(3.0f, 7.0f, random);
        if (smallRadius + bigRadius > 23.0f) {
            smallRadius = 23.0f - bigRadius;
        }
        SDF arch = new SDFTorus().setBigRadius(bigRadius).setSmallRadius(smallRadius).setBlock(this.block);
        arch = new SDFRotation().setRotation(ModMathHelper.randomHorizontal(random), 1.5707964f).setSource(arch);
        float smallRadiusF = smallRadius;
        OpenSimplexNoise noise = new OpenSimplexNoise(random.nextLong());
        arch = new SDFDisplacement().setFunction(vec -> Float.valueOf((float)(Math.abs(noise.eval((double)vec.func_195899_a() * 0.1, (double)vec.func_195900_b() * 0.1, (double)vec.func_195902_c() * 0.1)) * 3.0 + Math.abs(noise.eval((double)vec.func_195899_a() * 0.3, (double)vec.func_195900_b() * 0.3 + 100.0, (double)vec.func_195902_c() * 0.3)) * (double)1.3f) - smallRadiusF * Math.abs(1.0f - vec.func_195900_b() / bigRadius))).setSource(arch);
        ArrayList surface = Lists.newArrayList();
        arch.addPostProcess(info -> {
            if (info.getStateUp().func_196958_f()) {
                return this.surfaceFunction.apply(info.getPos());
            }
            return info.getState();
        });
        float side = (bigRadius + smallRadius + 3.0f) * 2.0f;
        if (side > 47.0f) {
            side = 47.0f;
        }
        arch.fillArea((IWorld)world, pos, AABBAcc.ofSize(Vector3d.func_237489_a_((Vector3i)pos), side, side, side));
        return true;
    }
}

