/*
 * Decompiled with CFR 0.152.
 */
package mod.beethoven92.betterendforge.common.util.sdf.primitive;

import mod.beethoven92.betterendforge.common.util.ModMathHelper;
import mod.beethoven92.betterendforge.common.util.sdf.operator.SDFDisplacement;
import mod.beethoven92.betterendforge.common.world.generator.OpenSimplexNoise;
import net.minecraft.util.math.MathHelper;

public class SDFRadialNoiseMap
extends SDFDisplacement {
    private static final float SIN = MathHelper.func_76126_a((float)0.5f);
    private static final float COS = MathHelper.func_76134_b((float)0.5f);
    private OpenSimplexNoise noise;
    private float intensity = 1.0f;
    private float radius = 1.0f;
    private short offsetX;
    private short offsetZ;

    public SDFRadialNoiseMap() {
        this.setFunction(pos -> {
            float pz;
            if (this.intensity == 0.0f) {
                return Float.valueOf(0.0f);
            }
            float px = pos.func_195899_a() / this.radius;
            float distance = ModMathHelper.lengthSqr(px, pz = pos.func_195902_c() / this.radius);
            if (distance > 1.0f) {
                return Float.valueOf(0.0f);
            }
            distance = 1.0f - MathHelper.func_76129_c((float)distance);
            float nx = px * COS - pz * SIN;
            float nz = pz * COS + px * SIN;
            return Float.valueOf((distance *= this.getNoise((double)nx * 0.75 + (double)this.offsetX, (double)nz * 0.75 + (double)this.offsetZ)) * this.intensity);
        });
    }

    private float getNoise(double x, double z) {
        return (float)this.noise.eval(x, z) + (float)this.noise.eval(x * 3.0 + 1000.0, z * 3.0) * 0.5f + (float)this.noise.eval(x * 9.0 + 1000.0, z * 9.0) * 0.2f;
    }

    public SDFRadialNoiseMap setSeed(long seed) {
        this.noise = new OpenSimplexNoise(seed);
        return this;
    }

    public SDFRadialNoiseMap setIntensity(float intensity) {
        this.intensity = intensity;
        return this;
    }

    public SDFRadialNoiseMap setRadius(float radius) {
        this.radius = radius;
        return this;
    }

    public SDFRadialNoiseMap setOffset(int x, int z) {
        this.offsetX = (short)(x & Short.MAX_VALUE);
        this.offsetZ = (short)(z & Short.MAX_VALUE);
        return this;
    }
}

