/*
 * Decompiled with CFR 0.152.
 */
package mod.beethoven92.betterendforge.common.util.sdf.operator;

import mod.beethoven92.betterendforge.common.util.sdf.operator.SDFDisplacement;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.util.math.MathHelper;

public class SDFHeightmap
extends SDFDisplacement {
    private float intensity = 1.0f;
    private NativeImage map;
    private float offsetX;
    private float offsetZ;
    private float scale;
    private float cos = 1.0f;
    private float sin = 0.0f;

    public SDFHeightmap() {
        this.setFunction(pos -> {
            if (this.map == null) {
                return Float.valueOf(0.0f);
            }
            float px = MathHelper.func_76131_a((float)(pos.func_195899_a() * this.scale + this.offsetX), (float)0.0f, (float)(this.map.func_195702_a() - 2));
            float pz = MathHelper.func_76131_a((float)(pos.func_195902_c() * this.scale + this.offsetZ), (float)0.0f, (float)(this.map.func_195714_b() - 2));
            float dx = px * this.cos - pz * this.sin;
            float dz = pz * this.cos + px * this.sin;
            int x1 = MathHelper.func_76141_d((float)dx);
            int z1 = MathHelper.func_76141_d((float)dz);
            int x2 = x1 + 1;
            int z2 = z1 + 1;
            dx -= (float)x1;
            dz -= (float)z1;
            float a = (float)(this.map.func_195709_a(x1, z1) & 0xFF) / 255.0f;
            float b = (float)(this.map.func_195709_a(x2, z1) & 0xFF) / 255.0f;
            float c = (float)(this.map.func_195709_a(x1, z2) & 0xFF) / 255.0f;
            float d = (float)(this.map.func_195709_a(x2, z2) & 0xFF) / 255.0f;
            a = MathHelper.func_219799_g((float)dx, (float)a, (float)b);
            b = MathHelper.func_219799_g((float)dx, (float)c, (float)d);
            return Float.valueOf(-MathHelper.func_219799_g((float)dz, (float)a, (float)b) * this.intensity);
        });
    }

    public SDFHeightmap setMap(NativeImage map) {
        this.map = map;
        this.offsetX = (float)map.func_195702_a() * 0.5f;
        this.offsetZ = (float)map.func_195714_b() * 0.5f;
        this.scale = map.func_195702_a();
        return this;
    }

    public SDFHeightmap setAngle(float angle) {
        this.sin = MathHelper.func_76126_a((float)angle);
        this.cos = MathHelper.func_76134_b((float)angle);
        return this;
    }

    public SDFHeightmap setScale(float scale) {
        this.scale = (float)this.map.func_195702_a() * scale;
        return this;
    }

    public SDFHeightmap setIntensity(float intensity) {
        this.intensity = intensity;
        return this;
    }
}

