/*
 * Decompiled with CFR 0.152.
 */
package mod.beethoven92.betterendforge.common.capability;

import com.google.common.collect.ImmutableList;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import mod.beethoven92.betterendforge.common.init.ModBiomes;
import mod.beethoven92.betterendforge.common.world.generator.GeneratorOptions;
import net.minecraft.block.PortalInfo;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;

public class EndData
implements INBTSerializable<CompoundNBT> {
    @CapabilityInject(value=EndData.class)
    public static final Capability<EndData> CAPABILITY = null;
    private Set<UUID> players = new HashSet<UUID>();
    private BlockPos spawn;

    private void login(ServerPlayerEntity player) {
        if (this.players.contains(player.func_110124_au())) {
            return;
        }
        this.players.add(player.func_110124_au());
        this.teleportToSpawn(player);
    }

    private void teleportToSpawn(ServerPlayerEntity player) {
        if (player.func_241140_K_() != null || !GeneratorOptions.swapOverworldToEnd()) {
            return;
        }
        ServerWorld world = player.func_71121_q();
        ServerWorld end = world.func_73046_m().func_71218_a(World.field_234920_i_);
        if (end == null) {
            return;
        }
        if (this.spawn == null) {
            this.spawn = this.findSpawn(end, (PlayerEntity)player);
        }
        if (this.spawn == null) {
            return;
        }
        if (world == end) {
            player.func_70107_b((double)this.spawn.func_177958_n(), (double)this.spawn.func_177956_o(), (double)this.spawn.func_177952_p());
        } else {
            player.changeDimension(end, new ITeleporter(){

                public Entity placeEntity(Entity entity, ServerWorld currentWorld, ServerWorld destWorld, float yaw, Function<Boolean, Entity> repositionEntity) {
                    return repositionEntity.apply(false);
                }

                public PortalInfo getPortalInfo(Entity entity, ServerWorld destWorld, Function<ServerWorld, PortalInfo> defaultPortalInfo) {
                    return new PortalInfo(Vector3d.func_237491_b_((Vector3i)EndData.this.spawn), Vector3d.field_186680_a, entity.field_70177_z, entity.field_70125_A);
                }
            });
        }
    }

    private BlockPos findSpawn(ServerWorld end, PlayerEntity player) {
        ImmutableList biomes = ImmutableList.of((Object)ModBiomes.AMBER_LAND.getActualBiome(), (Object)ModBiomes.BLOSSOMING_SPIRES.getActualBiome(), (Object)ModBiomes.CHORUS_FOREST.getActualBiome(), (Object)ModBiomes.CRYSTAL_MOUNTAINS.getActualBiome(), (Object)ModBiomes.DRY_SHRUBLAND.getActualBiome(), (Object)ModBiomes.DUST_WASTELANDS.getActualBiome(), (Object)ModBiomes.FOGGY_MUSHROOMLAND.getActualBiome(), (Object)ModBiomes.GLOWING_GRASSLANDS.getActualBiome(), (Object)ModBiomes.LANTERN_WOODS.getActualBiome(), (Object)ModBiomes.MEGALAKE.getActualBiome(), (Object)ModBiomes.SULPHUR_SPRINGS.getActualBiome(), (Object)ModBiomes.UMBRELLA_JUNGLE.getActualBiome(), (Object[])new Biome[0]);
        for (Biome biome : biomes) {
            BlockPos pos = end.func_241116_a_(biome, BlockPos.field_177992_a.func_177982_a(0, 40, 0), 6400, 8);
            if (pos == null) continue;
            for (int i = 0; i < 40; ++i) {
                BlockPos p = pos.func_177982_a(end.func_201674_k().nextInt(40) - 20, 0, end.func_201674_k().nextInt(40) - 20);
                for (int k = 0; k < 150; ++k) {
                    if (end.func_175623_d(p.func_177982_a(0, k, 0)) || !end.func_175623_d(p.func_177982_a(0, k + 1, 0)) || !end.func_175623_d(p.func_177982_a(0, k + 2, 0))) continue;
                    return p.func_177982_a(0, k + 1, 0);
                }
            }
        }
        return null;
    }

    public static void playerLogin(ServerPlayerEntity player) {
        ServerWorld end = player.func_184102_h().func_71218_a(World.field_234920_i_);
        if (end == null) {
            return;
        }
        end.getCapability(CAPABILITY).ifPresent(c -> c.login(player));
    }

    public static void playerRespawn(ServerPlayerEntity player) {
        ServerWorld end = player.func_184102_h().func_71218_a(World.field_234920_i_);
        if (end == null) {
            return;
        }
        end.getCapability(CAPABILITY).ifPresent(c -> c.teleportToSpawn(player));
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = new CompoundNBT();
        if (this.spawn != null) {
            nbt.func_218657_a("spawn", (INBT)NBTUtil.func_186859_a((BlockPos)this.spawn));
        }
        ListNBT list = new ListNBT();
        for (UUID id : this.players) {
            list.add((Object)NBTUtil.func_240626_a_((UUID)id));
        }
        nbt.func_218657_a("players", (INBT)list);
        return nbt;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        if (nbt.func_74764_b("spawn")) {
            this.spawn = NBTUtil.func_186861_c((CompoundNBT)nbt.func_74775_l("spawn"));
        }
        ListNBT list = nbt.func_150295_c("players", 11);
        for (int i = 0; i < list.size(); ++i) {
            this.players.add(NBTUtil.func_186860_b((INBT)list.get(i)));
        }
    }

    @Mod.EventBusSubscriber(modid="betterendforge", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class Subscriber {
        @SubscribeEvent
        public static void setup(FMLCommonSetupEvent event) {
            CapabilityManager.INSTANCE.register(EndData.class, (Capability.IStorage)new Storage(), EndData::new);
        }
    }

    public static class Storage
    implements Capability.IStorage<EndData> {
        public INBT writeNBT(Capability<EndData> capability, EndData instance, Direction side) {
            return instance.serializeNBT();
        }

        public void readNBT(Capability<EndData> capability, EndData instance, Direction side, INBT nbt) {
            instance.deserializeNBT((CompoundNBT)nbt);
        }
    }

    @Mod.EventBusSubscriber(modid="betterendforge", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class Provider
    implements ICapabilitySerializable<INBT> {
        private LazyOptional<EndData> instance = LazyOptional.of(() -> CAPABILITY.getDefaultInstance());
        private static final ResourceLocation LOCATION = new ResourceLocation("betterendforge", "enddata");

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return CAPABILITY.orEmpty(cap, this.instance);
        }

        public INBT serializeNBT() {
            return CAPABILITY.getStorage().writeNBT(CAPABILITY, this.instance.orElseThrow(() -> new IllegalArgumentException("LazyOptional cannot be empty!")), null);
        }

        public void deserializeNBT(INBT nbt) {
            CAPABILITY.getStorage().readNBT(CAPABILITY, this.instance.orElseThrow(() -> new IllegalArgumentException("LazyOptional cannot be empty!")), null, nbt);
        }

        @SubscribeEvent
        public static void attachCapability(AttachCapabilitiesEvent<World> event) {
            if (((World)event.getObject()).func_234923_W_() == World.field_234920_i_) {
                event.addCapability(LOCATION, (ICapabilityProvider)new Provider());
            }
        }
    }
}

