/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.auudio.audio;

import java.lang.reflect.Field;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ChannelManager;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SoundEngine;
import net.minecraft.client.audio.SoundEventAccessor;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.audio.SoundSource;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public class VanillaSoundUtils {
    @Nullable
    public static SoundSource getChannelOfInstance(ISound instance) {
        ChannelManager.Entry handle;
        Map<ISound, ChannelManager.Entry> instances = VanillaSoundUtils.getSoundEngineInstanceChannels();
        if (instances != null && (handle = instances.get(instance)) != null) {
            return VanillaSoundUtils.getChannelOfHandle(handle);
        }
        return null;
    }

    @Nullable
    public static ISound getInstanceOfChannel(SoundSource channel) {
        Map<ISound, ChannelManager.Entry> instances = VanillaSoundUtils.getSoundEngineInstanceChannels();
        if (instances != null) {
            for (Map.Entry<ISound, ChannelManager.Entry> m : instances.entrySet()) {
                SoundSource c = VanillaSoundUtils.getChannelOfHandle(m.getValue());
                if (c == null || c != channel) continue;
                return m.getKey();
            }
        }
        return null;
    }

    @Nullable
    public static SoundSource getChannelOfHandle(ChannelManager.Entry handle) {
        try {
            Field f = ObfuscationReflectionHelper.findField(ChannelManager.Entry.class, (String)"field_217893_b");
            return (SoundSource)f.get(handle);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Nullable
    public static Map<ISound, ChannelManager.Entry> getSoundEngineInstanceChannels() {
        try {
            Field f = ObfuscationReflectionHelper.findField(SoundEngine.class, (String)"field_217942_m");
            return (Map)f.get(VanillaSoundUtils.getSoundEngine());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Nullable
    public static SoundEngine getSoundEngine() {
        try {
            Field f = ObfuscationReflectionHelper.findField(SoundHandler.class, (String)"field_147694_f");
            return (SoundEngine)f.get(Minecraft.func_71410_x().func_147118_V());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Nullable
    public static Map<ResourceLocation, SoundEventAccessor> getSoundManagerRegistry() {
        try {
            Field f = ObfuscationReflectionHelper.findField(SoundHandler.class, (String)"field_147697_e");
            return (Map)f.get(Minecraft.func_71410_x().func_147118_V());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

