/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.auudio.audio;

import de.keksuccino.auudio.audio.AudioClipSound;
import de.keksuccino.auudio.audio.AudioClipSoundInstance;
import de.keksuccino.auudio.audio.AudioHandler;
import de.keksuccino.auudio.audio.VanillaSoundUtils;
import de.keksuccino.auudio.audio.exceptions.InvalidAudioException;
import de.keksuccino.auudio.audio.external.ExternalSound;
import de.keksuccino.auudio.audio.external.ExternalSoundResourceLocation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.ISoundEventAccessor;
import net.minecraft.client.audio.Sound;
import net.minecraft.client.audio.SoundEventAccessor;
import net.minecraft.client.audio.SoundSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import org.lwjgl.openal.AL10;

public class AudioClip {
    protected final SoundType soundType;
    protected ResourceLocation soundLocation;
    protected SoundEventAccessor soundEvents;
    protected AudioClipSound sound;
    protected AudioClipSoundInstance soundInstance;
    protected SoundSource channel = null;
    protected boolean looping = false;
    protected int volume = 100;
    protected SoundCategory soundSource;

    public AudioClip(@Nonnull ResourceLocation soundLocation, @Nonnull SoundType soundType) throws NullPointerException, InvalidAudioException {
        this(soundLocation, soundType, null);
    }

    public AudioClip(@Nonnull ResourceLocation soundLocation, @Nonnull SoundType soundType, @Nullable SoundCategory soundSource) throws NullPointerException, InvalidAudioException {
        if (soundLocation == null) {
            throw new NullPointerException("Sound location is NULL!");
        }
        if (soundType == null) {
            throw new NullPointerException("Sound type is NULL!");
        }
        if (soundLocation instanceof ExternalSoundResourceLocation && soundType == SoundType.INTERNAL_ASSET) {
            throw new InvalidAudioException("Trying to load an ExternalSoundResourceLocation as internal asset!");
        }
        if (!(soundLocation instanceof ExternalSoundResourceLocation) && soundType != SoundType.INTERNAL_ASSET) {
            throw new InvalidAudioException("Trying to load an internal asset ResourceLocation as external sound!");
        }
        if (soundLocation instanceof ExternalSoundResourceLocation && ((ExternalSoundResourceLocation)soundLocation).getSoundType() != soundType) {
            throw new InvalidAudioException("Sound type of external sound doesn't match clip sound type!");
        }
        this.soundLocation = soundLocation;
        this.soundType = soundType;
        this.soundSource = soundSource;
        if (this.soundSource == null) {
            this.soundSource = SoundCategory.MASTER;
        }
        this.prepare();
        AudioHandler.registerAudioClip(this);
    }

    public static AudioClip buildExternalClip(String soundPath, SoundType soundType, @Nullable SoundCategory soundSource) throws InvalidAudioException, NullPointerException {
        return new AudioClip(new ExternalSoundResourceLocation(soundPath, soundType), soundType, soundSource);
    }

    public static AudioClip buildExternalClip(String soundPath, SoundType soundType) throws InvalidAudioException, NullPointerException {
        return AudioClip.buildExternalClip(soundPath, soundType, null);
    }

    public static AudioClip buildInternalClip(ResourceLocation soundLocation, @Nullable SoundCategory soundSource) throws InvalidAudioException, NullPointerException {
        return new AudioClip(soundLocation, SoundType.INTERNAL_ASSET, soundSource);
    }

    public static AudioClip buildInternalClip(ResourceLocation soundLocation) throws InvalidAudioException, NullPointerException {
        return AudioClip.buildInternalClip(soundLocation, SoundCategory.MASTER);
    }

    public boolean prepare() {
        try {
            this.stop();
            this.channel = null;
            if (this.soundType == SoundType.EXTERNAL_LOCAL || this.soundType == SoundType.EXTERNAL_WEB) {
                this.soundInstance = new AudioClipSoundInstance(this, this.soundLocation, this.soundSource, 1.0f, 1.0f);
                this.soundEvents = new SoundEventAccessor(this.soundLocation, null);
                this.sound = new ExternalSound((ExternalSoundResourceLocation)this.soundLocation, 1.0f, 1.0f, 1, Sound.Type.FILE, false, 0);
                this.soundEvents.func_188715_a((ISoundEventAccessor)this.sound);
                VanillaSoundUtils.getSoundManagerRegistry().put(this.soundLocation, this.soundEvents);
                this.soundEvents.func_217867_a(VanillaSoundUtils.getSoundEngine());
                return true;
            }
            if (this.soundType == SoundType.INTERNAL_ASSET) {
                this.soundInstance = new AudioClipSoundInstance(this, this.soundLocation, this.soundSource, 1.0f, 1.0f);
                this.soundEvents = new SoundEventAccessor(this.soundLocation, null);
                this.sound = new AudioClipSound(this.soundLocation, 1.0f, 1.0f, 1, Sound.Type.FILE, false, false, 0);
                this.soundEvents.func_188715_a((ISoundEventAccessor)this.sound);
                VanillaSoundUtils.getSoundManagerRegistry().put(this.soundLocation, this.soundEvents);
                this.soundEvents.func_217867_a(VanillaSoundUtils.getSoundEngine());
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public void play() {
        if (!this.playing()) {
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)this.soundInstance);
            this.channel = VanillaSoundUtils.getChannelOfInstance((ISound)this.soundInstance);
            AudioHandler.updateVolumes();
        }
    }

    public boolean stopped() {
        if (this.channel != null) {
            return this.channel.func_216435_g();
        }
        return true;
    }

    public void pause() {
        if (this.playing() && this.channel != null) {
            this.channel.func_216439_d();
        }
    }

    public boolean paused() {
        try {
            if (this.channel != null) {
                return AL10.alGetSourcei((int)this.getChannelSource(), (int)4112) == 4115;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public void unpause() {
        if (this.channel != null) {
            this.channel.func_216437_e();
        }
    }

    public void stop() {
        if (this.soundInstance != null) {
            Minecraft.func_71410_x().func_147118_V().func_147683_b((ISound)this.soundInstance);
        }
        this.channel = null;
    }

    public boolean playing() {
        if (this.channel != null) {
            return this.getChannelState() == 4114;
        }
        return false;
    }

    private int getChannelState() {
        try {
            Method m = ObfuscationReflectionHelper.findMethod(SoundSource.class, (String)"func_216428_j", (Class[])new Class[0]);
            return (Integer)m.invoke((Object)this.channel, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public void setLooping(boolean b) {
        this.looping = b;
    }

    public boolean isLooping() {
        return this.looping;
    }

    public void setVolume(int percentage) {
        if (percentage < 0) {
            percentage = 0;
        }
        if (percentage > 100) {
            percentage = 100;
        }
        this.volume = percentage;
        AudioHandler.updateVolumes();
    }

    public int getVolume() {
        return this.volume;
    }

    public void destroy() {
        this.stop();
        this.sound = null;
        this.soundInstance = null;
        this.soundEvents = null;
        this.soundLocation = null;
        AudioHandler.unregisterAudioClip(this);
    }

    public SoundCategory getSoundSource() {
        return this.soundSource;
    }

    public String getSoundPath() {
        return this.soundLocation.func_110623_a();
    }

    public SoundType getSoundType() {
        return this.soundType;
    }

    public ResourceLocation getSoundLocation() {
        return this.soundLocation;
    }

    public AudioClipSoundInstance getSoundInstance() {
        return this.soundInstance;
    }

    public AudioClipSound getSound() {
        return this.sound;
    }

    public SoundEventAccessor getSoundEvents() {
        return this.soundEvents;
    }

    public int getChannelSource() {
        try {
            Field f = ObfuscationReflectionHelper.findField(SoundSource.class, (String)"field_216441_b");
            return (Integer)f.get(this.channel);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public static enum SoundType {
        EXTERNAL_WEB,
        EXTERNAL_LOCAL,
        INTERNAL_ASSET;

    }
}

