/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.autumnity.core.registry;

import com.minecraftabnormals.abnormals_core.core.util.BiomeUtil;
import com.minecraftabnormals.abnormals_core.core.util.registry.BiomeSubRegistryHelper;
import com.minecraftabnormals.autumnity.core.Autumnity;
import com.minecraftabnormals.autumnity.core.AutumnityConfig;
import com.mojang.datafixers.util.Pair;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeAmbience;
import net.minecraft.world.biome.BiomeGenerationSettings;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.biome.MoodSoundAmbience;
import net.minecraft.world.gen.surfacebuilders.ConfiguredSurfaceBuilders;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class AutumnityBiomes {
    private static final BiomeSubRegistryHelper HELPER = (BiomeSubRegistryHelper)Autumnity.REGISTRY_HELPER.getBiomeSubHelper();
    public static final BiomeSubRegistryHelper.KeyedBiome MAPLE_FOREST = HELPER.createBiome("maple_forest", () -> AutumnityBiomes.createMapleForestBiome(0.1f, 0.2f));
    public static final BiomeSubRegistryHelper.KeyedBiome MAPLE_FOREST_HILLS = HELPER.createBiome("maple_forest_hills", () -> AutumnityBiomes.createMapleForestBiome(0.45f, 0.3f));
    public static final BiomeSubRegistryHelper.KeyedBiome PUMPKIN_FIELDS = HELPER.createBiome("pumpkin_fields", () -> AutumnityBiomes.createPumpkinFieldsBiome());
    public static final BiomeSubRegistryHelper.KeyedBiome YELLOW_SPOTTED_FOREST = HELPER.createBiome("yellow_spotted_forest", () -> AutumnityBiomes.createYellowSpottedForestBiome());
    public static final BiomeSubRegistryHelper.KeyedBiome ORANGE_SPOTTED_DARK_FOREST = HELPER.createBiome("orange_spotted_dark_forest", () -> AutumnityBiomes.createOrangeSpottedDarkForest());
    public static final BiomeSubRegistryHelper.KeyedBiome RED_SPOTTED_TAIGA = HELPER.createBiome("red_spotted_taiga", () -> AutumnityBiomes.createRedSpottedTaigaBiome());

    public static void addBiomesToGeneration() {
        BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.COOL, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry(MAPLE_FOREST.getKey(), ((Integer)AutumnityConfig.COMMON.mapleForestWeight.get()).intValue()));
        BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.COOL, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry(MAPLE_FOREST_HILLS.getKey(), ((Integer)AutumnityConfig.COMMON.mapleForestHillsWeight.get()).intValue()));
        BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.COOL, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry(PUMPKIN_FIELDS.getKey(), ((Integer)AutumnityConfig.COMMON.pumpkinFieldsWeight.get()).intValue()));
        BiomeUtil.addHillBiome((RegistryKey)MAPLE_FOREST.getKey(), (Pair[])new Pair[]{Pair.of((Object)MAPLE_FOREST_HILLS.getKey(), (Object)1)});
        BiomeUtil.addHillBiome((RegistryKey)PUMPKIN_FIELDS.getKey(), (Pair[])new Pair[]{Pair.of((Object)MAPLE_FOREST.getKey(), (Object)2), Pair.of((Object)MAPLE_FOREST_HILLS.getKey(), (Object)1)});
        if (((Boolean)AutumnityConfig.COMMON.yellowSpottedForest.get()).booleanValue()) {
            BiomeUtil.addHillBiome((RegistryKey)Biomes.field_76767_f, (Pair[])new Pair[]{Pair.of((Object)YELLOW_SPOTTED_FOREST.getKey(), (Object)1)});
        }
        if (((Boolean)AutumnityConfig.COMMON.redSpottedTaiga.get()).booleanValue()) {
            BiomeUtil.addHillBiome((RegistryKey)Biomes.field_76768_g, (Pair[])new Pair[]{Pair.of((Object)RED_SPOTTED_TAIGA.getKey(), (Object)1)});
        }
        if (((Boolean)AutumnityConfig.COMMON.orangeSpottedDarkForest.get()).booleanValue()) {
            BiomeUtil.addHillBiome((RegistryKey)Biomes.field_150585_R, (Pair[])new Pair[]{Pair.of((Object)ORANGE_SPOTTED_DARK_FOREST.getKey(), (Object)1)});
        }
    }

    public static void addBiomeTypes() {
        BiomeDictionary.addTypes((RegistryKey)MAPLE_FOREST.getKey(), (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.FOREST, BiomeDictionary.Type.OVERWORLD});
        BiomeDictionary.addTypes((RegistryKey)MAPLE_FOREST_HILLS.getKey(), (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.FOREST, BiomeDictionary.Type.HILLS, BiomeDictionary.Type.RARE, BiomeDictionary.Type.OVERWORLD});
        BiomeDictionary.addTypes((RegistryKey)PUMPKIN_FIELDS.getKey(), (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.RARE, BiomeDictionary.Type.OVERWORLD});
        BiomeDictionary.addTypes((RegistryKey)YELLOW_SPOTTED_FOREST.getKey(), (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.FOREST, BiomeDictionary.Type.OVERWORLD});
        BiomeDictionary.addTypes((RegistryKey)ORANGE_SPOTTED_DARK_FOREST.getKey(), (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.SPOOKY, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.RARE, BiomeDictionary.Type.OVERWORLD});
        BiomeDictionary.addTypes((RegistryKey)RED_SPOTTED_TAIGA.getKey(), (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.COLD, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.OVERWORLD});
    }

    private static Biome createMapleForestBiome(float depth, float scale) {
        return new Biome.Builder().func_205415_a(Biome.RainType.RAIN).func_205419_a(Biome.Category.FOREST).func_205421_a(depth).func_205420_b(scale).func_205414_c(0.7f).func_205417_d(0.8f).func_235097_a_(new BiomeAmbience.Builder().func_235246_b_(4159204).func_235248_c_(329011).func_235239_a_(12638463).func_242539_d(AutumnityBiomes.getSkyColorWithTemperatureModifier(0.7f)).func_235243_a_(MoodSoundAmbience.field_235027_b_).func_242541_f(10139705).func_242540_e(10471748).func_235238_a_()).func_242458_a(new MobSpawnInfo.Builder().func_242577_b()).func_242457_a(new BiomeGenerationSettings.Builder().func_242517_a(ConfiguredSurfaceBuilders.field_244178_j).func_242508_a()).func_242455_a();
    }

    private static Biome createPumpkinFieldsBiome() {
        return new Biome.Builder().func_205415_a(Biome.RainType.RAIN).func_205419_a(Biome.Category.PLAINS).func_205421_a(0.125f).func_205420_b(0.05f).func_205414_c(0.8f).func_205417_d(0.4f).func_235097_a_(new BiomeAmbience.Builder().func_235246_b_(4159204).func_235248_c_(329011).func_235239_a_(12638463).func_242539_d(AutumnityBiomes.getSkyColorWithTemperatureModifier(0.8f)).func_235243_a_(MoodSoundAmbience.field_235027_b_).func_242541_f(10139705).func_242540_e(10471748).func_235238_a_()).func_242458_a(new MobSpawnInfo.Builder().func_242577_b()).func_242457_a(new BiomeGenerationSettings.Builder().func_242517_a(ConfiguredSurfaceBuilders.field_244178_j).func_242508_a()).func_242455_a();
    }

    private static Biome createYellowSpottedForestBiome() {
        return new Biome.Builder().func_205415_a(Biome.RainType.RAIN).func_205419_a(Biome.Category.FOREST).func_205421_a(0.1f).func_205420_b(0.2f).func_205414_c(0.7f).func_205417_d(0.8f).func_235097_a_(new BiomeAmbience.Builder().func_235246_b_(4159204).func_235248_c_(329011).func_235239_a_(12638463).func_242539_d(AutumnityBiomes.getSkyColorWithTemperatureModifier(0.7f)).func_235243_a_(MoodSoundAmbience.field_235027_b_).func_235238_a_()).func_242458_a(new MobSpawnInfo.Builder().func_242577_b()).func_242457_a(new BiomeGenerationSettings.Builder().func_242517_a(ConfiguredSurfaceBuilders.field_244178_j).func_242508_a()).func_242455_a();
    }

    private static Biome createOrangeSpottedDarkForest() {
        return new Biome.Builder().func_205415_a(Biome.RainType.RAIN).func_205419_a(Biome.Category.FOREST).func_205421_a(0.1f).func_205420_b(0.2f).func_205414_c(0.7f).func_205417_d(0.8f).func_235097_a_(new BiomeAmbience.Builder().func_235246_b_(4159204).func_235248_c_(329011).func_235239_a_(12638463).func_242539_d(AutumnityBiomes.getSkyColorWithTemperatureModifier(0.7f)).func_242537_a(BiomeAmbience.GrassColorModifier.DARK_FOREST).func_235243_a_(MoodSoundAmbience.field_235027_b_).func_235238_a_()).func_242458_a(new MobSpawnInfo.Builder().func_242577_b()).func_242457_a(new BiomeGenerationSettings.Builder().func_242517_a(ConfiguredSurfaceBuilders.field_244178_j).func_242508_a()).func_242455_a();
    }

    private static Biome createRedSpottedTaigaBiome() {
        return new Biome.Builder().func_205415_a(Biome.RainType.RAIN).func_205419_a(Biome.Category.TAIGA).func_205421_a(0.2f).func_205420_b(0.2f).func_205414_c(0.25f).func_205417_d(0.8f).func_235097_a_(new BiomeAmbience.Builder().func_235246_b_(4159204).func_235248_c_(329011).func_235239_a_(12638463).func_242539_d(AutumnityBiomes.getSkyColorWithTemperatureModifier(0.25f)).func_235243_a_(MoodSoundAmbience.field_235027_b_).func_235238_a_()).func_242458_a(new MobSpawnInfo.Builder().func_242577_b()).func_242457_a(new BiomeGenerationSettings.Builder().func_242517_a(ConfiguredSurfaceBuilders.field_244178_j).func_242508_a()).func_242455_a();
    }

    private static int getSkyColorWithTemperatureModifier(float temperature) {
        float lvt_1_1_ = temperature / 3.0f;
        lvt_1_1_ = MathHelper.func_76131_a((float)lvt_1_1_, (float)-1.0f, (float)1.0f);
        return MathHelper.func_181758_c((float)(0.62222224f - lvt_1_1_ * 0.05f), (float)(0.5f + lvt_1_1_ * 0.1f), (float)1.0f);
    }
}

