/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.autumnity.core;

import com.google.common.collect.Lists;
import com.minecraftabnormals.abnormals_core.core.annotations.ConfigKey;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class AutumnityConfig {
    static final ForgeConfigSpec COMMON_SPEC;
    public static final Common COMMON;

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Common::new);
        COMMON_SPEC = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
    }

    public static class Common {
        public final ForgeConfigSpec.ConfigValue<List<String>> snailSpawnBiomes;
        public final ForgeConfigSpec.ConfigValue<List<String>> turkeySpawnBiomes;
        public final ForgeConfigSpec.ConfigValue<List<String>> mapleTreeBiomes;
        @ConfigKey(value="maple_forest_weight")
        public final ForgeConfigSpec.ConfigValue<Integer> mapleForestWeight;
        @ConfigKey(value="maple_forest_hills_weight")
        public final ForgeConfigSpec.ConfigValue<Integer> mapleForestHillsWeight;
        @ConfigKey(value="pumpkin_fields_weight")
        public final ForgeConfigSpec.ConfigValue<Integer> pumpkinFieldsWeight;
        @ConfigKey(value="yellow_spotted_forest")
        public final ForgeConfigSpec.ConfigValue<Boolean> yellowSpottedForest;
        @ConfigKey(value="orange_spotted_dark_forest")
        public final ForgeConfigSpec.ConfigValue<Boolean> orangeSpottedDarkForest;
        @ConfigKey(value="red_spotted_taiga")
        public final ForgeConfigSpec.ConfigValue<Boolean> redSpottedTaiga;

        Common(ForgeConfigSpec.Builder builder) {
            builder.comment("Common configurations for Autumnity").push("common");
            builder.push("entities");
            this.snailSpawnBiomes = builder.comment("A list of biomes where snails can spawn. The list doesn't include biomes from this mod.").define("Snail Spawn Biomes", (Object)Lists.newArrayList());
            this.turkeySpawnBiomes = builder.comment(new String[]{"A list of biomes where turkeys can spawn. The list doesn't include biomes from this mod.", "Chickens will not spawn in these biomes."}).define("Turkey Spawn Biomes", (Object)Lists.newArrayList());
            builder.pop();
            builder.comment(new String[]{"Values for biome frequencies; lower = more rare. (Requires restart)", "If a biome has a default weight of 0, it generates as a sub-biome and not on its own."}).push("biome_weights");
            this.mapleForestWeight = builder.define("Maple Forest weight", (Object)6);
            this.mapleForestHillsWeight = builder.define("Maple Forest Hills weight", (Object)0);
            this.pumpkinFieldsWeight = builder.define("Pumpkin Fields weight", (Object)1);
            builder.pop();
            builder.push("misc");
            this.mapleTreeBiomes = builder.comment(new String[]{"A list of biomes where green maple trees can generate naturally.", "The list does not include biomes from this mod."}).define("Maple Tree Biomes", (Object)Lists.newArrayList((Object[])new String[]{"minecraft:forest", "minecraft:wooded_hills", "minecraft:flower_forest"}));
            this.yellowSpottedForest = builder.define("Yellow Spotted Forest", true);
            this.orangeSpottedDarkForest = builder.define("Orange Spotted Dark Forest", true);
            this.redSpottedTaiga = builder.define("Red Spotted Taiga", true);
            builder.pop();
        }
    }
}

