/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.autumnity.client.renderer.entity.model;

import com.google.common.collect.ImmutableList;
import com.minecraftabnormals.autumnity.common.entity.passive.TurkeyEntity;
import net.minecraft.client.renderer.entity.model.AgeableModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TurkeyModel<T extends TurkeyEntity>
extends AgeableModel<T> {
    private final ModelRenderer head;
    private final ModelRenderer beak;
    private final ModelRenderer waddle;
    private final ModelRenderer body;
    private final ModelRenderer rightWing;
    private final ModelRenderer leftWing;
    private final ModelRenderer tail;
    private final ModelRenderer rightLeg;
    private final ModelRenderer leftLeg;

    public TurkeyModel() {
        this.field_78090_t = 64;
        this.field_78089_u = 32;
        this.head = new ModelRenderer((Model)this, 0, 0);
        this.head.func_78793_a(0.0f, 14.0f, -3.0f);
        this.head.func_228302_a_(-2.0f, -5.0f, -2.0f, 4.0f, 6.0f, 3.0f, 0.0f, 0.0f, 0.0f);
        this.beak = new ModelRenderer((Model)this, 0, 9);
        this.beak.func_78793_a(0.0f, 0.0f, 0.0f);
        this.beak.func_228302_a_(-2.0f, -3.0f, -4.0f, 4.0f, 2.0f, 2.0f, 0.0f, 0.0f, 0.0f);
        this.waddle = new ModelRenderer((Model)this, 0, 13);
        this.waddle.func_78793_a(0.0f, 0.0f, 0.0f);
        this.waddle.func_228302_a_(-1.0f, -1.0f, -4.0f, 2.0f, 4.0f, 2.0f, 0.0f, 0.0f, 0.0f);
        this.head.func_78792_a(this.waddle);
        this.head.func_78792_a(this.beak);
        this.body = new ModelRenderer((Model)this, 0, 14);
        this.body.func_78793_a(0.0f, 21.0f, 1.0f);
        this.body.func_228302_a_(-5.0f, -8.0f, -5.0f, 10.0f, 8.0f, 10.0f, 0.0f, 0.0f, 0.0f);
        this.rightWing = new ModelRenderer((Model)this);
        this.rightWing.field_78809_i = true;
        this.rightWing.func_78793_a(5.0f, -8.0f, 0.0f);
        this.rightWing.func_78784_a(44, 0).func_228301_a_(0.0f, 0.0f, -4.0f, 2.0f, 6.0f, 8.0f, 0.0f);
        this.leftWing = new ModelRenderer((Model)this);
        this.leftWing.func_78793_a(-5.0f, -8.0f, 0.0f);
        this.leftWing.func_78784_a(44, 0).func_228301_a_(-2.0f, 0.0f, -4.0f, 2.0f, 6.0f, 8.0f, 0.0f);
        this.tail = new ModelRenderer((Model)this, 16, 4);
        this.tail.func_78793_a(0.0f, -7.0f, 4.0f);
        this.tail.func_228302_a_(-7.0f, -10.0f, 0.0f, 14.0f, 10.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        this.setRotateAngle(this.tail, -0.7853982f, 0.0f, 0.0f);
        this.body.func_78792_a(this.leftWing);
        this.body.func_78792_a(this.rightWing);
        this.body.func_78792_a(this.tail);
        this.rightLeg = new ModelRenderer((Model)this, 30, 17);
        this.rightLeg.func_78793_a(-3.0f, 20.0f, 1.0f);
        this.rightLeg.func_228302_a_(-1.5f, 0.0f, -3.0f, 3.0f, 4.0f, 3.0f, 0.0f, 0.0f, 0.0f);
        this.leftLeg = new ModelRenderer((Model)this, 30, 17);
        this.leftLeg.field_78809_i = true;
        this.leftLeg.func_78793_a(3.0f, 20.0f, 1.0f);
        this.leftLeg.func_228302_a_(-1.5f, 0.0f, -3.0f, 3.0f, 4.0f, 3.0f, 0.0f, 0.0f, 0.0f);
    }

    protected Iterable<ModelRenderer> func_225602_a_() {
        return ImmutableList.of((Object)this.head);
    }

    protected Iterable<ModelRenderer> func_225600_b_() {
        return ImmutableList.of((Object)this.body, (Object)this.rightLeg, (Object)this.leftLeg);
    }

    public void setupAnim(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float partialtick = ageInTicks - (float)((TurkeyEntity)entityIn).field_70173_aa;
        float winganim = ((TurkeyEntity)entityIn).getWingRotation(partialtick);
        float peckanim = ((TurkeyEntity)entityIn).getPeckProgress(partialtick);
        this.head.field_78795_f = headPitch * ((float)Math.PI / 180);
        this.head.field_78796_g = netHeadYaw * ((float)Math.PI / 180);
        this.head.field_78795_f += peckanim * 0.8f;
        this.head.field_78798_e = -3.0f - peckanim * 1.5f;
        this.rightWing.field_78808_h = -winganim;
        this.leftWing.field_78808_h = winganim;
        this.rightLeg.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.leftLeg.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
    }

    public void setRotateAngle(ModelRenderer modelRenderer, float x, float y, float z) {
        modelRenderer.field_78795_f = x;
        modelRenderer.field_78796_g = y;
        modelRenderer.field_78808_h = z;
    }
}

