/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.atmospheric.core.registry;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.minecraftabnormals.atmospheric.common.block.YuccaFlowerDoubleBlock;
import com.minecraftabnormals.atmospheric.common.world.gen.feature.AloeVeraFeature;
import com.minecraftabnormals.atmospheric.common.world.gen.feature.AspenTreeFeature;
import com.minecraftabnormals.atmospheric.common.world.gen.feature.BarrelCactusFeature;
import com.minecraftabnormals.atmospheric.common.world.gen.feature.CoarseDirtPatchFeature;
import com.minecraftabnormals.atmospheric.common.world.gen.feature.DuneRocksFeature;
import com.minecraftabnormals.atmospheric.common.world.gen.feature.MonkeyBrushFeature;
import com.minecraftabnormals.atmospheric.common.world.gen.feature.PassionVineFeature;
import com.minecraftabnormals.atmospheric.common.world.gen.feature.PodzolFeature;
import com.minecraftabnormals.atmospheric.common.world.gen.feature.RainforestTreeFeature;
import com.minecraftabnormals.atmospheric.common.world.gen.feature.SurfaceFossilFeature;
import com.minecraftabnormals.atmospheric.common.world.gen.feature.WaterHyacinthPatchFeature;
import com.minecraftabnormals.atmospheric.common.world.gen.feature.YuccaFlowerFeature;
import com.minecraftabnormals.atmospheric.common.world.gen.feature.YuccaTreeFeature;
import com.minecraftabnormals.atmospheric.common.world.gen.feature.config.LargeSphereReplaceConfig;
import com.minecraftabnormals.atmospheric.common.world.gen.feature.config.YuccaTreeFeatureConfig;
import com.minecraftabnormals.atmospheric.core.registry.AtmosphericBlocks;
import com.mojang.serialization.Codec;
import java.util.List;
import java.util.OptionalInt;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.state.Property;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.blockplacer.BlockPlacer;
import net.minecraft.world.gen.blockplacer.SimpleBlockPlacer;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.SimpleBlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.WeightedBlockStateProvider;
import net.minecraft.world.gen.feature.AbstractFeatureSizeType;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.feature.BlockClusterFeatureConfig;
import net.minecraft.world.gen.feature.BlockStateFeatureConfig;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.FeatureSpread;
import net.minecraft.world.gen.feature.Features;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.MultipleRandomFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.ProbabilityConfig;
import net.minecraft.world.gen.feature.TwoLayerFeature;
import net.minecraft.world.gen.foliageplacer.BlobFoliagePlacer;
import net.minecraft.world.gen.foliageplacer.BushFoliagePlacer;
import net.minecraft.world.gen.foliageplacer.FancyFoliagePlacer;
import net.minecraft.world.gen.foliageplacer.FoliagePlacer;
import net.minecraft.world.gen.foliageplacer.SpruceFoliagePlacer;
import net.minecraft.world.gen.placement.AtSurfaceWithExtraConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraft.world.gen.placement.TopSolidWithNoiseConfig;
import net.minecraft.world.gen.treedecorator.TreeDecorator;
import net.minecraft.world.gen.trunkplacer.AbstractTrunkPlacer;
import net.minecraft.world.gen.trunkplacer.FancyTrunkPlacer;
import net.minecraft.world.gen.trunkplacer.StraightTrunkPlacer;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

@Mod.EventBusSubscriber(modid="atmospheric", bus=Mod.EventBusSubscriber.Bus.MOD)
public class AtmosphericFeatures {
    public static final DeferredRegister<Feature<?>> FEATURES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FEATURES, (String)"atmospheric");
    public static final RegistryObject<Feature<ProbabilityConfig>> PODZOL = FEATURES.register("podzol", () -> new PodzolFeature((Codec<ProbabilityConfig>)ProbabilityConfig.field_236576_b_));
    public static final RegistryObject<Feature<NoFeatureConfig>> SURFACE_FOSSIL = FEATURES.register("surface_fossil", () -> new SurfaceFossilFeature((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static final RegistryObject<Feature<LargeSphereReplaceConfig>> COARSE_DIRT_PATCH = FEATURES.register("coarse_dirt_patch", () -> new CoarseDirtPatchFeature(LargeSphereReplaceConfig.CODEC));
    public static final RegistryObject<Feature<NoFeatureConfig>> WARM_MONKEY_BRUSH = FEATURES.register("warm_monkey_brush", () -> new MonkeyBrushFeature((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_, 1));
    public static final RegistryObject<Feature<NoFeatureConfig>> HOT_MONKEY_BRUSH = FEATURES.register("hot_monkey_brush", () -> new MonkeyBrushFeature((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_, 2));
    public static final RegistryObject<Feature<NoFeatureConfig>> SCALDING_MONKEY_BRUSH = FEATURES.register("scalding_monkey_brush", () -> new MonkeyBrushFeature((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_, 3));
    public static final RegistryObject<Feature<NoFeatureConfig>> WATER_HYACINTH_PATCH = FEATURES.register("water_hyacinth_patch", () -> new WaterHyacinthPatchFeature((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static final RegistryObject<Feature<BaseTreeFeatureConfig>> ROSEWOOD_TREE = FEATURES.register("rosewood_tree", () -> new RainforestTreeFeature((Codec<BaseTreeFeatureConfig>)BaseTreeFeatureConfig.field_236676_a_, false));
    public static final RegistryObject<Feature<BaseTreeFeatureConfig>> ROSEWOOD_WATER_TREE = FEATURES.register("rosewood_water_tree", () -> new RainforestTreeFeature((Codec<BaseTreeFeatureConfig>)BaseTreeFeatureConfig.field_236676_a_, true));
    public static final RegistryObject<Feature<YuccaTreeFeatureConfig>> YUCCA_TREE = FEATURES.register("yucca_tree", () -> new YuccaTreeFeature(YuccaTreeFeatureConfig.CODEC));
    public static final RegistryObject<Feature<BaseTreeFeatureConfig>> ASPEN_TREE = FEATURES.register("aspen_tree", () -> new AspenTreeFeature((Codec<BaseTreeFeatureConfig>)BaseTreeFeatureConfig.field_236676_a_));
    public static final RegistryObject<Feature<NoFeatureConfig>> PASSION_VINE = FEATURES.register("passion_vine", () -> new PassionVineFeature((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static final RegistryObject<Feature<BlockClusterFeatureConfig>> BARREL_CACTUS = FEATURES.register("barrel_cactus", () -> new BarrelCactusFeature((Codec<BlockClusterFeatureConfig>)BlockClusterFeatureConfig.field_236587_a_));
    public static final RegistryObject<Feature<BlockClusterFeatureConfig>> ALOE_VERA = FEATURES.register("aloe_vera", () -> new AloeVeraFeature((Codec<BlockClusterFeatureConfig>)BlockClusterFeatureConfig.field_236587_a_));
    public static final RegistryObject<Feature<BlockClusterFeatureConfig>> YUCCA_FLOWER = FEATURES.register("yucca_flower", () -> new YuccaFlowerFeature((Codec<BlockClusterFeatureConfig>)BlockClusterFeatureConfig.field_236587_a_));
    public static final RegistryObject<Feature<BlockStateFeatureConfig>> DUNE_ROCKS = FEATURES.register("dune_rocks", () -> new DuneRocksFeature((Codec<BlockStateFeatureConfig>)BlockStateFeatureConfig.field_236455_a_));

    public static final class Configured {
        public static final ConfiguredFeature<?, ?> PODZOL = ((Feature)PODZOL.get()).func_225566_b_((IFeatureConfig)new ProbabilityConfig(0.2f)).func_227228_a_(Placement.field_242901_e.func_227446_a_((IPlacementConfig)new TopSolidWithNoiseConfig(160, 80.0, 0.3))).func_227228_a_(Placement.field_215036_v.func_227446_a_((IPlacementConfig)IPlacementConfig.field_202468_e));
        public static final ConfiguredFeature<?, ?> PASSION_VINES = (ConfiguredFeature)((Feature)PASSION_VINE.get()).func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Features.Placements.field_244002_m).func_242731_b(1);
        public static final ConfiguredFeature<?, ?> RAINFOREST_BUSH = Feature.field_236291_c_.func_225566_b_((IFeatureConfig)Configs.OAK_GROUND_BUSH_CONFIG).func_227228_a_(Features.Placements.field_244001_l).func_227228_a_(Placement.field_242902_f.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(2, 0.1f, 1)));
        public static final ConfiguredFeature<?, ?> PATCH_WARM_MONKEY_BRUSH = (ConfiguredFeature)((Feature)WARM_MONKEY_BRUSH.get()).func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Features.Placements.field_244002_m).func_242731_b(3);
        public static final ConfiguredFeature<?, ?> PATCH_HOT_MONKEY_BRUSH = (ConfiguredFeature)((Feature)HOT_MONKEY_BRUSH.get()).func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Features.Placements.field_244002_m).func_242731_b(2);
        public static final ConfiguredFeature<?, ?> PATCH_SCALDING_MONKEY_BRUSH = (ConfiguredFeature)((Feature)SCALDING_MONKEY_BRUSH.get()).func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Features.Placements.field_244002_m).func_242731_b(1);
        public static final ConfiguredFeature<?, ?> PATCH_WATER_HYACINTH = (ConfiguredFeature)((Feature)WATER_HYACINTH_PATCH.get()).func_225566_b_((IFeatureConfig)NoFeatureConfig.field_202429_e).func_227228_a_(Features.Placements.field_244002_m).func_242731_b(2);
        public static final ConfiguredFeature<?, ?> PATCH_WATER_HYACINTH_SPARSE = (ConfiguredFeature)((Feature)WATER_HYACINTH_PATCH.get()).func_225566_b_((IFeatureConfig)NoFeatureConfig.field_202429_e).func_227228_a_(Features.Placements.field_244002_m).func_242731_b(1);
        public static final ConfiguredFeature<?, ?> PATCH_WATERLILLY_RAINFOREST = (ConfiguredFeature)Feature.field_227248_z_.func_225566_b_((IFeatureConfig)new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(Blocks.field_196651_dG.func_176223_P()), (BlockPlacer)SimpleBlockPlacer.field_236447_c_).func_227315_a_(10).func_227322_d_()).func_227228_a_(Features.Placements.field_244002_m).func_242731_b(1);
        public static final ConfiguredFeature<?, ?> OAK_TREE_RAINFOREST = Feature.field_202292_al.func_225566_b_((IFeatureConfig)new MultipleRandomFeatureConfig((List)ImmutableList.of((Object)Features.field_243922_ce.func_227227_a_(0.33333334f)), Features.field_243879_bY)).func_227228_a_(Features.Placements.field_244001_l).func_227228_a_(Placement.field_242902_f.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(0, 0.05f, 1)));
        public static final ConfiguredFeature<?, ?> ROSEWOOD_TREE = ((Feature)ROSEWOOD_TREE.get()).func_225566_b_((IFeatureConfig)Configs.ROSEWOOD_TREE_WITH_FEW_BEEHIVES_CONFIG).func_227228_a_(Features.Placements.field_244001_l).func_227228_a_(Placement.field_242902_f.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(10, 0.1f, 1)));
        public static final ConfiguredFeature<?, ?> ROSEWOOD_TREE_EXTRA = ((Feature)ROSEWOOD_TREE.get()).func_225566_b_((IFeatureConfig)Configs.ROSEWOOD_TREE_WITH_FEW_BEEHIVES_CONFIG).func_227228_a_(Features.Placements.field_244001_l).func_227228_a_(Placement.field_242902_f.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(13, 0.1f, 1)));
        public static final ConfiguredFeature<?, ?> ROSEWOOD_TREE_SPARSE = ((Feature)ROSEWOOD_TREE.get()).func_225566_b_((IFeatureConfig)Configs.ROSEWOOD_TREE_WITH_FEW_BEEHIVES_CONFIG).func_227228_a_(Features.Placements.field_244001_l).func_227228_a_(Placement.field_242902_f.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(0, 0.1f, 4)));
        public static final ConfiguredFeature<?, ?> ROSEWOOD_WATER_TREE = ((Feature)ROSEWOOD_WATER_TREE.get()).func_225566_b_((IFeatureConfig)Configs.ROSEWOOD_TREE_WITH_FEW_BEEHIVES_CONFIG).func_227228_a_(Features.Placements.field_244003_n).func_227228_a_(Placement.field_242902_f.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(32, 0.0f, 0)));
        public static final ConfiguredFeature<?, ?> ROSEWOOD_WATER_TREE_SPARSE = ((Feature)ROSEWOOD_WATER_TREE.get()).func_225566_b_((IFeatureConfig)Configs.ROSEWOOD_TREE_WITH_FEW_BEEHIVES_CONFIG).func_227228_a_(Features.Placements.field_244003_n).func_227228_a_(Placement.field_242902_f.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(2, 0.0f, 0)));
        public static final ConfiguredFeature<?, ?> MORADO_TREE = ((Feature)ROSEWOOD_TREE.get()).func_225566_b_((IFeatureConfig)Configs.MORADO_TREE_WITH_FEW_BEEHIVES_CONFIG).func_227228_a_(Features.Placements.field_244001_l).func_227228_a_(Placement.field_242902_f.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(1, 0.05f, 1)));
        public static final ConfiguredFeature<?, ?> MORADO_TREE_SPARSE = ((Feature)ROSEWOOD_TREE.get()).func_225566_b_((IFeatureConfig)Configs.MORADO_TREE_WITH_FEW_BEEHIVES_CONFIG).func_227228_a_(Features.Placements.field_244001_l).func_227228_a_(Placement.field_242902_f.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(0, 0.05f, 1)));
        public static final ConfiguredFeature<?, ?> MORADO_WATER_TREE = ((Feature)ROSEWOOD_WATER_TREE.get()).func_225566_b_((IFeatureConfig)Configs.MORADO_TREE_WITH_FEW_BEEHIVES_CONFIG).func_227228_a_(Features.Placements.field_244003_n).func_227228_a_(Placement.field_242902_f.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(2, 0.0f, 0)));
        public static final ConfiguredFeature<?, ?> MORADO_WATER_TREE_SPARSE = ((Feature)ROSEWOOD_WATER_TREE.get()).func_225566_b_((IFeatureConfig)Configs.MORADO_TREE_WITH_FEW_BEEHIVES_CONFIG).func_227228_a_(Features.Placements.field_244003_n).func_227228_a_(Placement.field_242902_f.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(1, 0.0f, 0)));
        public static final ConfiguredFeature<?, ?> DUNE_ROCK = (ConfiguredFeature)((Feature)DUNE_ROCKS.get()).func_225566_b_((IFeatureConfig)new BlockStateFeatureConfig(((Block)AtmosphericBlocks.ARID_SANDSTONE.get()).func_176223_P())).func_227228_a_(Features.Placements.field_244001_l).func_242732_c(2);
        public static final ConfiguredFeature<?, ?> DUNE_ROCK_EXTRA = (ConfiguredFeature)((Feature)DUNE_ROCKS.get()).func_225566_b_((IFeatureConfig)new BlockStateFeatureConfig(((Block)AtmosphericBlocks.ARID_SANDSTONE.get()).func_176223_P())).func_227228_a_(Features.Placements.field_244001_l).func_242732_c(3);
        public static final ConfiguredFeature<?, ?> DUNE_ROCK_MANY = (ConfiguredFeature)((Feature)DUNE_ROCKS.get()).func_225566_b_((IFeatureConfig)new BlockStateFeatureConfig(((Block)AtmosphericBlocks.ARID_SANDSTONE.get()).func_176223_P())).func_227228_a_(Features.Placements.field_244001_l).func_242732_c(6);
        public static final ConfiguredFeature<?, ?> FOSSIL_SURFACE = (ConfiguredFeature)((Feature)SURFACE_FOSSIL.get()).func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_242729_a(64);
        public static final ConfiguredFeature<?, ?> PATCH_YUCCA_FLOWER = (ConfiguredFeature)((Feature)YUCCA_FLOWER.get()).func_225566_b_((IFeatureConfig)Configs.YUCCA_FLOWER_CONFIG).func_227228_a_(Features.Placements.field_244002_m).func_242731_b(2);
        public static final ConfiguredFeature<?, ?> PATCH_YUCCA_FLOWER_EXTRA = (ConfiguredFeature)((Feature)YUCCA_FLOWER.get()).func_225566_b_((IFeatureConfig)Configs.YUCCA_FLOWER_CONFIG).func_227228_a_(Features.Placements.field_244002_m).func_242731_b(5);
        public static final ConfiguredFeature<?, ?> PATCH_GILIA = (ConfiguredFeature)Feature.field_227247_y_.func_225566_b_((IFeatureConfig)Configs.GILIA_CONFIG).func_227228_a_(Features.Placements.field_244002_m).func_242731_b(18);
        public static final ConfiguredFeature<?, ?> PATCH_ALOE_VERA = (ConfiguredFeature)((Feature)ALOE_VERA.get()).func_225566_b_((IFeatureConfig)Configs.ALOE_VERA_CONFIG).func_227228_a_(Features.Placements.field_244002_m).func_242731_b(2);
        public static final ConfiguredFeature<?, ?> PATCH_ALOE_VERA_EXTRA = (ConfiguredFeature)((Feature)ALOE_VERA.get()).func_225566_b_((IFeatureConfig)Configs.ALOE_VERA_CONFIG).func_227228_a_(Features.Placements.field_244002_m).func_242731_b(6);
        public static final ConfiguredFeature<?, ?> PATCH_BARREL_CACTUS_DUNES = ((Feature)BARREL_CACTUS.get()).func_225566_b_((IFeatureConfig)Configs.BARREL_CACTUS_CONFIG).func_227228_a_(Features.Placements.field_244001_l).func_227228_a_(Placement.field_242902_f.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(0, 0.075f, 2)));
        public static final ConfiguredFeature<?, ?> PATCH_BARREL_CACTUS_ROCKY_DUNES = ((Feature)BARREL_CACTUS.get()).func_225566_b_((IFeatureConfig)Configs.BARREL_CACTUS_CONFIG).func_227228_a_(Features.Placements.field_244001_l).func_227228_a_(Placement.field_242902_f.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(0, 0.075f, 1)));
        public static final ConfiguredFeature<?, ?> PATCH_BARREL_CACTUS_FLOURISHING_DUNES = ((Feature)BARREL_CACTUS.get()).func_225566_b_((IFeatureConfig)Configs.BARREL_CACTUS_CONFIG).func_227228_a_(Features.Placements.field_244001_l).func_227228_a_(Placement.field_242902_f.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(0, 0.5f, 4)));
        public static final ConfiguredFeature<?, ?> PATCH_BARREL_CACTUS_PETRIFIED_DUNES = ((Feature)BARREL_CACTUS.get()).func_225566_b_((IFeatureConfig)Configs.BARREL_CACTUS_CONFIG).func_227228_a_(Features.Placements.field_244001_l).func_227228_a_(Placement.field_242902_f.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(0, 0.1f, 1)));
        public static final ConfiguredFeature<?, ?> PATCH_DUNE_GRASS = ((Feature)COARSE_DIRT_PATCH.get()).func_225566_b_((IFeatureConfig)new LargeSphereReplaceConfig(Blocks.field_196660_k.func_176223_P(), FeatureSpread.func_242253_a((int)7, (int)1), 2, Lists.newArrayList((Object[])new BlockState[]{((Block)AtmosphericBlocks.RED_ARID_SAND.get()).func_176223_P(), ((Block)AtmosphericBlocks.ARID_SAND.get()).func_176223_P()}))).func_227228_a_(Features.Placements.field_244001_l).func_227228_a_(Placement.field_242902_f.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(0, 0.8f, 1)));
        public static final ConfiguredFeature<?, ?> PATCH_ARID_SPROUTS = Feature.field_227248_z_.func_225566_b_((IFeatureConfig)Configs.ARID_SPROUTS_CONFIG).func_227228_a_(Features.Placements.field_244002_m);
        public static final ConfiguredFeature<?, ?> YUCCA_TREE = Feature.field_202292_al.func_225566_b_((IFeatureConfig)new MultipleRandomFeatureConfig((List)ImmutableList.of((Object)((Feature)YUCCA_TREE.get()).func_225566_b_((IFeatureConfig)Configs.YUCCA_TREE_WITH_PATCH_CONFIG).func_227227_a_(0.25f)), ((Feature)YUCCA_TREE.get()).func_225566_b_((IFeatureConfig)Configs.YUCCA_TREE_CONFIG))).func_227228_a_(Features.Placements.field_244001_l).func_227228_a_(Placement.field_242902_f.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(0, 0.25f, 1)));
        public static final ConfiguredFeature<?, ?> YUCCA_TREE_BEEHIVE = ((Feature)YUCCA_TREE.get()).func_225566_b_((IFeatureConfig)Configs.YUCCA_TREE_WITH_MORE_BEEHIVES_AND_PATCH_CONFIG).func_227228_a_(Features.Placements.field_244001_l).func_227228_a_(Placement.field_242902_f.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(0, 0.25f, 1)));
        public static final ConfiguredFeature<?, ?> YUCCA_TREE_BABY = Feature.field_202292_al.func_225566_b_((IFeatureConfig)new MultipleRandomFeatureConfig((List)ImmutableList.of((Object)((Feature)YUCCA_TREE.get()).func_225566_b_((IFeatureConfig)Configs.BABY_YUCCA_TREE_WITH_PATCH_CONFIG).func_227227_a_(0.25f)), ((Feature)YUCCA_TREE.get()).func_225566_b_((IFeatureConfig)Configs.BABY_YUCCA_TREE_CONFIG))).func_227228_a_(Features.Placements.field_244001_l).func_227228_a_(Placement.field_242902_f.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(2, 0.05f, 1)));
        public static final ConfiguredFeature<?, ?> YUCCA_TREE_ROCKY_DUNES = Feature.field_202292_al.func_225566_b_((IFeatureConfig)new MultipleRandomFeatureConfig((List)ImmutableList.of((Object)((Feature)YUCCA_TREE.get()).func_225566_b_((IFeatureConfig)Configs.YUCCA_TREE_WITH_PATCH_CONFIG).func_227227_a_(0.25f)), ((Feature)YUCCA_TREE.get()).func_225566_b_((IFeatureConfig)Configs.YUCCA_TREE_CONFIG))).func_227228_a_(Features.Placements.field_244001_l).func_227228_a_(Placement.field_242902_f.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(0, 0.1f, 1)));
        public static final ConfiguredFeature<?, ?> YUCCA_TREE_SAVANNA = Feature.field_202292_al.func_225566_b_((IFeatureConfig)new MultipleRandomFeatureConfig((List)ImmutableList.of((Object)((Feature)YUCCA_TREE.get()).func_225566_b_((IFeatureConfig)Configs.YUCCA_TREE_WITH_PATCH_CONFIG).func_227227_a_(0.25f)), ((Feature)YUCCA_TREE.get()).func_225566_b_((IFeatureConfig)Configs.YUCCA_TREE_CONFIG))).func_227228_a_(Features.Placements.field_244001_l).func_227228_a_(Placement.field_242902_f.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(0, 0.15f, 1)));
        public static final ConfiguredFeature<?, ?> YUCCA_TREE_DESERT = Feature.field_202292_al.func_225566_b_((IFeatureConfig)new MultipleRandomFeatureConfig((List)ImmutableList.of((Object)((Feature)YUCCA_TREE.get()).func_225566_b_((IFeatureConfig)Configs.YUCCA_TREE_WITH_PATCH_CONFIG).func_227227_a_(0.25f)), ((Feature)YUCCA_TREE.get()).func_225566_b_((IFeatureConfig)Configs.YUCCA_TREE_CONFIG))).func_227228_a_(Features.Placements.field_244001_l).func_227228_a_(Placement.field_242902_f.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(0, 0.005f, 1)));
        public static final ConfiguredFeature<?, ?> YUCCA_TREE_PETRIFIED = Feature.field_202292_al.func_225566_b_((IFeatureConfig)new MultipleRandomFeatureConfig((List)ImmutableList.of((Object)((Feature)YUCCA_TREE.get()).func_225566_b_((IFeatureConfig)Configs.RED_ARID_YUCCA_TREE_CONFIG).func_227227_a_(0.25f)), ((Feature)YUCCA_TREE.get()).func_225566_b_((IFeatureConfig)Configs.ARID_YUCCA_TREE_CONFIG))).func_227228_a_(Features.Placements.field_244001_l).func_227228_a_(Placement.field_242902_f.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(0, 0.5f, 2)));

        private static <FC extends IFeatureConfig> void register(String name, ConfiguredFeature<FC, ?> configuredFeature) {
            Registry.func_218322_a((Registry)WorldGenRegistries.field_243653_e, (ResourceLocation)new ResourceLocation("atmospheric", name), configuredFeature);
        }

        public static void registerConfiguredFeatures() {
            Configured.register("podzol", PODZOL);
            Configured.register("passion_vines", PASSION_VINES);
            Configured.register("rainforest_bush", RAINFOREST_BUSH);
            Configured.register("patch_warm_monkey_brush", PATCH_WARM_MONKEY_BRUSH);
            Configured.register("patch_hot_monkey_brush", PATCH_HOT_MONKEY_BRUSH);
            Configured.register("patch_scalding_monkey_brush", PATCH_SCALDING_MONKEY_BRUSH);
            Configured.register("patch_water_hyacinth", PATCH_WATER_HYACINTH);
            Configured.register("patch_water_hyacinth_sparse", PATCH_WATER_HYACINTH_SPARSE);
            Configured.register("patch_waterlilly_rainforest", PATCH_WATERLILLY_RAINFOREST);
            Configured.register("oak_tree_rainforest", OAK_TREE_RAINFOREST);
            Configured.register("rosewood_tree", ROSEWOOD_TREE);
            Configured.register("rosewood_tree_extra", ROSEWOOD_TREE_EXTRA);
            Configured.register("rosewood_tree_sparse", ROSEWOOD_TREE_SPARSE);
            Configured.register("rosewood_water_tree", ROSEWOOD_WATER_TREE);
            Configured.register("rosewood_water_tree_sparse", ROSEWOOD_WATER_TREE_SPARSE);
            Configured.register("morado_tree", MORADO_TREE);
            Configured.register("morado_tree_sparse", MORADO_TREE_SPARSE);
            Configured.register("morado_water_tree", MORADO_WATER_TREE);
            Configured.register("morado_water_tree_sparse", MORADO_WATER_TREE_SPARSE);
            Configured.register("dune_rock", DUNE_ROCK);
            Configured.register("dune_rock_extra", DUNE_ROCK_EXTRA);
            Configured.register("dune_rock_many", DUNE_ROCK_MANY);
            Configured.register("fossil_surface", FOSSIL_SURFACE);
            Configured.register("patch_yucca_flower", PATCH_YUCCA_FLOWER);
            Configured.register("patch_yucca_flower_extra", PATCH_YUCCA_FLOWER_EXTRA);
            Configured.register("patch_gilia", PATCH_GILIA);
            Configured.register("patch_aloe_vera", PATCH_ALOE_VERA);
            Configured.register("patch_aloe_vera_extra", PATCH_ALOE_VERA_EXTRA);
            Configured.register("patch_barrel_cactus_dunes", PATCH_BARREL_CACTUS_DUNES);
            Configured.register("patch_barrel_cactus_rocky_dunes", PATCH_BARREL_CACTUS_ROCKY_DUNES);
            Configured.register("patch_barrel_cactus_flourishing_dunes", PATCH_BARREL_CACTUS_FLOURISHING_DUNES);
            Configured.register("patch_barrel_cactus_petrified_dunes", PATCH_BARREL_CACTUS_PETRIFIED_DUNES);
            Configured.register("patch_dune_grass", PATCH_DUNE_GRASS);
            Configured.register("patch_arid_sprouts", PATCH_ARID_SPROUTS);
            Configured.register("yucca_tree", YUCCA_TREE);
            Configured.register("yucca_tree_beehive", YUCCA_TREE_BEEHIVE);
            Configured.register("yucca_tree_baby", YUCCA_TREE_BABY);
            Configured.register("yucca_tree_rocky_dunes", YUCCA_TREE_ROCKY_DUNES);
            Configured.register("yucca_tree_savanna", YUCCA_TREE_SAVANNA);
            Configured.register("yucca_tree_desert", YUCCA_TREE_DESERT);
            Configured.register("yucca_tree_petrified", YUCCA_TREE_PETRIFIED);
        }
    }

    public static final class Configs {
        public static final YuccaTreeFeatureConfig.Builder YUCCA_TREE_BUILDER = new YuccaTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(States.YUCCA_LOG), (BlockStateProvider)new SimpleBlockStateProvider(States.YUCCA_LEAVES), (BlockStateProvider)new SimpleBlockStateProvider(States.YUCCA_BRANCH), (BlockStateProvider)new SimpleBlockStateProvider(States.YUCCA_BUNDLE), (BlockStateProvider)new SimpleBlockStateProvider(States.YUCCA_FLOWER), (BlockStateProvider)new SimpleBlockStateProvider(States.TALL_YUCCA_FLOWER_TOP), (BlockStateProvider)new SimpleBlockStateProvider(States.TALL_YUCCA_FLOWER_BOTTOM));
        public static final YuccaTreeFeatureConfig.Builder ARID_YUCCA_TREE_BUILDER = new YuccaTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(States.ARID_SANDSTONE), (BlockStateProvider)new SimpleBlockStateProvider(States.ARID_SANDSTONE), (BlockStateProvider)new SimpleBlockStateProvider(States.ARID_SANDSTONE_WALL), (BlockStateProvider)new SimpleBlockStateProvider(States.ROASTED_YUCCA_BUNDLE), (BlockStateProvider)new SimpleBlockStateProvider(States.ARID_SANDSTONE_WALL), (BlockStateProvider)new SimpleBlockStateProvider(States.ARID_SANDSTONE_WALL), (BlockStateProvider)new SimpleBlockStateProvider(States.ARID_SANDSTONE_WALL));
        public static final YuccaTreeFeatureConfig.Builder RED_ARID_YUCCA_TREE_BUILDER = new YuccaTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(States.RED_ARID_SANDSTONE), (BlockStateProvider)new SimpleBlockStateProvider(States.RED_ARID_SANDSTONE), (BlockStateProvider)new SimpleBlockStateProvider(States.RED_ARID_SANDSTONE_WALL), (BlockStateProvider)new SimpleBlockStateProvider(States.ROASTED_YUCCA_BUNDLE), (BlockStateProvider)new SimpleBlockStateProvider(States.RED_ARID_SANDSTONE_WALL), (BlockStateProvider)new SimpleBlockStateProvider(States.RED_ARID_SANDSTONE_WALL), (BlockStateProvider)new SimpleBlockStateProvider(States.RED_ARID_SANDSTONE_WALL));
        public static final BlockClusterFeatureConfig GILIA_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(States.GILIA), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(64).func_227322_d_();
        public static final BlockClusterFeatureConfig BARREL_CACTUS_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(States.BARREL_CACTUS), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(64).func_227322_d_();
        public static final BlockClusterFeatureConfig ALOE_VERA_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(States.ALOE_VERA), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(64).func_227322_d_();
        public static final BlockClusterFeatureConfig YUCCA_FLOWER_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(States.YUCCA_FLOWER), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(64).func_227322_d_();
        public static final BlockClusterFeatureConfig ARID_SPROUTS_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(((Block)AtmosphericBlocks.ARID_SPROUTS.get()).func_176223_P()), (BlockPlacer)SimpleBlockPlacer.field_236447_c_).func_227315_a_(32).func_227322_d_();
        public static final BaseTreeFeatureConfig OAK_GROUND_BUSH_CONFIG = new BaseTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(Blocks.field_196617_K.func_176223_P()), (BlockStateProvider)new SimpleBlockStateProvider(Blocks.field_196642_W.func_176223_P()), (FoliagePlacer)new BushFoliagePlacer(FeatureSpread.func_242252_a((int)2), FeatureSpread.func_242252_a((int)1), 2), (AbstractTrunkPlacer)new StraightTrunkPlacer(1, 0, 0), (AbstractFeatureSizeType)new TwoLayerFeature(0, 0, 0)).func_236702_a_(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES).func_225568_b_();
        public static final YuccaTreeFeatureConfig YUCCA_TREE_CONFIG = YUCCA_TREE_BUILDER.setHeightmap(Heightmap.Type.MOTION_BLOCKING).build();
        public static final YuccaTreeFeatureConfig YUCCA_TREE_WITH_PATCH_CONFIG = YUCCA_TREE_CONFIG.setPatch();
        public static final YuccaTreeFeatureConfig YUCCA_TREE_WITH_MORE_BEEHIVES_CONFIG = YUCCA_TREE_CONFIG.withDecorators((List<TreeDecorator>)ImmutableList.of((Object)Features.Placements.field_243992_c));
        public static final YuccaTreeFeatureConfig YUCCA_TREE_WITH_MORE_BEEHIVES_AND_PATCH_CONFIG = YUCCA_TREE_WITH_MORE_BEEHIVES_CONFIG.setPatch();
        public static final YuccaTreeFeatureConfig BABY_YUCCA_TREE_CONFIG = YUCCA_TREE_CONFIG.setBaby();
        public static final YuccaTreeFeatureConfig BABY_YUCCA_TREE_WITH_PATCH_CONFIG = BABY_YUCCA_TREE_CONFIG.setPatch();
        public static final YuccaTreeFeatureConfig ARID_YUCCA_TREE_CONFIG = ARID_YUCCA_TREE_BUILDER.isPetrified().setHeightmap(Heightmap.Type.MOTION_BLOCKING).build();
        public static final YuccaTreeFeatureConfig RED_ARID_YUCCA_TREE_CONFIG = RED_ARID_YUCCA_TREE_BUILDER.isPetrified().setHeightmap(Heightmap.Type.MOTION_BLOCKING).build();
        public static final BaseTreeFeatureConfig ROSEWOOD_TREE_CONFIG = new BaseTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(States.ROSEWOOD_LOG), (BlockStateProvider)new SimpleBlockStateProvider(States.ROSEWOOD_LEAVES), (FoliagePlacer)new BlobFoliagePlacer(FeatureSpread.func_242252_a((int)0), FeatureSpread.func_242252_a((int)0), 0), (AbstractTrunkPlacer)new StraightTrunkPlacer(0, 0, 0), (AbstractFeatureSizeType)new TwoLayerFeature(0, 0, 0)).func_236700_a_().func_236702_a_(Heightmap.Type.MOTION_BLOCKING).func_225568_b_();
        public static final BaseTreeFeatureConfig ROSEWOOD_TREE_WITH_FEW_BEEHIVES_CONFIG = ROSEWOOD_TREE_CONFIG.func_236685_a_((List)ImmutableList.of((Object)Features.Placements.field_243990_a));
        public static final BaseTreeFeatureConfig ROSEWOOD_TREE_WITH_MORE_BEEHIVES_CONFIG = ROSEWOOD_TREE_CONFIG.func_236685_a_((List)ImmutableList.of((Object)Features.Placements.field_243992_c));
        public static final BaseTreeFeatureConfig MORADO_TREE_CONFIG = new BaseTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(States.MORADO_LOG), (BlockStateProvider)new WeightedBlockStateProvider().func_227407_a_(States.MORADO_LEAVES, 2).func_227407_a_(States.FLOWERING_MORADO_LEAVES, 6), (FoliagePlacer)new BlobFoliagePlacer(FeatureSpread.func_242252_a((int)0), FeatureSpread.func_242252_a((int)0), 0), (AbstractTrunkPlacer)new StraightTrunkPlacer(0, 0, 0), (AbstractFeatureSizeType)new TwoLayerFeature(0, 0, 0)).func_236700_a_().func_236702_a_(Heightmap.Type.MOTION_BLOCKING).func_225568_b_();
        public static final BaseTreeFeatureConfig MORADO_TREE_WITH_FEW_BEEHIVES_CONFIG = MORADO_TREE_CONFIG.func_236685_a_((List)ImmutableList.of((Object)Features.Placements.field_243990_a));
        public static final BaseTreeFeatureConfig MORADO_TREE_WITH_MORE_BEEHIVES_CONFIG = MORADO_TREE_CONFIG.func_236685_a_((List)ImmutableList.of((Object)Features.Placements.field_243992_c));
        public static final BaseTreeFeatureConfig KOUSA_TREE_CONFIG = new BaseTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(States.KOUSA_LOG), (BlockStateProvider)new SimpleBlockStateProvider(States.KOUSA_LEAVES), (FoliagePlacer)new FancyFoliagePlacer(FeatureSpread.func_242252_a((int)2), FeatureSpread.func_242252_a((int)4), 4), (AbstractTrunkPlacer)new FancyTrunkPlacer(3, 11, 0), (AbstractFeatureSizeType)new TwoLayerFeature(0, 0, 0, OptionalInt.of(4))).func_236700_a_().func_236702_a_(Heightmap.Type.MOTION_BLOCKING).func_225568_b_();
        public static final BaseTreeFeatureConfig ASPEN_TREE_CONFIG = new BaseTreeFeatureConfig.Builder((BlockStateProvider)new WeightedBlockStateProvider().func_227407_a_(States.ASPEN_LOG, 3).func_227407_a_(States.WATCHFUL_ASPEN_LOG, 2), (BlockStateProvider)new SimpleBlockStateProvider(States.ASPEN_LEAVES), (FoliagePlacer)new SpruceFoliagePlacer(FeatureSpread.func_242253_a((int)0, (int)0), FeatureSpread.func_242253_a((int)0, (int)0), FeatureSpread.func_242253_a((int)0, (int)0)), (AbstractTrunkPlacer)new StraightTrunkPlacer(0, 0, 0), (AbstractFeatureSizeType)new TwoLayerFeature(0, 0, 0)).func_236700_a_().func_236702_a_(Heightmap.Type.MOTION_BLOCKING).func_225568_b_();
        public static final BaseTreeFeatureConfig GRIMWOOD_TREE_CONFIG = new BaseTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(States.GRIMWOOD_LOG), (BlockStateProvider)new SimpleBlockStateProvider(States.GRIMWOOD_LEAVES), (FoliagePlacer)new SpruceFoliagePlacer(FeatureSpread.func_242253_a((int)2, (int)1), FeatureSpread.func_242253_a((int)0, (int)2), FeatureSpread.func_242253_a((int)1, (int)1)), (AbstractTrunkPlacer)new StraightTrunkPlacer(5, 2, 1), (AbstractFeatureSizeType)new TwoLayerFeature(2, 0, 2)).func_236700_a_().func_225568_b_();
    }

    public static final class States {
        public static final BlockState ROSEWOOD_LOG = ((Block)AtmosphericBlocks.ROSEWOOD_LOG.get()).func_176223_P();
        public static final BlockState ROSEWOOD_LEAVES = ((Block)AtmosphericBlocks.ROSEWOOD_LEAVES.get()).func_176223_P();
        public static final BlockState MORADO_LOG = ((Block)AtmosphericBlocks.MORADO_LOG.get()).func_176223_P();
        public static final BlockState MORADO_LEAVES = ((Block)AtmosphericBlocks.MORADO_LEAVES.get()).func_176223_P();
        public static final BlockState FLOWERING_MORADO_LEAVES = ((Block)AtmosphericBlocks.FLOWERING_MORADO_LEAVES.get()).func_176223_P();
        public static final BlockState YUCCA_LOG = ((Block)AtmosphericBlocks.YUCCA_LOG.get()).func_176223_P();
        public static final BlockState YUCCA_LEAVES = ((Block)AtmosphericBlocks.YUCCA_LEAVES.get()).func_176223_P();
        public static final BlockState YUCCA_BRANCH = ((Block)AtmosphericBlocks.YUCCA_BRANCH.get()).func_176223_P();
        public static final BlockState YUCCA_BUNDLE = ((Block)AtmosphericBlocks.YUCCA_BUNDLE.get()).func_176223_P();
        public static final BlockState ROASTED_YUCCA_BUNDLE = ((Block)AtmosphericBlocks.ROASTED_YUCCA_BUNDLE.get()).func_176223_P();
        public static final BlockState ARID_SANDSTONE = ((Block)AtmosphericBlocks.ARID_SANDSTONE.get()).func_176223_P();
        public static final BlockState ARID_SANDSTONE_WALL = ((Block)AtmosphericBlocks.ARID_SANDSTONE_WALL.get()).func_176223_P();
        public static final BlockState RED_ARID_SANDSTONE = ((Block)AtmosphericBlocks.RED_ARID_SANDSTONE.get()).func_176223_P();
        public static final BlockState RED_ARID_SANDSTONE_WALL = ((Block)AtmosphericBlocks.RED_ARID_SANDSTONE_WALL.get()).func_176223_P();
        public static final BlockState ASPEN_LOG = ((Block)AtmosphericBlocks.ASPEN_LOG.get()).func_176223_P();
        public static final BlockState WATCHFUL_ASPEN_LOG = ((Block)AtmosphericBlocks.WATCHFUL_ASPEN_LOG.get()).func_176223_P();
        public static final BlockState ASPEN_LEAVES = ((Block)AtmosphericBlocks.ASPEN_LEAVES.get()).func_176223_P();
        public static final BlockState KOUSA_LOG = ((Block)AtmosphericBlocks.KOUSA_LOG.get()).func_176223_P();
        public static final BlockState KOUSA_LEAVES = ((Block)AtmosphericBlocks.KOUSA_LEAVES.get()).func_176223_P();
        public static final BlockState GRIMWOOD_LOG = ((Block)AtmosphericBlocks.GRIMWOOD_LOG.get()).func_176223_P();
        public static final BlockState GRIMWOOD_LEAVES = ((Block)AtmosphericBlocks.GRIMWOOD_LEAVES.get()).func_176223_P();
        public static final BlockState GILIA = ((Block)AtmosphericBlocks.GILIA.get()).func_176223_P();
        public static final BlockState BARREL_CACTUS = ((Block)AtmosphericBlocks.BARREL_CACTUS.get()).func_176223_P();
        public static final BlockState CRUSTOSE = ((Block)AtmosphericBlocks.CRUSTOSE.get()).func_176223_P();
        public static final BlockState ALOE_VERA = ((Block)AtmosphericBlocks.ALOE_VERA.get()).func_176223_P();
        public static final BlockState YUCCA_FLOWER = ((Block)AtmosphericBlocks.YUCCA_FLOWER.get()).func_176223_P();
        public static final BlockState TALL_YUCCA_FLOWER_TOP = (BlockState)((Block)AtmosphericBlocks.TALL_YUCCA_FLOWER.get()).func_176223_P().func_206870_a((Property)YuccaFlowerDoubleBlock.field_176492_b, (Comparable)DoubleBlockHalf.UPPER);
        public static final BlockState TALL_YUCCA_FLOWER_BOTTOM = (BlockState)((Block)AtmosphericBlocks.TALL_YUCCA_FLOWER.get()).func_176223_P().func_206870_a((Property)YuccaFlowerDoubleBlock.field_176492_b, (Comparable)DoubleBlockHalf.LOWER);
    }
}

