/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity;

import com.github.alexthe666.alexsmobs.block.AMBlockRegistry;
import com.github.alexthe666.alexsmobs.config.AMConfig;
import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.entity.EntityAlligatorSnappingTurtle;
import com.github.alexthe666.alexsmobs.entity.EntityCrocodile;
import com.github.alexthe666.alexsmobs.entity.ITargetsDroppedItems;
import com.github.alexthe666.alexsmobs.entity.ai.AnimalAIWadeSwimming;
import com.github.alexthe666.alexsmobs.entity.ai.CreatureAITargetItems;
import com.github.alexthe666.alexsmobs.entity.ai.DirectPathNavigator;
import com.github.alexthe666.alexsmobs.entity.ai.EntityAINearestTarget3D;
import com.github.alexthe666.alexsmobs.entity.ai.FlightMoveController;
import com.github.alexthe666.alexsmobs.entity.ai.GroundPathNavigatorWide;
import com.github.alexthe666.alexsmobs.entity.ai.ShoebillAIFish;
import com.github.alexthe666.alexsmobs.entity.ai.ShoebillAIFlightFlee;
import com.github.alexthe666.alexsmobs.item.AMItemRegistry;
import com.github.alexthe666.alexsmobs.misc.AMSoundRegistry;
import com.github.alexthe666.alexsmobs.misc.AMTagRegistry;
import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.AnimationHandler;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.TurtleEntity;
import net.minecraft.entity.passive.fish.AbstractFishEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ItemParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class EntityShoebill
extends AnimalEntity
implements IAnimatedEntity,
ITargetsDroppedItems {
    public static final Animation ANIMATION_FISH = Animation.create((int)40);
    public static final Animation ANIMATION_BEAKSHAKE = Animation.create((int)20);
    public static final Animation ANIMATION_ATTACK = Animation.create((int)20);
    private static final DataParameter<Boolean> FLYING = EntityDataManager.func_187226_a(EntityShoebill.class, (IDataSerializer)DataSerializers.field_187198_h);
    public float prevFlyProgress;
    public float flyProgress;
    public int revengeCooldown = 0;
    private int animationTick;
    private Animation currentAnimation;
    private boolean isLandNavigator;
    public int fishingCooldown = 1200 + this.field_70146_Z.nextInt(1200);
    public int lureLevel = 0;
    public int luckLevel = 0;
    public static final Predicate<LivingEntity> TARGET_BABY = animal -> animal.func_70631_g_();

    protected EntityShoebill(EntityType type, World world) {
        super(type, world);
        this.func_184644_a(PathNodeType.WATER, 0.0f);
        this.func_184644_a(PathNodeType.WATER_BORDER, 0.0f);
        this.switchNavigator(false);
    }

    public boolean func_213380_a(IWorld worldIn, SpawnReason spawnReasonIn) {
        return AMEntityRegistry.rollSpawn(AMConfig.shoebillSpawnRolls, this.func_70681_au(), spawnReasonIn);
    }

    public static AttributeModifierMap.MutableAttribute bakeAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, 10.0).func_233815_a_(Attributes.field_233823_f_, 4.0).func_233815_a_(Attributes.field_233821_d_, (double)0.2f);
    }

    protected SoundEvent func_184639_G() {
        return AMSoundRegistry.SHOEBILL_HURT;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return AMSoundRegistry.SHOEBILL_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return AMSoundRegistry.SHOEBILL_HURT;
    }

    public boolean func_70877_b(ItemStack stack) {
        return false;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        boolean prev = super.func_70097_a(source, amount);
        if (prev && source.func_76346_g() != null && !(source.func_76346_g() instanceof AbstractFishEntity)) {
            int fleeTime;
            double range = 15.0;
            this.revengeCooldown = fleeTime = 100 + this.func_70681_au().nextInt(150);
            List list = this.field_70170_p.func_217357_a(this.getClass(), this.func_174813_aQ().func_72314_b(range, range / 2.0, range));
            for (EntityShoebill gaz : list) {
                gaz.revengeCooldown = fleeTime;
            }
        }
        return prev;
    }

    private void switchNavigator(boolean onLand) {
        if (onLand) {
            this.field_70765_h = new MovementController((MobEntity)this);
            this.field_70699_by = new GroundPathNavigatorWide((MobEntity)this, this.field_70170_p);
            this.isLandNavigator = true;
        } else {
            this.field_70765_h = new FlightMoveController((MobEntity)this, 0.7f);
            this.field_70699_by = new DirectPathNavigator((MobEntity)this, this.field_70170_p);
            this.isLandNavigator = false;
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(FLYING, (Object)false);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new AnimalAIWadeSwimming((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new ShoebillAIFish(this));
        this.field_70714_bg.func_75776_a(3, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.2, true));
        this.field_70714_bg.func_75776_a(4, (Goal)new ShoebillAIFlightFlee(this));
        this.field_70714_bg.func_75776_a(5, (Goal)new TemptGoal((CreatureEntity)this, 1.1, Ingredient.func_199805_a((ITag)ItemTags.func_199903_a().func_199910_a(AMTagRegistry.SHOEBILL_FOODSTUFFS)), false));
        this.field_70714_bg.func_75776_a(6, (Goal)new RandomWalkingGoal((CreatureEntity)this, 1.0, 1400));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70715_bh.func_75776_a(1, new EntityAINearestTarget3D<AbstractFishEntity>((MobEntity)this, AbstractFishEntity.class, 30, false, true, null));
        this.field_70715_bh.func_75776_a(2, new CreatureAITargetItems((CreatureEntity)this, false, 10));
        this.field_70715_bh.func_75776_a(3, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[]{PlayerEntity.class}).func_220794_a(new Class[0]));
        this.field_70715_bh.func_75776_a(4, (Goal)new NearestAttackableTargetGoal((MobEntity)this, EntityAlligatorSnappingTurtle.class, 40, false, false, TARGET_BABY));
        this.field_70715_bh.func_75776_a(5, (Goal)new NearestAttackableTargetGoal((MobEntity)this, TurtleEntity.class, 40, false, false, TARGET_BABY));
        this.field_70715_bh.func_75776_a(6, (Goal)new NearestAttackableTargetGoal((MobEntity)this, EntityCrocodile.class, 40, false, false, TARGET_BABY));
    }

    public boolean isTargetBlocked(Vector3d target) {
        Vector3d Vector3d2 = new Vector3d(this.func_226277_ct_(), this.func_226280_cw_(), this.func_226281_cx_());
        return this.field_70170_p.func_217299_a(new RayTraceContext(Vector3d2, target, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)this)).func_216346_c() != RayTraceResult.Type.MISS;
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        return false;
    }

    protected void func_184231_a(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.field_70138_W = this.func_70090_H() ? 1.2f : 0.6f;
        this.prevFlyProgress = this.flyProgress;
        if (this.isFlying() && this.flyProgress < 5.0f) {
            this.flyProgress += 1.0f;
        }
        if (!this.isFlying() && this.flyProgress > 0.0f) {
            this.flyProgress -= 1.0f;
        }
        if (this.revengeCooldown > 0) {
            --this.revengeCooldown;
        }
        if (this.revengeCooldown == 0 && this.func_70643_av() != null) {
            this.func_70604_c(null);
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.fishingCooldown > 0) {
                --this.fishingCooldown;
            }
            if (this.getAnimation() == NO_ANIMATION && this.func_70681_au().nextInt(700) == 0) {
                this.setAnimation(ANIMATION_BEAKSHAKE);
            }
            if (this.isFlying() && this.isLandNavigator) {
                this.switchNavigator(false);
            }
            if (!this.isFlying() && !this.isLandNavigator) {
                this.switchNavigator(true);
            }
            if (this.revengeCooldown > 0 && !this.isFlying() && (this.field_70122_E || this.func_70090_H())) {
                this.setFlying(false);
            }
            if (this.isFlying()) {
                this.func_189654_d(true);
            } else {
                this.func_189654_d(false);
            }
        }
        if (!this.field_70170_p.field_72995_K && this.func_70638_az() != null && this.func_70685_l((Entity)this.func_70638_az()) && this.getAnimation() == ANIMATION_ATTACK && this.getAnimationTick() == 9) {
            float f1 = this.field_70177_z * ((float)Math.PI / 180);
            this.func_70638_az().func_233627_a_(0.3f, this.func_70638_az().func_226277_ct_() - this.func_226277_ct_(), this.func_70638_az().func_226281_cx_() - this.func_226281_cx_());
            this.func_70638_az().func_70097_a(DamageSource.func_76358_a((LivingEntity)this), (float)this.func_110148_a(Attributes.field_233823_f_).func_111125_b());
        }
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("Flying", this.isFlying());
        compound.func_74768_a("FishingTimer", this.fishingCooldown);
        compound.func_74768_a("FishingLuck", this.luckLevel);
        compound.func_74768_a("FishingLure", this.lureLevel);
        compound.func_74768_a("RevengeCooldownTimer", this.revengeCooldown);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setFlying(compound.func_74767_n("Flying"));
        this.fishingCooldown = compound.func_74762_e("FishingTimer");
        this.luckLevel = compound.func_74762_e("FishingLuck");
        this.lureLevel = compound.func_74762_e("FishingLure");
        this.revengeCooldown = compound.func_74762_e("RevengeCooldownTimer");
    }

    protected float func_189749_co() {
        return 0.98f;
    }

    public boolean func_70652_k(Entity entityIn) {
        if (this.getAnimation() == NO_ANIMATION) {
            this.setAnimation(ANIMATION_ATTACK);
        }
        return true;
    }

    public boolean isFlying() {
        return (Boolean)this.field_70180_af.func_187225_a(FLYING);
    }

    public void setFlying(boolean flying) {
        this.field_70180_af.func_187227_b(FLYING, (Object)flying);
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int i) {
        this.animationTick = i;
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
    }

    public Animation[] getAnimations() {
        return new Animation[]{ANIMATION_FISH, ANIMATION_BEAKSHAKE, ANIMATION_ATTACK};
    }

    public ActionResultType func_230254_b_(PlayerEntity p_230254_1_, Hand p_230254_2_) {
        ItemStack lvt_3_1_ = p_230254_1_.func_184586_b(p_230254_2_);
        if (lvt_3_1_.func_77973_b() == AMItemRegistry.BLOBFISH && this.func_70089_S()) {
            if (this.luckLevel < 10) {
                this.luckLevel = MathHelper.func_76125_a((int)(this.luckLevel + 1), (int)0, (int)10);
                for (int i = 0; i < 6 + this.field_70146_Z.nextInt(3); ++i) {
                    double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                    double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                    double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                    this.field_70170_p.func_195594_a((IParticleData)new ItemParticleData(ParticleTypes.field_197591_B, lvt_3_1_), this.func_226277_ct_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf()) - (double)this.func_213311_cf() * 0.5, this.func_226278_cu_() + (double)(this.func_213302_cg() * 0.5f) + (double)(this.field_70146_Z.nextFloat() * this.func_213302_cg() * 0.5f), this.func_226281_cx_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf()) - (double)this.func_213311_cf() * 0.5, d0, d1, d2);
                }
                this.func_184185_a(SoundEvents.field_219607_aG, this.func_70599_aP(), this.func_70647_i());
                lvt_3_1_.func_190918_g(1);
                return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
            }
            if (this.getAnimation() == NO_ANIMATION) {
                this.setAnimation(ANIMATION_BEAKSHAKE);
            }
            return ActionResultType.SUCCESS;
        }
        if (lvt_3_1_.func_77973_b() == AMBlockRegistry.CROCODILE_EGG.func_199767_j() && this.func_70089_S()) {
            if (this.lureLevel < 10) {
                this.lureLevel = MathHelper.func_76125_a((int)(this.lureLevel + 1), (int)0, (int)10);
                this.fishingCooldown = MathHelper.func_76125_a((int)(this.fishingCooldown - 200), (int)200, (int)2400);
                for (int i = 0; i < 6 + this.field_70146_Z.nextInt(3); ++i) {
                    double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                    double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                    double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                    this.field_70170_p.func_195594_a((IParticleData)new ItemParticleData(ParticleTypes.field_197591_B, lvt_3_1_), this.func_226277_ct_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf()) - (double)this.func_213311_cf() * 0.5, this.func_226278_cu_() + (double)(this.func_213302_cg() * 0.5f) + (double)(this.field_70146_Z.nextFloat() * this.func_213302_cg() * 0.5f), this.func_226281_cx_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf()) - (double)this.func_213311_cf() * 0.5, d0, d1, d2);
                }
                lvt_3_1_.func_190918_g(1);
                this.func_184185_a(SoundEvents.field_219607_aG, this.func_70599_aP(), this.func_70647_i());
                return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
            }
            if (this.getAnimation() == NO_ANIMATION) {
                this.setAnimation(ANIMATION_BEAKSHAKE);
            }
            return ActionResultType.SUCCESS;
        }
        return super.func_230254_b_(p_230254_1_, p_230254_2_);
    }

    @Nullable
    public AgeableEntity func_241840_a(ServerWorld serverWorld, AgeableEntity ageableEntity) {
        return (AgeableEntity)AMEntityRegistry.SHOEBILL.func_200721_a((World)serverWorld);
    }

    @Override
    public boolean canTargetItem(ItemStack stack) {
        return ItemTags.func_199903_a().func_199910_a(AMTagRegistry.SHOEBILL_FOODSTUFFS).func_230235_a_((Object)stack.func_77973_b()) || stack.func_77973_b() == AMItemRegistry.BLOBFISH && this.luckLevel < 10 || stack.func_77973_b() == AMBlockRegistry.CROCODILE_EGG.func_199767_j() && this.lureLevel < 10;
    }

    public void resetFishingCooldown() {
        this.fishingCooldown = Math.max(1200 + this.field_70146_Z.nextInt(1200) - this.lureLevel * 120, 200);
    }

    @Override
    public void onGetItem(ItemEntity e) {
        this.func_184185_a(SoundEvents.field_219607_aG, this.func_70599_aP(), this.func_70647_i());
        if (e.func_92059_d().func_77973_b() == AMItemRegistry.BLOBFISH) {
            this.luckLevel = MathHelper.func_76125_a((int)(this.luckLevel + 1), (int)0, (int)10);
        }
        if (e.func_92059_d().func_77973_b() == AMBlockRegistry.CROCODILE_EGG.func_199767_j()) {
            this.lureLevel = MathHelper.func_76125_a((int)(this.lureLevel + 1), (int)0, (int)10);
        }
        this.func_70691_i(5.0f);
    }
}

