/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity;

import com.github.alexthe666.alexsmobs.client.particle.AMParticleRegistry;
import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;

public class EntityGust
extends Entity {
    protected static final DataParameter<Boolean> VERTICAL = EntityDataManager.func_187226_a(EntityGust.class, (IDataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Float> X_DIR = EntityDataManager.func_187226_a(EntityGust.class, (IDataSerializer)DataSerializers.field_187193_c);
    protected static final DataParameter<Float> Y_DIR = EntityDataManager.func_187226_a(EntityGust.class, (IDataSerializer)DataSerializers.field_187193_c);
    protected static final DataParameter<Float> Z_DIR = EntityDataManager.func_187226_a(EntityGust.class, (IDataSerializer)DataSerializers.field_187193_c);
    private Entity pushedEntity = null;

    public EntityGust(EntityType p_i50162_1_, World p_i50162_2_) {
        super(p_i50162_1_, p_i50162_2_);
    }

    public EntityGust(World worldIn) {
        this(AMEntityRegistry.GUST, worldIn);
    }

    public EntityGust(FMLPlayMessages.SpawnEntity spawnEntity, World world) {
        this(AMEntityRegistry.GUST, world);
    }

    public void func_70108_f(Entity entityIn) {
    }

    protected static float func_234614_e_(float p_234614_0_, float p_234614_1_) {
        while (p_234614_1_ - p_234614_0_ < -180.0f) {
            p_234614_0_ -= 360.0f;
        }
        while (p_234614_1_ - p_234614_0_ >= 180.0f) {
            p_234614_0_ += 360.0f;
        }
        return MathHelper.func_219799_g((float)0.2f, (float)p_234614_0_, (float)p_234614_1_);
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70173_aa > 300) {
            this.func_70106_y();
        }
        for (int i = 0; i < 1 + this.field_70146_Z.nextInt(1); ++i) {
            this.field_70170_p.func_195594_a((IParticleData)AMParticleRegistry.GUSTER_SAND_SPIN, this.func_226277_ct_() + (double)(0.5f * (this.field_70146_Z.nextFloat() - 0.5f)), this.func_226278_cu_() + (double)(0.5f * (this.field_70146_Z.nextFloat() - 0.5f)), this.func_226281_cx_() + (double)(0.5f * (this.field_70146_Z.nextFloat() - 0.5f)), this.func_226277_ct_(), this.func_226278_cu_() + 0.5, this.func_226281_cx_());
        }
        Vector3d vector3d = new Vector3d((double)((Float)this.field_70180_af.func_187225_a(X_DIR)).floatValue(), (double)((Float)this.field_70180_af.func_187225_a(Y_DIR)).floatValue(), (double)((Float)this.field_70180_af.func_187225_a(Z_DIR)).floatValue());
        RayTraceResult raytraceresult = ProjectileHelper.func_234618_a_((Entity)this, this::func_230298_a_);
        if (raytraceresult != null && raytraceresult.func_216346_c() != RayTraceResult.Type.MISS && this.field_70173_aa > 4) {
            this.onImpact(raytraceresult);
        }
        List list = this.field_70170_p.func_217357_a(Entity.class, this.func_174813_aQ().func_186662_g(0.1));
        if (this.pushedEntity != null && this.func_70032_d(this.pushedEntity) > 2.0f) {
            this.pushedEntity = null;
        }
        double d0 = this.func_226277_ct_() + vector3d.field_72450_a;
        double d1 = this.func_226278_cu_() + vector3d.field_72448_b;
        double d2 = this.func_226281_cx_() + vector3d.field_72449_c;
        if (this.func_226278_cu_() > (double)this.field_70170_p.func_217301_I()) {
            this.func_70106_y();
        }
        this.func_234617_x_();
        float f = 0.99f;
        float f1 = 0.06f;
        if (this.func_203005_aq()) {
            this.func_70106_y();
        } else {
            this.func_213317_d(vector3d);
            this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, (double)-0.06f, 0.0));
            this.func_70107_b(d0, d1, d2);
            if (this.pushedEntity != null) {
                this.pushedEntity.func_213317_d(this.func_213322_ci().func_72441_c(0.0, 0.063, 0.0));
            }
            for (Entity e : list) {
                e.func_213317_d(this.func_213322_ci().func_72441_c(0.0, 0.068, 0.0));
                if (e.func_213322_ci().field_72448_b < 0.0) {
                    e.func_213317_d(e.func_213322_ci().func_216372_d(1.0, 0.0, 1.0));
                }
                e.field_70143_R = 0.0f;
            }
        }
    }

    public void setGustDir(float x, float y, float z) {
        this.field_70180_af.func_187227_b(X_DIR, (Object)Float.valueOf(x));
        this.field_70180_af.func_187227_b(Y_DIR, (Object)Float.valueOf(y));
        this.field_70180_af.func_187227_b(Z_DIR, (Object)Float.valueOf(z));
    }

    public float getGustDir(int xyz) {
        return ((Float)this.field_70180_af.func_187225_a(xyz == 2 ? Z_DIR : (xyz == 1 ? Y_DIR : X_DIR))).floatValue();
    }

    protected void onEntityHit(EntityRayTraceResult result) {
        Entity entity = result.func_216348_a();
        if (entity instanceof EntityGust) {
            EntityGust other = (EntityGust)entity;
            double avgX = (other.func_226277_ct_() + this.func_226277_ct_()) / 2.0;
            double avgY = (other.func_226278_cu_() + this.func_226278_cu_()) / 2.0;
            double avgZ = (other.func_226281_cx_() + this.func_226281_cx_()) / 2.0;
            other.func_70107_b(avgX, avgY, avgZ);
            other.setGustDir(other.getGustDir(0) + this.getGustDir(0), other.getGustDir(1) + this.getGustDir(1), other.getGustDir(2) + this.getGustDir(2));
            if (this.func_70089_S() && other.func_70089_S()) {
                this.func_70106_y();
            }
        } else if (entity != null) {
            this.pushedEntity = entity;
        }
    }

    protected boolean func_230298_a_(Entity p_230298_1_) {
        return !p_230298_1_.func_175149_v();
    }

    protected void func_230299_a_(BlockRayTraceResult p_230299_1_) {
        BlockPos pos;
        if (p_230299_1_.func_216350_a() != null && this.field_70170_p.func_180495_p(pos = p_230299_1_.func_216350_a()).func_185904_a().func_76220_a() && !this.field_70170_p.field_72995_K) {
            this.func_70106_y();
        }
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(VERTICAL, (Object)false);
        this.field_70180_af.func_187214_a(X_DIR, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(Y_DIR, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(Z_DIR, (Object)Float.valueOf(0.0f));
    }

    protected void func_213281_b(CompoundNBT compound) {
        compound.func_74757_a("VerticalTornado", this.getVertical());
        compound.func_74776_a("GustDirX", ((Float)this.field_70180_af.func_187225_a(X_DIR)).floatValue());
        compound.func_74776_a("GustDirY", ((Float)this.field_70180_af.func_187225_a(Y_DIR)).floatValue());
        compound.func_74776_a("GustDirZ", ((Float)this.field_70180_af.func_187225_a(Z_DIR)).floatValue());
    }

    protected void func_70037_a(CompoundNBT compound) {
        this.field_70180_af.func_187227_b(X_DIR, (Object)Float.valueOf(compound.func_74760_g("GustDirX")));
        this.field_70180_af.func_187227_b(Y_DIR, (Object)Float.valueOf(compound.func_74760_g("GustDirX")));
        this.field_70180_af.func_187227_b(Z_DIR, (Object)Float.valueOf(compound.func_74760_g("GustDirX")));
        this.setVertical(compound.func_74767_n("VerticalTornado"));
    }

    public void setVertical(boolean vertical) {
        this.field_70180_af.func_187227_b(VERTICAL, (Object)vertical);
    }

    public boolean getVertical() {
        return (Boolean)this.field_70180_af.func_187225_a(VERTICAL);
    }

    protected void onImpact(RayTraceResult result) {
        RayTraceResult.Type raytraceresult$type = result.func_216346_c();
        if (raytraceresult$type == RayTraceResult.Type.ENTITY) {
            this.onEntityHit((EntityRayTraceResult)result);
        } else if (raytraceresult$type == RayTraceResult.Type.BLOCK) {
            this.func_230299_a_((BlockRayTraceResult)result);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70016_h(double x, double y, double z) {
        this.func_213293_j(x, y, z);
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float f = MathHelper.func_76133_a((double)(x * x + z * z));
            this.field_70125_A = (float)(MathHelper.func_181159_b((double)y, (double)f) * 57.2957763671875);
            this.field_70177_z = (float)(MathHelper.func_181159_b((double)x, (double)z) * 57.2957763671875);
            this.field_70127_C = this.field_70125_A;
            this.field_70126_B = this.field_70177_z;
            this.func_70012_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.field_70177_z, this.field_70125_A);
        }
    }

    protected void func_234617_x_() {
        Vector3d vector3d = this.func_213322_ci();
        float f = MathHelper.func_76133_a((double)EntityGust.func_213296_b((Vector3d)vector3d));
        this.field_70125_A = EntityGust.func_234614_e_(this.field_70127_C, (float)(MathHelper.func_181159_b((double)vector3d.field_72448_b, (double)f) * 57.2957763671875));
        this.field_70177_z = EntityGust.func_234614_e_(this.field_70126_B, (float)(MathHelper.func_181159_b((double)vector3d.field_72450_a, (double)vector3d.field_72449_c) * 57.2957763671875));
    }
}

