/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity;

import com.github.alexthe666.alexsmobs.config.AMConfig;
import com.github.alexthe666.alexsmobs.effect.AMEffectRegistry;
import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.entity.ai.DirectPathNavigator;
import com.github.alexthe666.alexsmobs.entity.ai.EndergradeAIBreakFlowers;
import com.github.alexthe666.alexsmobs.entity.ai.EndergradeAITargetItems;
import com.github.alexthe666.alexsmobs.entity.ai.TameableAIRide;
import com.github.alexthe666.alexsmobs.item.AMItemRegistry;
import com.github.alexthe666.alexsmobs.misc.AMSoundRegistry;
import java.util.EnumSet;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.IFlyingAnimal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class EntityEndergrade
extends AnimalEntity
implements IFlyingAnimal {
    private static final DataParameter<Integer> BITE_TICK = EntityDataManager.func_187226_a(EntityEndergrade.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> SADDLED = EntityDataManager.func_187226_a(EntityEndergrade.class, (IDataSerializer)DataSerializers.field_187198_h);
    public float tartigradePitch = 0.0f;
    public float prevTartigradePitch = 0.0f;
    public float biteProgress = 0.0f;
    public float prevBiteProgress = 0.0f;
    public boolean stopWandering = false;
    public boolean hasItemTarget = false;

    protected EntityEndergrade(EntityType type, World worldIn) {
        super(type, worldIn);
        this.field_70765_h = new MoveHelperController(this);
    }

    protected PathNavigator func_175447_b(World worldIn) {
        return new DirectPathNavigator((MobEntity)this, worldIn);
    }

    public static AttributeModifierMap.MutableAttribute bakeAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, 20.0).func_233815_a_(Attributes.field_233826_i_, 0.0).func_233815_a_(Attributes.field_233823_f_, 2.0).func_233815_a_(Attributes.field_233821_d_, (double)0.15f);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("Saddled", this.isSaddled());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setSaddled(compound.func_74767_n("Saddled"));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(BITE_TICK, (Object)0);
        this.field_70180_af.func_187214_a(SADDLED, (Object)false);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new TameableAIRide((CreatureEntity)this, 1.2));
        this.field_70714_bg.func_75776_a(1, (Goal)new EndergradeAIBreakFlowers(this));
        this.field_70714_bg.func_75776_a(2, (Goal)new BreedGoal(this, 1.2){

            public void func_75249_e() {
                super.func_75249_e();
                EntityEndergrade.this.stopWandering = true;
            }

            public void func_75251_c() {
                super.func_75251_c();
                EntityEndergrade.this.stopWandering = false;
            }
        });
        this.field_70714_bg.func_75776_a(3, (Goal)new TemptGoal((CreatureEntity)this, 1.1, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_185161_cS}), false){

            public void func_75249_e() {
                super.func_75249_e();
                EntityEndergrade.this.stopWandering = true;
            }

            public void func_75251_c() {
                super.func_75251_c();
                EntityEndergrade.this.stopWandering = false;
            }
        });
        this.field_70714_bg.func_75776_a(4, (Goal)new RandomFlyGoal(this));
        this.field_70714_bg.func_75776_a(5, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 10.0f));
        this.field_70714_bg.func_75776_a(5, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, new EndergradeAITargetItems(this, true));
    }

    @Nullable
    public Entity func_184179_bs() {
        for (Entity passenger : this.func_184188_bt()) {
            PlayerEntity player;
            if (!(passenger instanceof PlayerEntity) || (player = (PlayerEntity)passenger).func_184614_ca().func_77973_b() != AMItemRegistry.CHORUS_ON_A_STICK && player.func_184592_cb().func_77973_b() != AMItemRegistry.CHORUS_ON_A_STICK) continue;
            return player;
        }
        return null;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return AMSoundRegistry.ENDERGRADE_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return AMSoundRegistry.ENDERGRADE_HURT;
    }

    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        Item item = itemstack.func_77973_b();
        if (item == Items.field_151141_av && !this.isSaddled()) {
            if (!player.func_184812_l_()) {
                itemstack.func_190918_g(1);
            }
            this.setSaddled(true);
            return ActionResultType.SUCCESS;
        }
        if (item == Items.field_185161_cS && this.func_70644_a(AMEffectRegistry.ENDER_FLU)) {
            if (!player.func_184812_l_()) {
                itemstack.func_190918_g(1);
            }
            this.func_70691_i(8.0f);
            this.func_195063_d(AMEffectRegistry.ENDER_FLU);
            return ActionResultType.SUCCESS;
        }
        ActionResultType type = super.func_230254_b_(player, hand);
        if (type != ActionResultType.SUCCESS && !this.func_70877_b(itemstack) && !player.func_225608_bj_() && this.isSaddled()) {
            player.func_184220_m((Entity)this);
            return ActionResultType.SUCCESS;
        }
        return type;
    }

    public boolean func_70877_b(ItemStack stack) {
        return stack.func_77973_b() == Items.field_185161_cS;
    }

    public void func_184232_k(Entity passenger) {
        if (this.func_184196_w(passenger)) {
            float radius = -0.25f;
            float angle = (float)Math.PI / 180 * this.field_70761_aq;
            double extraX = radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)));
            double extraZ = radius * MathHelper.func_76134_b((float)angle);
            passenger.func_70107_b(this.func_226277_ct_() + extraX, this.func_226278_cu_() + this.func_70042_X() + passenger.func_70033_W(), this.func_226281_cx_() + extraZ);
        }
    }

    public double func_70042_X() {
        float f = Math.min(0.25f, this.field_70721_aZ);
        float f1 = this.field_184619_aG;
        return (double)this.func_213302_cg() - 0.1 + (double)(0.12f * MathHelper.func_76134_b((float)(f1 * 0.7f)) * 0.7f * f);
    }

    public boolean func_189652_ae() {
        return true;
    }

    public boolean isSaddled() {
        return (Boolean)this.field_70180_af.func_187225_a(SADDLED);
    }

    public void setSaddled(boolean saddled) {
        this.field_70180_af.func_187227_b(SADDLED, (Object)saddled);
    }

    public void func_70071_h_() {
        int tick;
        float f2;
        super.func_70071_h_();
        this.prevTartigradePitch = this.tartigradePitch;
        this.prevBiteProgress = this.biteProgress;
        this.tartigradePitch = f2 = (float)(-((double)((float)this.func_213322_ci().field_72448_b * 3.0f) * 57.2957763671875));
        if (this.func_213322_ci().func_189985_c() > (double)0.005f) {
            float angleMotion = (float)Math.PI / 180 * this.field_70761_aq;
            double extraXMotion = -0.2f * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angleMotion)));
            double extraZMotion = -0.2f * MathHelper.func_76134_b((float)angleMotion);
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197624_q, this.func_226282_d_(0.5), this.func_226278_cu_() + 0.3, this.func_226287_g_(0.5), extraXMotion, 0.0, extraZMotion);
        }
        if ((tick = ((Integer)this.field_70180_af.func_187225_a(BITE_TICK)).intValue()) > 0) {
            this.field_70180_af.func_187227_b(BITE_TICK, (Object)(tick - 1));
            this.biteProgress += 1.0f;
        } else if (this.biteProgress > 0.0f) {
            this.biteProgress -= 1.0f;
        }
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        return false;
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_223224_c_;
    }

    protected void func_184231_a(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    private BlockPos getGroundPosition(BlockPos radialPos) {
        while (radialPos.func_177956_o() > 1 && this.field_70170_p.func_175623_d(radialPos)) {
            radialPos = radialPos.func_177977_b();
        }
        if (radialPos.func_177956_o() <= 1) {
            return new BlockPos(radialPos.func_177958_n(), this.field_70170_p.func_181545_F(), radialPos.func_177952_p());
        }
        return radialPos;
    }

    public boolean isTargetBlocked(Vector3d target) {
        Vector3d Vector3d2 = new Vector3d(this.func_226277_ct_(), this.func_226280_cw_(), this.func_226281_cx_());
        return this.field_70170_p.func_217299_a(new RayTraceContext(Vector3d2, target, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)this)).func_216346_c() != RayTraceResult.Type.MISS;
    }

    public boolean canTargetItem(ItemStack stack) {
        return stack.func_77973_b() == Items.field_185161_cS || stack.func_77973_b() == Items.field_221663_bT;
    }

    public void onGetItem(ItemEntity targetEntity) {
        this.func_184185_a(SoundEvents.field_219607_aG, this.func_70599_aP(), this.func_70647_i());
        this.func_70691_i(5.0f);
    }

    public void bite() {
        this.field_70180_af.func_187227_b(BITE_TICK, (Object)5);
    }

    public boolean func_213380_a(IWorld worldIn, SpawnReason spawnReasonIn) {
        return AMEntityRegistry.rollSpawn(AMConfig.endergradeSpawnRolls, this.func_70681_au(), spawnReasonIn);
    }

    @Nullable
    public AgeableEntity func_241840_a(ServerWorld p_241840_1_, AgeableEntity p_241840_2_) {
        return (AgeableEntity)AMEntityRegistry.ENDERGRADE.func_200721_a((World)p_241840_1_);
    }

    public static boolean canEndergradeSpawn(EntityType<? extends AnimalEntity> animal, IWorld worldIn, SpawnReason reason, BlockPos pos, Random random) {
        return !worldIn.func_180495_p(pos.func_177977_b()).func_196958_f();
    }

    protected void func_213337_cE() {
        super.func_213337_cE();
        if (this.isSaddled() && !this.field_70170_p.field_72995_K) {
            this.func_199703_a((IItemProvider)Items.field_151141_av);
        }
    }

    static class MoveHelperController
    extends MovementController {
        private final EntityEndergrade parentEntity;

        public MoveHelperController(EntityEndergrade sunbird) {
            super((MobEntity)sunbird);
            this.parentEntity = sunbird;
        }

        public void func_75641_c() {
            if (this.field_188491_h == MovementController.Action.STRAFE) {
                Vector3d vector3d = new Vector3d(this.field_75646_b - this.parentEntity.func_226277_ct_(), this.field_75647_c - this.parentEntity.func_226278_cu_(), this.field_75644_d - this.parentEntity.func_226281_cx_());
                double d0 = vector3d.func_72433_c();
                this.parentEntity.func_213317_d(this.parentEntity.func_213322_ci().func_72441_c(0.0, vector3d.func_186678_a(this.field_75645_e * 0.05 / d0).func_82617_b(), 0.0));
                float f = (float)this.field_75648_a.func_233637_b_(Attributes.field_233821_d_);
                float f1 = (float)this.field_75645_e * f;
                float f2 = this.field_188489_f;
                float f3 = this.field_188490_g;
                float f4 = MathHelper.func_76129_c((float)(f2 * f2 + f3 * f3));
                if (f4 < 1.0f) {
                    f4 = 1.0f;
                }
                f4 = f1 / f4;
                float f5 = MathHelper.func_76126_a((float)(this.field_75648_a.field_70177_z * ((float)Math.PI / 180)));
                float f6 = MathHelper.func_76134_b((float)(this.field_75648_a.field_70177_z * ((float)Math.PI / 180)));
                float f7 = (f2 *= f4) * f6 - (f3 *= f4) * f5;
                float f8 = f3 * f6 + f2 * f5;
                this.field_188489_f = 1.0f;
                this.field_188490_g = 0.0f;
                this.field_75648_a.func_70659_e(f1);
                this.field_75648_a.func_191989_p(this.field_188489_f);
                this.field_75648_a.func_184646_p(this.field_188490_g);
                this.field_188491_h = MovementController.Action.WAIT;
            } else if (this.field_188491_h == MovementController.Action.MOVE_TO) {
                Vector3d vector3d = new Vector3d(this.field_75646_b - this.parentEntity.func_226277_ct_(), this.field_75647_c - this.parentEntity.func_226278_cu_(), this.field_75644_d - this.parentEntity.func_226281_cx_());
                double d0 = vector3d.func_72433_c();
                if (d0 < this.parentEntity.func_174813_aQ().func_72320_b()) {
                    this.field_188491_h = MovementController.Action.WAIT;
                    this.parentEntity.func_213317_d(this.parentEntity.func_213322_ci().func_186678_a(0.5));
                } else {
                    double localSpeed = this.field_75645_e;
                    if (this.parentEntity.func_184207_aI()) {
                        localSpeed *= 1.5;
                    }
                    this.parentEntity.func_213317_d(this.parentEntity.func_213322_ci().func_178787_e(vector3d.func_186678_a(localSpeed * 0.005 / d0)));
                    if (this.parentEntity.func_70638_az() == null) {
                        Vector3d vector3d1 = this.parentEntity.func_213322_ci();
                        this.parentEntity.field_70761_aq = this.parentEntity.field_70177_z = -((float)MathHelper.func_181159_b((double)vector3d1.field_72450_a, (double)vector3d1.field_72449_c)) * 57.295776f;
                    } else {
                        double d2 = this.parentEntity.func_70638_az().func_226277_ct_() - this.parentEntity.func_226277_ct_();
                        double d1 = this.parentEntity.func_70638_az().func_226281_cx_() - this.parentEntity.func_226281_cx_();
                        this.parentEntity.field_70761_aq = this.parentEntity.field_70177_z = -((float)MathHelper.func_181159_b((double)d2, (double)d1)) * 57.295776f;
                    }
                }
            }
        }

        private boolean func_220673_a(Vector3d p_220673_1_, int p_220673_2_) {
            AxisAlignedBB axisalignedbb = this.parentEntity.func_174813_aQ();
            for (int i = 1; i < p_220673_2_; ++i) {
                if (this.parentEntity.field_70170_p.func_226665_a__((Entity)this.parentEntity, axisalignedbb = axisalignedbb.func_191194_a(p_220673_1_))) continue;
                return false;
            }
            return true;
        }
    }

    static class RandomFlyGoal
    extends Goal {
        private final EntityEndergrade parentEntity;
        private BlockPos target = null;

        public RandomFlyGoal(EntityEndergrade mosquito) {
            this.parentEntity = mosquito;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            MovementController movementcontroller = this.parentEntity.func_70605_aq();
            if (this.parentEntity.stopWandering || this.parentEntity.hasItemTarget) {
                return false;
            }
            if (!movementcontroller.func_75640_a() || this.target == null) {
                this.target = this.getBlockInViewEndergrade();
                if (this.target != null) {
                    this.parentEntity.func_70605_aq().func_75642_a((double)this.target.func_177958_n() + 0.5, (double)this.target.func_177956_o() + 0.5, (double)this.target.func_177952_p() + 0.5, 1.0);
                }
                return true;
            }
            return false;
        }

        public boolean func_75253_b() {
            return this.target != null && !this.parentEntity.stopWandering && !this.parentEntity.hasItemTarget && this.parentEntity.func_195048_a(Vector3d.func_237489_a_((Vector3i)this.target)) > 2.4 && this.parentEntity.func_70605_aq().func_75640_a() && !this.parentEntity.field_70123_F;
        }

        public void func_75251_c() {
            this.target = null;
        }

        public void func_75246_d() {
            if (this.target == null) {
                this.target = this.getBlockInViewEndergrade();
            }
            if (this.target != null) {
                this.parentEntity.func_70605_aq().func_75642_a((double)this.target.func_177958_n() + 0.5, (double)this.target.func_177956_o() + 0.5, (double)this.target.func_177952_p() + 0.5, 1.0);
                if (this.parentEntity.func_195048_a(Vector3d.func_237489_a_((Vector3i)this.target)) < 2.5) {
                    this.target = null;
                }
            }
        }

        public BlockPos getBlockInViewEndergrade() {
            float radius = 1 + this.parentEntity.func_70681_au().nextInt(5);
            float neg = this.parentEntity.func_70681_au().nextBoolean() ? 1.0f : -1.0f;
            float renderYawOffset = this.parentEntity.field_70761_aq;
            float angle = (float)Math.PI / 180 * renderYawOffset + 3.15f + this.parentEntity.func_70681_au().nextFloat() * neg;
            double extraX = radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)));
            double extraZ = radius * MathHelper.func_76134_b((float)angle);
            BlockPos radialPos = new BlockPos(this.parentEntity.func_226277_ct_() + extraX, this.parentEntity.func_226278_cu_() + 2.0, this.parentEntity.func_226281_cx_() + extraZ);
            BlockPos ground = this.parentEntity.getGroundPosition(radialPos);
            BlockPos newPos = ground.func_177981_b(1 + this.parentEntity.func_70681_au().nextInt(6));
            if (!this.parentEntity.isTargetBlocked(Vector3d.func_237489_a_((Vector3i)newPos)) && this.parentEntity.func_195048_a(Vector3d.func_237489_a_((Vector3i)newPos)) > 6.0) {
                return newPos;
            }
            return null;
        }
    }
}

