/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.abnormals_core.core.util.modification;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.minecraftabnormals.abnormals_core.core.AbnormalsCore;
import com.minecraftabnormals.abnormals_core.core.util.modification.ConfiguredModifier;
import com.minecraftabnormals.abnormals_core.core.util.modification.IModifier;
import com.minecraftabnormals.abnormals_core.core.util.modification.ModifierRegistry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;

public final class TargetedModifier<T, S, D> {
    private final ResourceLocation target;
    private final List<ConfiguredModifier<T, ?, S, D, ?>> configuredModifiers;

    public TargetedModifier(ResourceLocation target, List<ConfiguredModifier<T, ?, S, D, ?>> configuredModifiers) {
        this.target = target;
        this.configuredModifiers = configuredModifiers;
    }

    public static <T, S, D> TargetedModifier<T, S, D> deserialize(JsonObject object, D additional, ModifierRegistry<T, S, D> registry) {
        return TargetedModifier.deserialize(object, "target", additional, registry, true);
    }

    public static <T, S, D> TargetedModifier<T, S, D> deserialize(JsonObject object, String targetKey, D additional, ModifierRegistry<T, S, D> registry, boolean logSkipping) throws JsonParseException {
        ResourceLocation target = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)object, (String)targetKey));
        ArrayList configuredModifiers = new ArrayList();
        JsonArray modifiers = JSONUtils.func_151214_t((JsonObject)object, (String)"modifiers");
        modifiers.forEach(element -> {
            JsonObject entry = element.getAsJsonObject();
            String type = JSONUtils.func_151200_h((JsonObject)entry, (String)"type");
            if (!JSONUtils.func_151204_g((JsonObject)entry, (String)"conditions") || CraftingHelper.processConditions((JsonArray)JSONUtils.func_151214_t((JsonObject)entry, (String)"conditions"))) {
                IModifier configuredModifier = registry.getModifier(type);
                if (configuredModifier == null) {
                    throw new JsonParseException("Unknown modifier type: " + type);
                }
                JsonElement config = entry.get("config");
                if (config == null) {
                    throw new JsonParseException("Missing 'config' element!");
                }
                configuredModifiers.add(configuredModifier.deserializeConfigured(config, additional));
            } else if (logSkipping) {
                AbnormalsCore.LOGGER.info("Skipped modifier \"" + type + "\" for target \"" + target + "\" as its conditions were not met");
            }
        });
        return new TargetedModifier<T, S, D>(target, configuredModifiers);
    }

    public JsonObject serialize(S additional, String targetKey, ModifierRegistry<T, S, D> modifierRegistry, ICondition[][] conditions) throws JsonParseException {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty(targetKey, this.target.toString());
        JsonArray modifiers = new JsonArray();
        List<ConfiguredModifier<T, ?, S, D, ?>> configuredModifiers = this.configuredModifiers;
        int conditionsLength = conditions.length;
        for (int i = 0; i < configuredModifiers.size(); ++i) {
            ConfiguredModifier<T, ?, S, D, ?> configuredModifier = configuredModifiers.get(i);
            JsonObject object = new JsonObject();
            object.addProperty("type", modifierRegistry.getName((IModifier<T, ?, S, D>)configuredModifier.getModifer()));
            if (i < conditionsLength) {
                ICondition[] conditionsArray;
                JsonArray conditionsObject = new JsonArray();
                for (ICondition condition : conditionsArray = conditions[i]) {
                    conditionsObject.add((JsonElement)CraftingHelper.serialize((ICondition)condition));
                }
            }
            object.add("config", configuredModifier.serialize(additional));
            modifiers.add((JsonElement)object);
        }
        jsonObject.add("modifiers", (JsonElement)modifiers);
        return jsonObject;
    }

    public ResourceLocation getTarget() {
        return this.target;
    }

    public List<ConfiguredModifier<T, ?, S, D, ?>> getConfiguredModifiers() {
        return this.configuredModifiers;
    }
}

