/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.abnormals_core.core.api.model;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.util.Pair;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.BlockFaceUV;
import net.minecraft.client.renderer.model.BlockModel;
import net.minecraft.client.renderer.model.BlockPart;
import net.minecraft.client.renderer.model.BlockPartFace;
import net.minecraft.client.renderer.model.BlockPartRotation;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.Direction;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.client.model.IModelBuilder;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.geometry.ISimpleModelGeometry;
import net.minecraftforge.client.model.pipeline.LightUtil;

public class FullbrightModel
implements ISimpleModelGeometry<FullbrightModel> {
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(FullbrightBlockPart.class, (Object)new FullbrightBlockPart.Deserializer()).registerTypeAdapter(FullbrightBlockPartFace.class, (Object)new FullbrightBlockPartFace.Deserializer()).registerTypeAdapter(BlockFaceUV.class, (Object)new BlockFaceUV.Deserializer()).create();
    private final List<FullbrightBlockPart> elements;

    private FullbrightModel(List<FullbrightBlockPart> list) {
        this.elements = list;
    }

    public void addQuads(IModelConfiguration owner, IModelBuilder<?> modelBuilder, ModelBakery bakery, Function<RenderMaterial, TextureAtlasSprite> spriteGetter, IModelTransform modelTransform, ResourceLocation modelLocation) {
        for (FullbrightBlockPart part : this.elements) {
            for (Map.Entry entry : part.field_178240_c.entrySet()) {
                FullbrightBlockPartFace face = (FullbrightBlockPartFace)((Object)entry.getValue());
                BakedQuad quad = BlockModel.makeBakedQuad((BlockPart)part, (BlockPartFace)face, (TextureAtlasSprite)spriteGetter.apply(owner.resolveTexture(face.field_178242_d)), (Direction)((Direction)entry.getKey()), (IModelTransform)modelTransform, (ResourceLocation)modelLocation);
                if (!face.override && part.fullbright || face.override && face.fullbright) {
                    LightUtil.setLightData((BakedQuad)quad, (int)0xF000F0);
                }
                if (face.field_178244_b == null) {
                    modelBuilder.addGeneralQuad(quad);
                    continue;
                }
                modelBuilder.addFaceQuad(modelTransform.func_225615_b_().rotateTransform(face.field_178244_b), quad);
            }
        }
    }

    public Collection<RenderMaterial> getTextures(IModelConfiguration owner, Function<ResourceLocation, IUnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        HashSet textures = Sets.newHashSet();
        for (FullbrightBlockPart part : this.elements) {
            for (BlockPartFace face : part.field_178240_c.values()) {
                textures.add(owner.resolveTexture(face.field_178242_d));
            }
        }
        return textures;
    }

    private static class FullbrightBlockPart
    extends BlockPart {
        private final boolean fullbright;

        private FullbrightBlockPart(Vector3f positionFrom, Vector3f positionTo, Map<Direction, BlockPartFace> mapFaces, @Nullable BlockPartRotation partRotation, boolean shade, boolean fullbright) {
            super(positionFrom, positionTo, mapFaces, partRotation, shade);
            this.fullbright = fullbright;
        }

        private static class Deserializer
        implements JsonDeserializer<FullbrightBlockPart> {
            private Deserializer() {
            }

            public FullbrightBlockPart deserialize(JsonElement element, Type type, JsonDeserializationContext context) throws JsonParseException {
                JsonObject object = element.getAsJsonObject();
                Vector3f from = this.validateVectorBounds(object, "from");
                Vector3f to = this.validateVectorBounds(object, "to");
                BlockPartRotation rotation = this.parseRotation(object);
                Map<Direction, BlockPartFace> faces = this.parseFacesCheck(object);
                if (object.has("shade") && !JSONUtils.func_180199_c((JsonObject)object, (String)"shade")) {
                    throw new JsonParseException("Expected shade to be a Boolean");
                }
                if (object.has("fullbright") && !JSONUtils.func_180199_c((JsonObject)object, (String)"fullbright")) {
                    throw new JsonParseException("Expected fullbright to be a Boolean");
                }
                return new FullbrightBlockPart(from, to, faces, rotation, JSONUtils.func_151209_a((JsonObject)object, (String)"shade", (boolean)true), JSONUtils.func_151209_a((JsonObject)object, (String)"fullbright", (boolean)false));
            }

            @Nullable
            private BlockPartRotation parseRotation(JsonObject object) {
                BlockPartRotation rotation = null;
                if (object.has("rotation")) {
                    JsonObject rotObject = JSONUtils.func_152754_s((JsonObject)object, (String)"rotation");
                    Vector3f origin = this.deserializeVec3f(rotObject, "origin");
                    origin.func_195898_a(0.0625f);
                    rotation = new BlockPartRotation(origin, this.parseAxis(rotObject), this.parseAngle(rotObject), JSONUtils.func_151209_a((JsonObject)rotObject, (String)"rescale", (boolean)false));
                }
                return rotation;
            }

            private float parseAngle(JsonObject object) {
                float angle = JSONUtils.func_151217_k((JsonObject)object, (String)"angle");
                if (angle != 0.0f && MathHelper.func_76135_e((float)angle) != 22.5f && MathHelper.func_76135_e((float)angle) != 45.0f) {
                    throw new JsonParseException("Invalid rotation " + angle + " found, only -45/-22.5/0/22.5/45 allowed");
                }
                return angle;
            }

            private Direction.Axis parseAxis(JsonObject object) {
                String axisName = JSONUtils.func_151200_h((JsonObject)object, (String)"axis");
                Direction.Axis axis = Direction.Axis.func_176717_a((String)axisName.toLowerCase(Locale.ROOT));
                if (axis == null) {
                    throw new JsonParseException("Invalid rotation axis: " + axisName);
                }
                return axis;
            }

            private Map<Direction, BlockPartFace> parseFacesCheck(JsonObject object) {
                Map<Direction, BlockPartFace> faces = this.parseFaces(object);
                if (faces.isEmpty()) {
                    throw new JsonParseException("Expected between 1 and 6 unique faces, got 0");
                }
                return faces;
            }

            private Map<Direction, BlockPartFace> parseFaces(JsonObject object) {
                EnumMap faces = Maps.newEnumMap(Direction.class);
                JsonObject facesObject = JSONUtils.func_152754_s((JsonObject)object, (String)"faces");
                for (Map.Entry entry : facesObject.entrySet()) {
                    Direction direction = this.parseEnumFacing((String)entry.getKey());
                    faces.put(direction, GSON.fromJson((JsonElement)entry.getValue(), FullbrightBlockPartFace.class));
                }
                return faces;
            }

            private Direction parseEnumFacing(String name) {
                Direction direction = Direction.func_176739_a((String)name);
                if (direction == null) {
                    throw new JsonParseException("Unknown facing: " + name);
                }
                return direction;
            }

            private Vector3f validateVectorBounds(JsonObject object, String name) {
                Vector3f vector = this.deserializeVec3f(object, name);
                if (vector.func_195899_a() >= -16.0f && vector.func_195900_b() >= -16.0f && vector.func_195902_c() >= -16.0f && vector.func_195899_a() <= 32.0f && vector.func_195900_b() <= 32.0f && vector.func_195902_c() <= 32.0f) {
                    return vector;
                }
                throw new JsonParseException("'" + name + "' specifier exceeds the allowed boundaries: " + vector);
            }

            private Vector3f deserializeVec3f(JsonObject object, String name) {
                JsonArray vectorJson = JSONUtils.func_151214_t((JsonObject)object, (String)name);
                if (vectorJson.size() != 3) {
                    throw new JsonParseException("Expected 3 " + name + " values, found: " + vectorJson.size());
                }
                float[] vector = new float[3];
                for (int i = 0; i < 3; ++i) {
                    vector[i] = JSONUtils.func_151220_d((JsonElement)vectorJson.get(i), (String)(name + "[" + i + "]"));
                }
                return new Vector3f(vector[0], vector[1], vector[2]);
            }
        }
    }

    private static class FullbrightBlockPartFace
    extends BlockPartFace {
        private final boolean fullbright;
        private final boolean override;

        private FullbrightBlockPartFace(@Nullable Direction cullFaceIn, int tintIndexIn, String textureIn, BlockFaceUV blockFaceUVIn, boolean fullbright, boolean override) {
            super(cullFaceIn, tintIndexIn, textureIn, blockFaceUVIn);
            this.fullbright = fullbright;
            this.override = override;
        }

        private static class Deserializer
        extends BlockPartFace.Deserializer {
            private Deserializer() {
            }

            public BlockPartFace deserialize(JsonElement element, Type type, JsonDeserializationContext context) throws JsonParseException {
                BlockPartFace face = super.deserialize(element, type, context);
                JsonObject object = element.getAsJsonObject();
                if (object.has("fullbright") && !JSONUtils.func_180199_c((JsonObject)object, (String)"fullbright")) {
                    throw new JsonParseException("Expected fullbright to be a Boolean");
                }
                return new FullbrightBlockPartFace(face.field_178244_b, face.field_178245_c, face.field_178242_d, face.field_178243_e, JSONUtils.func_151209_a((JsonObject)object, (String)"fullbright", (boolean)false), object.has("fullbright"));
            }
        }
    }

    public static enum Loader implements IModelLoader<FullbrightModel>
    {
        INSTANCE;


        public void func_195410_a(IResourceManager manager) {
        }

        public FullbrightModel read(JsonDeserializationContext context, JsonObject model) {
            ArrayList list = Lists.newArrayList();
            if (model.has("elements")) {
                for (JsonElement jsonelement : JSONUtils.func_151214_t((JsonObject)model, (String)"elements")) {
                    list.add(GSON.fromJson(jsonelement, FullbrightBlockPart.class));
                }
            }
            return new FullbrightModel(list);
        }
    }
}

