/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.region.texture;

import com.mojang.blaze3d.platform.GlStateManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.shader.Framebuffer;
import org.lwjgl.opengl.GL11;
import xaero.map.exception.OpenGLException;
import xaero.map.graphics.ImprovedFramebuffer;
import xaero.map.graphics.MapRenderHelper;
import xaero.map.misc.Misc;

public class BranchTextureRenderer {
    private ImprovedFramebuffer renderFBO = new ImprovedFramebuffer(64, 64, false);
    private int glEmptyTexture = this.renderFBO.getFramebufferTexture();

    public BranchTextureRenderer(Framebuffer defaultFramebuffer) {
        this.renderFBO.func_147610_a(true);
        GlStateManager.func_227700_d_();
        GlStateManager.func_227737_l_();
        GlStateManager.func_227673_b_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_227658_a_((int)16384, (boolean)Minecraft.field_142025_a);
        GlStateManager.func_227709_e_();
        GlStateManager.func_227740_m_();
        this.renderFBO.func_147609_e();
        ImprovedFramebuffer.bindFramebuffer(this.renderFBO.getType(), 36160, defaultFramebuffer.field_147616_f);
        GlStateManager.func_227714_e_((int)0, (int)0, (int)defaultFramebuffer.field_147621_c, (int)defaultFramebuffer.field_147618_d);
    }

    public void render(int destTexture, Integer srcTextureTopLeft, Integer srcTextureTopRight, Integer srcTextureBottomLeft, Integer srcTextureBottomRight, Framebuffer defaultFramebuffer, boolean justAllocated) {
        GlStateManager.func_227760_t_((int)0);
        this.renderFBO.func_147610_a(true);
        this.renderFBO.setFramebufferTexture(destTexture);
        OpenGLException.checkGLError();
        GlStateManager.func_227626_N_();
        GlStateManager.func_227625_M_();
        GlStateManager.func_227768_x_((int)5889);
        GlStateManager.func_227625_M_();
        GlStateManager.func_227633_a_((double)0.0, (double)64.0, (double)64.0, (double)0.0, (double)-1.0, (double)1.0);
        GlStateManager.func_227768_x_((int)5888);
        GlStateManager.func_227700_d_();
        GlStateManager.func_227737_l_();
        if (justAllocated) {
            GlStateManager.func_227673_b_((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_227658_a_((int)16384, (boolean)Minecraft.field_142025_a);
        }
        if (srcTextureTopLeft != null) {
            this.renderCorner(srcTextureTopLeft, 0, 0);
        }
        if (srcTextureTopRight != null) {
            this.renderCorner(srcTextureTopRight, 1, 0);
        }
        if (srcTextureBottomLeft != null) {
            this.renderCorner(srcTextureBottomLeft, 0, 1);
        }
        if (srcTextureBottomRight != null) {
            this.renderCorner(srcTextureBottomRight, 1, 1);
        }
        OpenGLException.checkGLError();
        GlStateManager.func_227709_e_();
        GlStateManager.func_227740_m_();
        GlStateManager.func_227760_t_((int)0);
        GlStateManager.func_227627_O_();
        GlStateManager.func_227768_x_((int)5889);
        Minecraft mc = Minecraft.func_71410_x();
        Misc.minecraftOrtho(mc);
        GlStateManager.func_227768_x_((int)5888);
        this.renderFBO.func_147609_e();
        ImprovedFramebuffer.bindDefaultFramebuffer(this.renderFBO.getType(), 36160, mc);
        GlStateManager.func_227714_e_((int)0, (int)0, (int)mc.func_228018_at_().func_198109_k(), (int)mc.func_228018_at_().func_198091_l());
        OpenGLException.checkGLError();
    }

    private void renderCorner(Integer srcTexture, int cornerX, int cornerY) {
        int xOffset = cornerX * 32;
        int yOffset = (1 - cornerY) * 32;
        GlStateManager.func_227760_t_((int)(srcTexture != -1 ? srcTexture : this.glEmptyTexture));
        MapRenderHelper.renderTexturedModalRect(xOffset, yOffset, 32.0f, 32.0f, 0, 64, 64.0f, -64.0f, 64.0f, 64.0f);
    }
}

