/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.mods.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.IOException;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import xaero.common.IXaeroMinimap;
import xaero.common.XaeroMinimapSession;
import xaero.common.gui.GuiNewSet;
import xaero.common.gui.GuiWaypointSets;
import xaero.common.minimap.waypoints.WaypointWorld;
import xaero.common.settings.ModSettings;
import xaero.map.WorldMap;
import xaero.map.element.MapElementMenuRenderer;
import xaero.map.element.MapElementRenderer;
import xaero.map.gui.CursorBox;
import xaero.map.gui.GuiDropDown;
import xaero.map.gui.GuiMap;
import xaero.map.gui.GuiTexturedButton;
import xaero.map.gui.IDropDownCallback;
import xaero.map.misc.Misc;
import xaero.map.mods.SupportMods;
import xaero.map.mods.gui.Waypoint;
import xaero.map.mods.gui.WaypointMenuRenderContext;
import xaero.map.mods.gui.WaypointMenuRenderProvider;
import xaero.map.mods.gui.WaypointRenderer;

public class WaypointMenuRenderer
extends MapElementMenuRenderer<Waypoint, WaypointMenuRenderContext> {
    private final WaypointRenderer renderer;

    public WaypointMenuRenderer(WaypointMenuRenderContext context, WaypointMenuRenderProvider provider, WaypointRenderer renderer) {
        super(context, provider);
        this.renderer = renderer;
    }

    public void onMapInit(GuiMap screen, List<GuiDropDown> dropdowns, Minecraft mc, int width, int height, WaypointWorld waypointWorld, IXaeroMinimap modMain, XaeroMinimapSession minimapSession) {
        GuiDropDown setsDropdown;
        super.onMapInit(screen, dropdowns, mc, width, height);
        boolean canCreate = SupportMods.xaeroMinimap.compatibilityVersion >= 6;
        GuiWaypointSets sets = waypointWorld != null ? new GuiWaypointSets(canCreate, waypointWorld) : null;
        IDropDownCallback setsDropdownCallback = null;
        if (sets != null) {
            setsDropdownCallback = (menu, selected) -> {
                if (canCreate && selected == menu.size() - 1) {
                    GuiNewSet guiNewSet = new GuiNewSet(modMain, minimapSession, (Screen)screen, (Screen)screen, waypointWorld);
                    Minecraft.func_71410_x().func_147108_a((Screen)guiNewSet);
                    return false;
                }
                sets.setCurrentSet(selected);
                waypointWorld.setCurrent(sets.getCurrentSetKey());
                minimapSession.getWaypointsManager().updateWaypoints();
                try {
                    modMain.getSettings().saveWaypoints(waypointWorld);
                }
                catch (IOException e) {
                    WorldMap.LOGGER.error("suppressed exception", (Throwable)e);
                }
                return true;
            };
        }
        GuiDropDown guiDropDown = setsDropdown = sets == null ? null : new GuiDropDown(sets.getOptions(), width - 173, height - 56, 151, sets.getCurrentSet(), true, setsDropdownCallback, true);
        if (setsDropdown != null) {
            dropdowns.add(setsDropdown);
        }
        TranslationTextComponent fullWaypointMenuTooltipText = new TranslationTextComponent("gui.xaero_box_full_waypoints_menu", new Object[]{new StringTextComponent(Misc.getKeyName(ModSettings.keyWaypoints)).func_240699_a_(TextFormatting.DARK_GREEN)});
        screen.addButton(new GuiTexturedButton(width - 173, height - 20, 20, 20, 229, 0, 16, 16, WorldMap.guiTextures, b -> this.onFullMenuButton(b, screen), new CursorBox((ITextComponent)fullWaypointMenuTooltipText, true)));
        screen.addButton(new GuiTexturedButton(width - 153, height - 20, 20, 20, WorldMap.settings.onlyCurrentMapWaypoints ? 213 : 229, 16, 16, 16, WorldMap.guiTextures, b -> this.onCurrentMapWaypointsButton(b, screen, width, height), new CursorBox(WorldMap.settings.onlyCurrentMapWaypoints ? "gui.xaero_box_only_current_map_waypoints" : "gui.xaero_box_waypoints_selected_by_minimap", Style.field_240709_b_, true)));
        screen.addButton(new GuiTexturedButton(width - 133, height - 20, 20, 20, WorldMap.settings.renderWaypoints ? 229 : 213, 48, 16, 16, WorldMap.guiTextures, b -> this.onRenderWaypointsButton(screen, width, height), new CursorBox((ITextComponent)new TranslationTextComponent(WorldMap.settings.renderWaypoints ? "gui.xaero_box_rendering_waypoints" : "gui.xaero_box_not_rendering_waypoints", new Object[]{new StringTextComponent(Misc.getKeyName(ModSettings.keyToggleMapWaypoints)).func_240699_a_(TextFormatting.DARK_GREEN)}), true)));
        screen.addButton(new GuiTexturedButton(width - 113, height - 20, 20, 20, !modMain.getSettings().renderAllSets ? 81 : 97, 16, 16, 16, WorldMap.guiTextures, b -> this.onRenderAllSetsButton(b, screen, width, height), new CursorBox((ITextComponent)new TranslationTextComponent(!modMain.getSettings().renderAllSets ? "gui.xaero_box_rendering_current_set" : "gui.xaero_box_rendering_all_sets", new Object[]{new StringTextComponent(Misc.getKeyName(ModSettings.keyAllSets)).func_240699_a_(TextFormatting.DARK_GREEN)}), true)));
        screen.addButton(new GuiTexturedButton(width - 93, height - 20, 20, 20, WorldMap.settings.showDisabledWaypoints ? 133 : 149, 16, 16, 16, WorldMap.guiTextures, b -> this.onShowDisabledButton(b, screen, width, height), new CursorBox(WorldMap.settings.showDisabledWaypoints ? "gui.xaero_box_showing_disabled" : "gui.xaero_box_hiding_disabled", Style.field_240709_b_, true)));
        screen.addButton(new GuiTexturedButton(width - 73, height - 20, 20, 20, WorldMap.settings.closeWaypointsWhenHopping ? 181 : 197, 16, 16, 16, WorldMap.guiTextures, b -> this.onCloseMenuWhenHoppingButton(b, screen, width, height), new CursorBox(WorldMap.settings.closeWaypointsWhenHopping ? "gui.xaero_box_closing_menu_when_hopping" : "gui.xaero_box_not_closing_menu_when_hopping", Style.field_240709_b_, true)));
    }

    public void onRenderWaypointsButton(GuiMap screen, int width, int height) {
        WorldMap.settings.renderWaypoints = !WorldMap.settings.renderWaypoints;
        try {
            WorldMap.settings.saveSettings();
        }
        catch (IOException e) {
            WorldMap.LOGGER.error("suppressed exception", (Throwable)e);
        }
        screen.func_231158_b_(this.mc, width, height);
    }

    private void onFullMenuButton(Button b, GuiMap screen) {
        SupportMods.xaeroMinimap.openWaypointsMenu(this.mc, screen);
    }

    private void onRenderAllSetsButton(Button b, GuiMap screen, int width, int height) {
        SupportMods.xaeroMinimap.handleMinimapKeyBinding(ModSettings.keyAllSets, screen);
    }

    private void onShowDisabledButton(Button b, GuiMap screen, int width, int height) {
        WorldMap.settings.showDisabledWaypoints = !WorldMap.settings.showDisabledWaypoints;
        try {
            WorldMap.settings.saveSettings();
        }
        catch (IOException e) {
            WorldMap.LOGGER.error("suppressed exception", (Throwable)e);
        }
        screen.func_231158_b_(this.mc, width, height);
    }

    private void onCloseMenuWhenHoppingButton(Button b, GuiMap screen, int width, int height) {
        WorldMap.settings.closeWaypointsWhenHopping = !WorldMap.settings.closeWaypointsWhenHopping;
        try {
            WorldMap.settings.saveSettings();
        }
        catch (IOException e) {
            WorldMap.LOGGER.error("suppressed exception", (Throwable)e);
        }
        screen.func_231158_b_(this.mc, width, height);
    }

    private void onCurrentMapWaypointsButton(Button b, GuiMap screen, int width, int height) {
        WorldMap.settings.onlyCurrentMapWaypoints = !WorldMap.settings.onlyCurrentMapWaypoints;
        try {
            WorldMap.settings.saveSettings();
        }
        catch (IOException e) {
            WorldMap.LOGGER.error("suppressed exception", (Throwable)e);
        }
        screen.func_231158_b_(this.mc, width, height);
    }

    @Override
    public void renderInMenu(Waypoint element, MatrixStack matrixStack, Screen gui, int mouseX, int mouseY, double scale, boolean enabled, boolean hovered, Minecraft mc, boolean pressed, int textX) {
        Waypoint w = element;
        boolean disabled = w.isDisabled();
        boolean temporary = w.isTemporary();
        int type = w.getType();
        int color = w.getColor();
        String symbol = w.getSymbol();
        matrixStack.func_227861_a_(-4.0, -4.0, 0.0);
        RenderSystem.enableBlend();
        if (type == 1) {
            AbstractGui.func_238467_a_((MatrixStack)matrixStack, (int)0, (int)0, (int)9, (int)9, (int)color);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(Waypoint.minimapTextures);
            RenderSystem.color4f((float)0.2431f, (float)0.2431f, (float)0.2431f, (float)1.0f);
            gui.func_238474_b_(matrixStack, 1, 1, 0, 78, 9, 9);
            RenderSystem.color4f((float)0.9882f, (float)0.9882f, (float)0.9882f, (float)1.0f);
            gui.func_238474_b_(matrixStack, 0, 0, 0, 78, 9, 9);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        } else {
            RenderSystem.disableTexture();
            AbstractGui.func_238467_a_((MatrixStack)matrixStack, (int)0, (int)0, (int)9, (int)9, (int)color);
        }
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (type != 1) {
            mc.field_71466_p.func_238405_a_(matrixStack, symbol, (float)(5 - mc.field_71466_p.func_78256_a(symbol) / 2), 1.0f, -1);
        }
        RenderSystem.enableBlend();
        int infoIconOffset = 10;
        if (disabled) {
            RenderSystem.enableTexture();
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)0.0f, (float)1.0f);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(WorldMap.guiTextures);
            gui.func_238474_b_(matrixStack, textX - 1 - infoIconOffset, 0, 173, 16, 8, 8);
            infoIconOffset += 10;
        }
        if (temporary) {
            RenderSystem.enableTexture();
            RenderSystem.color4f((float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(WorldMap.guiTextures);
            gui.func_238474_b_(matrixStack, textX - 1 - infoIconOffset, 0, 165, 16, 8, 8);
            infoIconOffset += 10;
        }
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Override
    public int menuStartPos(int height) {
        return height - 59;
    }

    @Override
    public int menuSearchPadding() {
        return 14;
    }

    @Override
    protected String getFilterPlaceholder() {
        return "gui.xaero_filter_waypoints_by_name";
    }

    @Override
    protected MapElementRenderer<? super Waypoint, ?, ?> getRenderer(Waypoint element) {
        return this.renderer;
    }

    @Override
    protected void beforeFiltering() {
    }

    @Override
    protected void beforeMenuRender() {
    }

    @Override
    protected void afterMenuRender() {
    }
}

