/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.mods;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraft.util.RegistryKey;
import net.minecraft.world.World;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import xaero.common.IXaeroMinimap;
import xaero.common.XaeroMinimapSession;
import xaero.common.effect.Effects;
import xaero.common.gui.GuiAddWaypoint;
import xaero.common.gui.GuiWaypoints;
import xaero.common.gui.GuiWorldTpCommand;
import xaero.common.minimap.highlight.DimensionHighlighterHandler;
import xaero.common.minimap.render.radar.element.RadarRenderer;
import xaero.common.minimap.waypoints.WaypointSet;
import xaero.common.minimap.waypoints.WaypointWorld;
import xaero.common.minimap.waypoints.WaypointWorldContainer;
import xaero.common.minimap.waypoints.WaypointWorldRootContainer;
import xaero.common.minimap.waypoints.WaypointsManager;
import xaero.common.misc.Misc;
import xaero.common.mods.SupportXaeroWorldmap;
import xaero.common.settings.ModSettings;
import xaero.map.WorldMap;
import xaero.map.element.HoveredMapElementHolder;
import xaero.map.gui.GuiDropDown;
import xaero.map.gui.GuiMap;
import xaero.map.misc.KeySortableByOther;
import xaero.map.mods.SupportBetterPVP;
import xaero.map.mods.SupportMinimap;
import xaero.map.mods.gui.Waypoint;
import xaero.map.mods.gui.WaypointMenuRenderContext;
import xaero.map.mods.gui.WaypointMenuRenderProvider;
import xaero.map.mods.gui.WaypointMenuRenderer;
import xaero.map.mods.gui.WaypointRenderer;
import xaero.map.mods.minimap.element.RadarRendererWrapperHelper;

public class SupportXaeroMinimap {
    IXaeroMinimap modMain;
    public int compatibilityVersion;
    private boolean deathpoints = true;
    private boolean refreshWaypoints = true;
    private WaypointWorld waypointWorld;
    private WaypointWorld mapWaypointWorld;
    private double dimDiv;
    private WaypointSet waypointSet;
    private boolean allSets;
    private ArrayList<Waypoint> waypoints;
    private ArrayList<Waypoint> waypointsSorted;
    private WaypointMenuRenderer waypointMenuRenderer;
    private final WaypointRenderer waypointRenderer;

    public SupportXaeroMinimap() {
        try {
            Class<?> mmClassTest = Class.forName("xaero.pvp.BetterPVP");
            this.modMain = SupportBetterPVP.getMain();
            WorldMap.LOGGER.info("Xaero's WorldMap Mod: Better PVP found!");
        }
        catch (ClassNotFoundException e) {
            try {
                Class<?> mmClassTest = Class.forName("xaero.minimap.XaeroMinimap");
                this.modMain = SupportMinimap.getMain();
                WorldMap.LOGGER.info("Xaero's WorldMap Mod: Xaero's minimap found!");
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (this.modMain != null) {
            try {
                this.compatibilityVersion = SupportXaeroWorldmap.WORLDMAP_COMPATIBILITY_VERSION;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            if (this.compatibilityVersion < 3) {
                throw new RuntimeException("Xaero's Minimap 20.23.0 or newer required!");
            }
        }
        this.waypointRenderer = WaypointRenderer.Builder.begin().setMinimap(this).setSymbolCreator(WorldMap.waypointSymbolCreator).build();
    }

    public ArrayList<Waypoint> convertWaypoints(double dimDiv) {
        if (this.waypointSet == null) {
            return null;
        }
        ArrayList<Waypoint> result = new ArrayList<Waypoint>();
        if (!this.allSets) {
            this.convertSet(this.waypointSet, result, dimDiv);
        } else {
            HashMap sets = this.waypointWorld.getSets();
            for (WaypointSet set : sets.values()) {
                this.convertSet(set, result, dimDiv);
            }
        }
        this.deathpoints = this.modMain.getSettings().getDeathpoints();
        return result;
    }

    private void convertSet(WaypointSet set, ArrayList<Waypoint> result, double dimDiv) {
        ArrayList list = set.getList();
        String setName = set.getName();
        boolean showingDisabled = WorldMap.settings.showDisabledWaypoints;
        for (int i = 0; i < list.size(); ++i) {
            xaero.common.minimap.waypoints.Waypoint w = (xaero.common.minimap.waypoints.Waypoint)list.get(i);
            if (!showingDisabled && w.isDisabled()) continue;
            result.add(this.convertWaypoint(w, true, setName, dimDiv));
        }
    }

    public Waypoint convertWaypoint(xaero.common.minimap.waypoints.Waypoint w, boolean editable, String setName, double dimDiv) {
        int waypointType = 0;
        waypointType = this.compatibilityVersion < 9 ? w.getType() : w.getWaypointType();
        Waypoint converted = new Waypoint(w, w.getX(), w.getY(), w.getZ(), w.getName(), w.getSymbol(), ModSettings.COLORS[w.getColor()], waypointType, editable, setName, this.compatibilityVersion < 7 ? true : w.isYIncluded(), dimDiv);
        converted.setDisabled(w.isDisabled());
        converted.setYaw(w.getYaw());
        converted.setRotation(w.isRotation());
        converted.setTemporary(w.isTemporary());
        converted.setGlobal(w.isGlobal());
        return converted;
    }

    public void openWaypoint(GuiMap parent, Waypoint waypoint) {
        if (!waypoint.isEditable()) {
            return;
        }
        XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
        GuiAddWaypoint addScreen = this.compatibilityVersion >= 6 ? new GuiAddWaypoint(this.modMain, minimapSession.getWaypointsManager(), (Screen)parent, (Screen)parent, (xaero.common.minimap.waypoints.Waypoint)waypoint.getOriginal(), this.waypointWorld.getContainer().getRootContainer().getKey(), this.waypointWorld, waypoint.getSetName()) : new GuiAddWaypoint(this.modMain, minimapSession.getWaypointsManager(), (Screen)parent, (xaero.common.minimap.waypoints.Waypoint)waypoint.getOriginal(), this.waypointWorld.getContainer().getRootContainer().getKey(), this.waypointWorld);
        Minecraft.func_71410_x().func_147108_a((Screen)addScreen);
    }

    public void createWaypoint(GuiMap parent, int x, int y, int z) {
        GuiAddWaypoint addScreen;
        if (this.waypointWorld == null) {
            return;
        }
        XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
        WaypointsManager waypointsManager = minimapSession.getWaypointsManager();
        double dimDiv = this.compatibilityVersion < 2 ? (waypointsManager.divideBy8(this.waypointWorld.getContainer().getKey()) ? 8.0 : 1.0) : waypointsManager.getDimensionDivision(this.waypointWorld.getContainer().getKey());
        if (this.compatibilityVersion < 8) {
            xaero.common.minimap.waypoints.Waypoint w = this.compatibilityVersion >= 7 && y == -1 ? new xaero.common.minimap.waypoints.Waypoint(xaero.map.misc.Misc.myFloor((double)x * dimDiv), y, xaero.map.misc.Misc.myFloor((double)z * dimDiv), "", "", -1, 0, false, false) : new xaero.common.minimap.waypoints.Waypoint(xaero.map.misc.Misc.myFloor((double)x * dimDiv), y, xaero.map.misc.Misc.myFloor((double)z * dimDiv), "", "", -1);
            addScreen = this.compatibilityVersion >= 6 ? new GuiAddWaypoint(this.modMain, minimapSession.getWaypointsManager(), (Screen)parent, (Screen)parent, w, this.waypointWorld.getContainer().getRootContainer().getKey(), this.waypointWorld, this.waypointWorld.getCurrent()) : new GuiAddWaypoint(this.modMain, minimapSession.getWaypointsManager(), (Screen)parent, w, this.waypointWorld.getContainer().getRootContainer().getKey(), this.waypointWorld);
        } else {
            addScreen = new GuiAddWaypoint(this.modMain, minimapSession.getWaypointsManager(), (Screen)parent, (Screen)parent, null, this.waypointWorld.getContainer().getRootContainer().getKey(), this.waypointWorld, this.waypointWorld.getCurrent(), true, x, y, z);
        }
        Minecraft.func_71410_x().func_147108_a((Screen)addScreen);
    }

    public boolean canCreateWaypoint(int y) {
        return y != -1 || this.compatibilityVersion > 6;
    }

    public void createTempWaypoint(int x, int y, int z) {
        if (this.waypointWorld == null) {
            return;
        }
        XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
        WaypointsManager waypointsManager = minimapSession.getWaypointsManager();
        if (this.compatibilityVersion >= 7 && y == -1) {
            waypointsManager.createTemporaryWaypoints(this.waypointWorld, x, y, z, false);
        } else {
            waypointsManager.createTemporaryWaypoints(this.waypointWorld, x, y, z);
        }
        this.requestWaypointsRefresh();
    }

    public boolean canTeleport(WaypointWorld world) {
        XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
        WaypointsManager waypointsManager = minimapSession.getWaypointsManager();
        return world != null && waypointsManager.canTeleport(waypointsManager.isWorldTeleportable(world), world);
    }

    public void teleportToWaypoint(Screen screen, Waypoint w) {
        this.teleportToWaypoint(screen, w, this.waypointWorld);
    }

    public void teleportToWaypoint(Screen screen, Waypoint w, WaypointWorld world) {
        if (world == null) {
            return;
        }
        XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
        WaypointsManager waypointsManager = minimapSession.getWaypointsManager();
        waypointsManager.teleportToWaypoint((xaero.common.minimap.waypoints.Waypoint)w.getOriginal(), world, screen);
    }

    public void disableWaypoint(Waypoint waypoint) {
        ((xaero.common.minimap.waypoints.Waypoint)waypoint.getOriginal()).setDisabled(!((xaero.common.minimap.waypoints.Waypoint)waypoint.getOriginal()).isDisabled());
        try {
            this.modMain.getSettings().saveWaypoints(this.waypointWorld);
        }
        catch (IOException e) {
            WorldMap.LOGGER.error("suppressed exception", (Throwable)e);
        }
        waypoint.setDisabled(((xaero.common.minimap.waypoints.Waypoint)waypoint.getOriginal()).isDisabled());
        waypoint.setTemporary(((xaero.common.minimap.waypoints.Waypoint)waypoint.getOriginal()).isTemporary());
    }

    public void deleteWaypoint(Waypoint waypoint) {
        if (!this.allSets) {
            this.waypointSet.getList().remove((xaero.common.minimap.waypoints.Waypoint)waypoint.getOriginal());
        } else {
            WaypointSet set;
            HashMap sets = this.waypointWorld.getSets();
            Iterator iterator = sets.values().iterator();
            while (iterator.hasNext() && !(set = (WaypointSet)iterator.next()).getList().remove((xaero.common.minimap.waypoints.Waypoint)waypoint.getOriginal())) {
            }
        }
        try {
            this.modMain.getSettings().saveWaypoints(this.waypointWorld);
        }
        catch (IOException e) {
            WorldMap.LOGGER.error("suppressed exception", (Throwable)e);
        }
        this.waypoints.remove(waypoint);
        this.waypointsSorted.remove(waypoint);
        this.waypointMenuRenderer.updateFilteredList();
    }

    public void checkWaypoints(boolean multiplayer, RegistryKey<World> dimId, String multiworldId, int width, int height, GuiMap screen) {
        WaypointSet checkingSet;
        String containerId;
        XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
        WaypointsManager waypointsManager = minimapSession.getWaypointsManager();
        WaypointWorldContainer container = waypointsManager.getWorldContainerNullable(containerId = waypointsManager.getAutoRootContainerID() + "/" + waypointsManager.getDimensionDirectoryName(dimId));
        this.mapWaypointWorld = container == null ? null : (WaypointWorld)container.worlds.get(!multiplayer ? "waypoints" : multiworldId);
        WaypointWorld checkingWaypointWorld = WorldMap.settings.onlyCurrentMapWaypoints ? this.mapWaypointWorld : waypointsManager.getCurrentWorld();
        Minecraft mc = Minecraft.func_71410_x();
        if (this.compatibilityVersion >= 4 && mc.field_71439_g.func_70644_a(Effects.NO_WAYPOINTS)) {
            checkingWaypointWorld = null;
        } else if (this.compatibilityVersion >= 5 && (mc.field_71439_g.func_70644_a(Effects.NO_WAYPOINTS_BENEFICIAL) || mc.field_71439_g.func_70644_a(Effects.NO_WAYPOINTS_HARMFUL))) {
            checkingWaypointWorld = null;
        }
        boolean shouldRefresh = this.refreshWaypoints;
        if (checkingWaypointWorld != this.waypointWorld) {
            this.waypointWorld = checkingWaypointWorld;
            screen.closeRightClick();
            if (screen.waypointMenu) {
                screen.func_231158_b_(Minecraft.func_71410_x(), width, height);
            }
            shouldRefresh = true;
        }
        WaypointSet waypointSet = checkingSet = checkingWaypointWorld == null ? null : checkingWaypointWorld.getCurrentSet();
        if (checkingSet != this.waypointSet) {
            this.waypointSet = checkingSet;
            shouldRefresh = true;
        }
        if (this.allSets != this.modMain.getSettings().renderAllSets) {
            this.allSets = this.modMain.getSettings().renderAllSets;
            shouldRefresh = true;
        }
        if (shouldRefresh) {
            this.dimDiv = this.waypointWorld == null ? 1.0 : waypointsManager.getDimensionDivision(this.waypointWorld.getContainer().getKey());
            this.waypoints = this.convertWaypoints(this.dimDiv);
            if (this.waypoints != null) {
                Collections.sort(this.waypoints);
                this.waypointsSorted = new ArrayList();
                ArrayList<KeySortableByOther<Waypoint>> sortingList = new ArrayList<KeySortableByOther<Waypoint>>();
                for (Waypoint waypoint : this.waypoints) {
                    sortingList.add(new KeySortableByOther<Waypoint>(waypoint, new Comparable[]{waypoint.getComparisonName(), waypoint.getName()}));
                }
                Collections.sort(sortingList);
                for (KeySortableByOther keySortableByOther : sortingList) {
                    this.waypointsSorted.add((Waypoint)keySortableByOther.getKey());
                }
            } else {
                this.waypointsSorted = null;
            }
            this.waypointMenuRenderer.updateFilteredList();
        }
        this.refreshWaypoints = false;
    }

    public HoveredMapElementHolder<?, ?> renderWaypointsMenu(MatrixStack matrixStack, GuiMap gui, double scale, int width, int height, int mouseX, int mouseY, boolean leftMousePressed, boolean leftMouseClicked, HoveredMapElementHolder<?, ?> hovered, Minecraft mc) {
        return this.waypointMenuRenderer.renderMenu(matrixStack, gui, scale, width, height, mouseX, mouseY, leftMousePressed, leftMouseClicked, hovered, mc);
    }

    public void requestWaypointsRefresh() {
        this.refreshWaypoints = true;
    }

    public KeyBinding getWaypointKeyBinding() {
        return ModSettings.newWaypoint;
    }

    public KeyBinding getTempWaypointKeyBinding() {
        return ModSettings.keyInstantWaypoint;
    }

    public KeyBinding getTempWaypointsMenuKeyBinding() {
        return ModSettings.keyWaypoints;
    }

    public void onMapKeyPressed(InputMappings.Type type, int code, GuiMap screen) {
        KeyBinding minimapSettingsKB;
        KeyBinding kb = null;
        if (xaero.map.misc.Misc.inputMatchesKeyBinding(type, code, this.getToggleRadarKey(), (IKeyConflictContext)KeyConflictContext.GUI)) {
            screen.onRadarButton(screen.getRadarButton());
        }
        if (xaero.map.misc.Misc.inputMatchesKeyBinding(type, code, ModSettings.keyToggleMapWaypoints, (IKeyConflictContext)KeyConflictContext.GUI)) {
            this.getWaypointMenuRenderer().onRenderWaypointsButton(screen, screen.field_230708_k_, screen.field_230709_l_);
        }
        if (xaero.map.misc.Misc.inputMatchesKeyBinding(type, code, ModSettings.keyReverseEntityRadar, (IKeyConflictContext)KeyConflictContext.GUI)) {
            ModSettings.keyReverseEntityRadar.func_225593_a_(true);
        }
        if (xaero.map.misc.Misc.inputMatchesKeyBinding(type, code, ModSettings.keySwitchSet, (IKeyConflictContext)KeyConflictContext.GUI)) {
            kb = ModSettings.keySwitchSet;
        }
        if (xaero.map.misc.Misc.inputMatchesKeyBinding(type, code, ModSettings.keyAllSets, (IKeyConflictContext)KeyConflictContext.GUI)) {
            kb = ModSettings.keyAllSets;
        }
        if (xaero.map.misc.Misc.inputMatchesKeyBinding(type, code, ModSettings.keyWaypoints, (IKeyConflictContext)KeyConflictContext.GUI)) {
            kb = ModSettings.keyWaypoints;
        }
        if (xaero.map.misc.Misc.inputMatchesKeyBinding(type, code, minimapSettingsKB = (KeyBinding)this.modMain.getSettingsKey(), (IKeyConflictContext)KeyConflictContext.GUI)) {
            kb = minimapSettingsKB;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (kb != null) {
            if (kb == ModSettings.keyWaypoints) {
                this.openWaypointsMenu(mc, screen);
                return;
            }
            if (minimapSettingsKB != null && kb == minimapSettingsKB) {
                this.openSettings(mc, screen, screen);
                return;
            }
            this.handleMinimapKeyBinding(kb, screen);
        }
    }

    public boolean onMapKeyReleased(InputMappings.Type type, int code, GuiMap screen) {
        if (xaero.map.misc.Misc.inputMatchesKeyBinding(type, code, ModSettings.keyReverseEntityRadar, (IKeyConflictContext)KeyConflictContext.GUI)) {
            ModSettings.keyReverseEntityRadar.func_225593_a_(false);
            return true;
        }
        return false;
    }

    public void handleMinimapKeyBinding(KeyBinding kb, GuiMap screen) {
        XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
        minimapSession.getControls().keyDown(kb, false, false);
        if ((kb == ModSettings.keySwitchSet || kb == ModSettings.keyAllSets) && screen.waypointMenu) {
            screen.func_231158_b_(Minecraft.func_71410_x(), screen.field_230708_k_, screen.field_230709_l_);
        }
    }

    public void drawSetChange(MatrixStack matrixStack) {
        XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
        this.modMain.getInterfaces().getMinimapInterface().getWaypointsGuiRenderer().drawSetChange(minimapSession.getWaypointsManager(), matrixStack, Minecraft.func_71410_x().func_228018_at_());
    }

    public float getMinimapBrightnessOldCompatibility() {
        return this.modMain.getSupportMods().worldmapSupport.getMinimapBrightness();
    }

    public void openSettings(Minecraft mc, Screen current, Screen escape) {
        if (this.compatibilityVersion >= 6) {
            this.modMain.getGuiHelper().openMinimapSettingsFromScreen(current, escape);
        } else {
            XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
            minimapSession.getControls().keyDown((KeyBinding)this.modMain.getSettingsKey(), false, false);
        }
    }

    public String getControlsTooltip() {
        return I18n.func_135052_a((String)"gui.xaero_box_controls_minimap", (Object[])new Object[]{xaero.map.misc.Misc.getKeyName(ModSettings.newWaypoint), xaero.map.misc.Misc.getKeyName(ModSettings.keyInstantWaypoint), xaero.map.misc.Misc.getKeyName(ModSettings.keySwitchSet), xaero.map.misc.Misc.getKeyName(ModSettings.keyAllSets), xaero.map.misc.Misc.getKeyName(ModSettings.keyWaypoints)});
    }

    public void onMapMouseRelease(double par1, double par2, int par3) {
        this.waypointMenuRenderer.onMapMouseRelease(par1, par2, par3);
    }

    public void onMapConstruct() {
        this.waypointMenuRenderer = new WaypointMenuRenderer(new WaypointMenuRenderContext(), new WaypointMenuRenderProvider(this), this.waypointRenderer);
    }

    public void onMapInit(GuiMap mapScreen, List<GuiDropDown> dropdowns, Minecraft mc, int width, int height) {
        this.waypointMenuRenderer.onMapInit(mapScreen, dropdowns, mc, width, height, this.waypointWorld, this.modMain, XaeroMinimapSession.getCurrentSession());
    }

    public ArrayList<Waypoint> getWaypointsSorted() {
        return this.waypointsSorted;
    }

    public boolean waypointExists(Waypoint w) {
        return this.waypoints != null && this.waypoints.contains(w);
    }

    public void toggleTemporaryWaypoint(Waypoint waypoint) {
        ((xaero.common.minimap.waypoints.Waypoint)waypoint.getOriginal()).setTemporary(!((xaero.common.minimap.waypoints.Waypoint)waypoint.getOriginal()).isTemporary());
        try {
            this.modMain.getSettings().saveWaypoints(this.waypointWorld);
        }
        catch (IOException e) {
            WorldMap.LOGGER.error("suppressed exception", (Throwable)e);
        }
        waypoint.setDisabled(((xaero.common.minimap.waypoints.Waypoint)waypoint.getOriginal()).isDisabled());
        waypoint.setTemporary(((xaero.common.minimap.waypoints.Waypoint)waypoint.getOriginal()).isTemporary());
    }

    public void openWaypointsMenu(Minecraft mc, GuiMap screen) {
        XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
        if (this.compatibilityVersion >= 6) {
            mc.func_147108_a((Screen)new GuiWaypoints(this.modMain, minimapSession, (Screen)screen, (Screen)screen));
        } else {
            mc.func_147108_a((Screen)new GuiWaypoints(this.modMain, minimapSession, (Screen)screen));
        }
    }

    public boolean screenShouldSkipWorldRender(Screen currentScreen) {
        if (this.compatibilityVersion < 6) {
            return false;
        }
        return Misc.screenShouldSkipWorldRender((IXaeroMinimap)this.modMain, (Screen)currentScreen, (boolean)false);
    }

    public boolean hidingWaypointCoordinates() {
        return this.modMain.getSettings().hideWaypointCoordinates;
    }

    public void shareWaypoint(Waypoint waypoint, GuiMap screen, WaypointWorld world) {
        XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
        minimapSession.getWaypointSharing().shareWaypoint((Screen)screen, (xaero.common.minimap.waypoints.Waypoint)waypoint.getOriginal(), world);
    }

    public void shareLocation(GuiMap guiMap, int rightClickX, int rightClickY, int rightClickZ) {
        int wpColor = (int)((double)ModSettings.COLORS.length * Math.random());
        xaero.common.minimap.waypoints.Waypoint minimapLocationWaypoint = this.compatibilityVersion < 7 ? new xaero.common.minimap.waypoints.Waypoint(rightClickX, rightClickY, rightClickZ, "Shared Location", "S", wpColor) : new xaero.common.minimap.waypoints.Waypoint(rightClickX, rightClickY == -1 ? 0 : rightClickY, rightClickZ, "Shared Location", "S", wpColor, 0, false, rightClickY != -1);
        Waypoint locationWaypoint = this.convertWaypoint(minimapLocationWaypoint, false, "", 1.0);
        this.shareWaypoint(locationWaypoint, guiMap, this.mapWaypointWorld);
    }

    public WaypointWorld getMapWaypointWorld() {
        return this.mapWaypointWorld;
    }

    public WaypointWorld getWaypointWorld() {
        return this.waypointWorld;
    }

    public double getDimDiv() {
        return this.dimDiv;
    }

    public int getArrowColorIndex() {
        return this.modMain.getSettings().arrowColour;
    }

    public float[] getArrowColor() {
        if (this.modMain.getSettings().arrowColour < 0 || this.modMain.getSettings().arrowColour >= this.modMain.getSettings().arrowColours.length) {
            return null;
        }
        return this.modMain.getSettings().arrowColours[this.modMain.getSettings().arrowColour];
    }

    public String getSubWorldNameToRender() {
        if (WorldMap.settings.onlyCurrentMapWaypoints || this.waypointWorld == null) {
            return null;
        }
        XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
        WaypointsManager waypointsManager = minimapSession.getWaypointsManager();
        if (this.waypointWorld != waypointsManager.getAutoWorld()) {
            return I18n.func_135052_a((String)"gui.xaero_wm_using_custom_subworld", (Object[])new Object[]{this.waypointWorld.getContainer().getSubName()});
        }
        return null;
    }

    public void registerMinimapHighlighters(Object highlighterRegistry) {
    }

    public ArrayList<Waypoint> getWaypoints() {
        return this.waypoints;
    }

    public boolean getDeathpoints() {
        return this.deathpoints;
    }

    public WaypointRenderer getWaypointRenderer() {
        return this.waypointRenderer;
    }

    public WaypointMenuRenderer getWaypointMenuRenderer() {
        return this.waypointMenuRenderer;
    }

    public void onClearHighlightHash(int regionX, int regionZ) {
        DimensionHighlighterHandler highlightHandler;
        XaeroMinimapSession minimapSession;
        if (this.compatibilityVersion >= 11 && (minimapSession = XaeroMinimapSession.getCurrentSession()) != null && (highlightHandler = minimapSession.getMinimapProcessor().getMinimapWriter().getDimensionHighlightHandler()) != null) {
            highlightHandler.requestRefresh(regionX, regionZ);
        }
    }

    public void createRadarRendererWrapper(Object radarRenderer) {
        new RadarRendererWrapperHelper().createWrapper(this.modMain, (RadarRenderer)radarRenderer);
    }

    public KeyBinding getToggleRadarKey() {
        if (this.compatibilityVersion < 10) {
            return null;
        }
        return ModSettings.keyToggleRadar;
    }

    public void onClearHighlightHashes() {
        DimensionHighlighterHandler highlightHandler;
        XaeroMinimapSession minimapSession;
        if (this.compatibilityVersion >= 13 && (minimapSession = XaeroMinimapSession.getCurrentSession()) != null && (highlightHandler = minimapSession.getMinimapProcessor().getMinimapWriter().getDimensionHighlightHandler()) != null) {
            highlightHandler.requestRefresh();
        }
    }

    public void onSessionFinalized() {
        this.waypointWorld = null;
        this.mapWaypointWorld = null;
    }

    public void openWaypointWorldTeleportCommandScreen(Screen parent, Screen escape) {
        String containerId;
        XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
        if (minimapSession == null) {
            return;
        }
        WaypointsManager waypointsManager = minimapSession.getWaypointsManager();
        WaypointWorldRootContainer container = waypointsManager.getWorldContainerNullable(containerId = waypointsManager.getAutoRootContainerID()).getRootContainer();
        if (container != null) {
            if (this.compatibilityVersion >= 15) {
                Minecraft.func_71410_x().func_147108_a((Screen)new GuiWorldTpCommand(this.modMain, parent, escape, container));
            } else {
                WaypointWorld firstWorld = container.getFirstWorld();
                if (firstWorld != null) {
                    Minecraft.func_71410_x().func_147108_a((Screen)new GuiWorldTpCommand(this.modMain, parent, escape, firstWorld));
                }
            }
        }
    }
}

