/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import xaero.map.WorldMap;
import xaero.map.controls.ControlsRegister;
import xaero.map.gui.CursorBox;
import xaero.map.gui.GuiMap;
import xaero.map.gui.GuiSettings;
import xaero.map.gui.GuiTexturedButton;
import xaero.map.gui.MyTinyButton;
import xaero.map.misc.Misc;
import xaero.map.mods.SupportMods;
import xaero.map.settings.ModOptions;

public class GuiWorldMapSettings
extends GuiSettings {
    private static final int PAGES = 3;
    public Button minimapButton;
    public Button prevButton;
    public Button nextButton;
    private int page;

    public GuiWorldMapSettings() {
        this(null);
    }

    public GuiWorldMapSettings(Screen parent) {
        this(parent, null);
    }

    public GuiWorldMapSettings(Screen parent, Screen escapeScreen) {
        super(parent, escapeScreen, WorldMap.settings, (ITextComponent)new TranslationTextComponent("gui.xaero_world_map_settings"));
    }

    @Override
    public void func_231160_c_() {
        if (this.page == 0) {
            this.options = new ModOptions[]{ModOptions.LIGHTING, ModOptions.COLOURS, ModOptions.LOAD, ModOptions.UPDATE, ModOptions.DEPTH, ModOptions.SLOPES, ModOptions.STEPS, ModOptions.COORDINATES, ModOptions.WAYPOINTS, ModOptions.WAYPOINT_BACKGROUNDS, ModOptions.WAYPOINT_SCALE};
            this.minimapButton = new Button(this.field_230708_k_ / 2 + 5, this.field_230709_l_ / 7 + 120, 200, 20, (ITextComponent)new StringTextComponent("Minimap Settings"), b -> SupportMods.xaeroMinimap.openSettings(this.field_230706_i_, this, this.escape));
            this.func_230480_a_((Widget)this.minimapButton);
            this.minimapButton.field_230693_o_ = SupportMods.minimap();
        } else {
            this.options = this.page == 1 ? new ModOptions[]{ModOptions.MIN_ZOOM_LOCAL_WAYPOINTS, ModOptions.BIOMES, ModOptions.ADJUST_HEIGHT_FOR_SHORT_BLOCKS, ModOptions.FLOWERS, ModOptions.ARROW, ModOptions.IGNORE_HEIGHTMAPS, ModOptions.ARROW_COLOUR, ModOptions.OPEN_ANIMATION, ModOptions.DISPLAY_ZOOM, ModOptions.ZOOM_BUTTONS, ModOptions.DETECT_AMBIGUOUS_Y, ModOptions.MAP_TELEPORT_COMMAND} : new ModOptions[]{ModOptions.MAP_TELEPORT_ALLOWED, ModOptions.UPDATE_NOTIFICATION, ModOptions.RELOAD, ModOptions.DEBUG};
        }
        this.nextButton = new MyTinyButton(this.field_230708_k_ / 2 + 130, this.field_230709_l_ / 7 + 144, (ITextComponent)new TranslationTextComponent("gui.xaero_wm_next", new Object[0]), b -> this.onNextButton());
        this.func_230480_a_((Widget)this.nextButton);
        this.nextButton.field_230693_o_ = this.isNextButtonEnabled();
        this.prevButton = new MyTinyButton(this.field_230708_k_ / 2 - 205, this.field_230709_l_ / 7 + 144, (ITextComponent)new TranslationTextComponent("gui.xaero_wm_previous", new Object[0]), b -> this.onPrevButton());
        this.func_230480_a_((Widget)this.prevButton);
        this.prevButton.field_230693_o_ = this.isPrevButtonEnabled();
        super.func_231160_c_();
        if (this.parent instanceof GuiMap) {
            this.func_230480_a_((Widget)new GuiTexturedButton(0, 0, 30, 30, 113, 0, 20, 20, WorldMap.guiTextures, this::onSettingsButton, new CursorBox(I18n.func_135052_a((String)"gui.xaero_box_close_settings", (Object[])new Object[]{Misc.getKeyName(ControlsRegister.keyOpenSettings)}))));
        }
    }

    private void onSettingsButton(Widget button) {
        this.goBack();
    }

    private void onPrevButton() {
        --this.page;
        if (this.page < 0) {
            this.page = 0;
        }
        this.func_231158_b_(this.field_230706_i_, this.field_230708_k_, this.field_230709_l_);
    }

    private void onNextButton() {
        ++this.page;
        if (this.page >= 3) {
            this.page = 2;
        }
        this.func_231158_b_(this.field_230706_i_, this.field_230708_k_, this.field_230709_l_);
    }

    private boolean isPrevButtonEnabled() {
        return this.page > 0;
    }

    private boolean isNextButtonEnabled() {
        return this.page < 2;
    }

    @Override
    public void func_230430_a_(MatrixStack matrixStack, int par1, int par2, float par3) {
        this.renderEscapeScreen(matrixStack, par1, par2, par3);
        super.func_230430_a_(matrixStack, par1, par2, par3);
        for (int k = 0; k < this.field_230710_m_.size(); ++k) {
            Widget b = (Widget)this.field_230710_m_.get(k);
            if (par1 >= b.field_230690_l_ && par2 >= b.field_230691_m_ && par1 < b.field_230690_l_ + 150 && par2 >= b.field_230691_m_ + 20) continue;
        }
    }
}

