/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.gui;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.client.AbstractOption;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.settings.IteratableOption;
import net.minecraft.client.settings.SliderPercentageOption;
import net.minecraft.client.util.InputMappings;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import xaero.map.WorldMap;
import xaero.map.controls.ControlsRegister;
import xaero.map.gui.ICanTooltip;
import xaero.map.gui.ModOptionButton;
import xaero.map.gui.ModOptionSlider;
import xaero.map.gui.ScreenBase;
import xaero.map.gui.TooltipButton;
import xaero.map.misc.Misc;
import xaero.map.settings.ModOptions;
import xaero.map.settings.ModSettings;

public class GuiSettings
extends ScreenBase {
    public static final Set<ModOptions> FILE_ONLY_ENABLE = new HashSet<ModOptions>(Lists.newArrayList((Object[])new ModOptions[]{ModOptions.MAP_TELEPORT_ALLOWED}));
    protected ModSettings guiModSettings;
    protected ModOptions[] options;

    public GuiSettings(Screen par1GuiScreen, Screen escapeScreen, ModSettings par2ModSettings, ITextComponent title) {
        super(par1GuiScreen, escapeScreen, title);
        this.guiModSettings = par2ModSettings;
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 - 100, this.field_230709_l_ / 6 + 168, 200, 20, (ITextComponent)new TranslationTextComponent("gui.xaero_back", new Object[0]), b -> this.goBack()));
        int var8 = 0;
        if (this.options == null) {
            return;
        }
        for (ModOptions option : this.options) {
            AbstractOption mcOption = option.getMcOption();
            ICanTooltip optionWidget = null;
            if (mcOption instanceof SliderPercentageOption) {
                optionWidget = new ModOptionSlider(option, this.field_230706_i_.field_71474_y, this.field_230708_k_ / 2 - 205 + var8 % 2 * 210, this.field_230709_l_ / 7 + 24 * (var8 >> 1), 200, 20, (SliderPercentageOption)mcOption);
            } else if (mcOption instanceof IteratableOption) {
                IteratableOption iterOption = (IteratableOption)mcOption;
                optionWidget = new ModOptionButton(option, this.field_230708_k_ / 2 - 205 + var8 % 2 * 210, this.field_230709_l_ / 7 + 24 * (var8 >> 1), 200, 20, mcOption, iterOption.func_238157_c_(this.field_230706_i_.field_71474_y), p_216721_2_ -> {
                    iterOption.func_216722_a(this.field_230706_i_.field_71474_y, 1);
                    p_216721_2_.func_238482_a_(iterOption.func_238157_c_(this.field_230706_i_.field_71474_y));
                });
            } else {
                optionWidget = new TooltipButton(this.field_230708_k_ / 2 - 205 + var8 % 2 * 210, this.field_230709_l_ / 7 + 24 * (var8 >> 1), 200, 20, (ITextComponent)new StringTextComponent(option.getEnumString()), b -> WorldMap.settings.setOptionValue(option), option.getTooltip());
            }
            if (optionWidget != null) {
                boolean bl = ((Widget)optionWidget).field_230693_o_ = !option.isDisabledBecauseNotIngame() && !option.isDisabledBecauseMinimap();
                if (((Widget)optionWidget).field_230693_o_ && FILE_ONLY_ENABLE.contains(option) && !WorldMap.settings.getClientBooleanValue(option)) {
                    ((Widget)optionWidget).field_230693_o_ = false;
                }
                this.func_230480_a_((Widget)optionWidget);
            }
            ++var8;
        }
    }

    public void func_230430_a_(MatrixStack matrixStack, int par1, int par2, float par3) {
        this.func_230446_a_(matrixStack);
        GuiSettings.func_238472_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (ITextComponent)this.field_230704_d_, (int)(this.field_230708_k_ / 2), (int)20, (int)0xFFFFFF);
        super.func_230430_a_(matrixStack, par1, par2, par3);
        this.renderTooltips(matrixStack, par1, par2, par3);
    }

    public boolean func_231046_a_(int par1, int par2, int par3) {
        if (!super.func_231046_a_(par1, par2, par3)) {
            if (Misc.inputMatchesKeyBinding(par1 != -1 ? InputMappings.Type.KEYSYM : InputMappings.Type.SCANCODE, par1 != -1 ? par1 : par2, ControlsRegister.keyOpenSettings, (IKeyConflictContext)KeyConflictContext.GUI)) {
                this.func_231175_as__();
                return true;
            }
            return false;
        }
        return true;
    }

    public boolean func_231044_a_(double p_231044_1_, double p_231044_3_, int p_231044_5_) {
        if (!super.func_231044_a_(p_231044_1_, p_231044_3_, p_231044_5_)) {
            if (Misc.inputMatchesKeyBinding(InputMappings.Type.MOUSE, p_231044_5_, ControlsRegister.keyOpenSettings, (IKeyConflictContext)KeyConflictContext.GUI)) {
                this.func_231175_as__();
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    protected void onExit(Screen screen) {
        try {
            this.guiModSettings.saveSettings();
        }
        catch (IOException e) {
            WorldMap.LOGGER.error("suppressed exception", (Throwable)e);
        }
        super.onExit(screen);
    }
}

