/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.ConfirmScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import xaero.map.MapProcessor;
import xaero.map.WorldMap;
import xaero.map.gui.CursorBox;
import xaero.map.gui.GuiDropDown;
import xaero.map.gui.GuiMap;
import xaero.map.gui.GuiMapName;
import xaero.map.gui.GuiMapSwitchingButton;
import xaero.map.gui.TooltipButton;
import xaero.map.misc.KeySortableByOther;
import xaero.map.world.MapDimension;
import xaero.map.world.MapWorld;

public class GuiMapSwitching {
    private MapProcessor mapProcessor;
    private MapDimension settingsDimension;
    private String[] mwDropdownValues;
    private GuiDropDown createdDropdown;
    private Button switchingButton;
    private Button multiworldTypeOptionButton;
    private Button renameButton;
    private Button deleteButton;
    private Button confirmButton;
    private CursorBox serverSelectionModeBox = new CursorBox("gui.xaero_mw_server_box");
    private CursorBox mapSelectionBox = new CursorBox("gui.xaero_map_selection_box");
    public boolean active;
    private boolean writableOnInit;
    private boolean uiPausedOnUpdate;
    private boolean mapSwitchingAllowed;

    public GuiMapSwitching(MapProcessor mapProcessor) {
        this.mapProcessor = mapProcessor;
        this.mapSelectionBox.setStartWidth(200);
        this.serverSelectionModeBox.setStartWidth(200);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(GuiMap mapScreen, List<GuiDropDown> dropdowns, Minecraft field_230706_i_, int field_230708_k_, int field_230709_l_) {
        this.createdDropdown = null;
        this.switchingButton = null;
        this.multiworldTypeOptionButton = null;
        this.renameButton = null;
        this.deleteButton = null;
        this.confirmButton = null;
        MapWorld mapWorld = this.mapProcessor.getMapWorld();
        this.settingsDimension = mapWorld == null || mapWorld.getCurrentDimensionId() == null ? null : mapWorld.getCurrentDimension();
        this.mapSwitchingAllowed = this.settingsDimension != null && mapWorld.isMultiplayer();
        Object object = this.mapProcessor.uiPauseSync;
        synchronized (object) {
            this.uiPausedOnUpdate = this.isUIPaused();
            if (this.mapSwitchingAllowed) {
                this.writableOnInit = this.settingsDimension.futureMultiworldWritable;
                this.switchingButton = new GuiMapSwitchingButton(this.active, 0, field_230709_l_ - 20, b -> {
                    Object object = this.mapProcessor.uiPauseSync;
                    synchronized (object) {
                        if (!this.canToggleThisScreen()) {
                            return;
                        }
                        this.active = !this.active;
                        mapScreen.func_231158_b_(field_230706_i_, field_230708_k_, field_230709_l_);
                    }
                });
                mapScreen.addButton(this.switchingButton);
                if (this.active) {
                    this.createdDropdown = this.createDropdown(this.uiPausedOnUpdate, field_230708_k_, mapScreen, dropdowns, field_230706_i_);
                    dropdowns.add(this.createdDropdown);
                    this.multiworldTypeOptionButton = new TooltipButton(0, field_230709_l_ - 45, 150, 20, (ITextComponent)new StringTextComponent(this.getMultiworldTypeButtonMessage()), b -> {
                        Object object = this.mapProcessor.uiPauseSync;
                        synchronized (object) {
                            if (this.isMapSelectionOptionEnabled()) {
                                this.mapProcessor.toggleMultiworldType(this.settingsDimension);
                                b.func_238482_a_((ITextComponent)new StringTextComponent(this.getMultiworldTypeButtonMessage()));
                            }
                        }
                    }, this.settingsDimension.isFutureMultiworldServerBased() ? this.serverSelectionModeBox : this.mapSelectionBox);
                    mapScreen.addButton(this.multiworldTypeOptionButton);
                    this.renameButton = new Button(field_230708_k_ / 2 + 109, 26, 60, 20, (ITextComponent)new TranslationTextComponent("gui.xaero_rename"), b -> {
                        Object object = this.mapProcessor.uiPauseSync;
                        synchronized (object) {
                            if (!this.canRenameMap()) {
                                return;
                            }
                            field_230706_i_.func_147108_a((Screen)new GuiMapName(this.mapProcessor, mapScreen, mapScreen, this.settingsDimension, this.settingsDimension.getFutureMultiworldUnsynced()));
                        }
                    });
                    mapScreen.addButton(this.renameButton);
                    this.deleteButton = new Button(field_230708_k_ / 2 - 168, 26, 60, 20, (ITextComponent)new TranslationTextComponent("gui.xaero_delete"), b -> {
                        Object object = this.mapProcessor.uiPauseSync;
                        synchronized (object) {
                            if (!this.canDeleteMap()) {
                                return;
                            }
                            String selectedMWId = this.settingsDimension.getFutureCustomSelectedMultiworld();
                            field_230706_i_.func_147108_a((Screen)new ConfirmScreen(result -> {
                                if (result) {
                                    String mapNameAndIdLine = I18n.func_135052_a((String)"gui.xaero_delete_map_msg4", (Object[])new Object[0]) + ": " + this.settingsDimension.getMultiworldName(selectedMWId) + " (" + selectedMWId + ")";
                                    field_230706_i_.func_147108_a((Screen)new ConfirmScreen(result2 -> {
                                        if (result2) {
                                            Object object = this.mapProcessor.uiSync;
                                            synchronized (object) {
                                                if (this.mapProcessor.getMapWorld() == this.settingsDimension.getMapWorld()) {
                                                    MapDimension currentDimension;
                                                    MapDimension mapDimension = currentDimension = !this.mapProcessor.isMapWorldUsable() ? null : this.mapProcessor.getMapWorld().getCurrentDimension();
                                                    if (this.settingsDimension == currentDimension && this.settingsDimension.getCurrentMultiworld().equals(selectedMWId)) {
                                                        if (WorldMap.settings.debug) {
                                                            WorldMap.LOGGER.info("Delayed map deletion!");
                                                        }
                                                        this.mapProcessor.requestCurrentMapDeletion();
                                                    } else {
                                                        if (WorldMap.settings.debug) {
                                                            WorldMap.LOGGER.info("Instant map deletion!");
                                                        }
                                                        this.settingsDimension.deleteMultiworldMapDataUnsynced(selectedMWId);
                                                    }
                                                    this.settingsDimension.deleteMultiworldId(selectedMWId);
                                                    this.settingsDimension.pickDefaultCustomMultiworldUnsynced();
                                                    this.settingsDimension.saveConfigUnsynced();
                                                    this.settingsDimension.futureMultiworldWritable = false;
                                                    mapScreen.func_231158_b_(field_230706_i_, field_230708_k_, field_230709_l_);
                                                }
                                            }
                                        }
                                        field_230706_i_.func_147108_a((Screen)mapScreen);
                                    }, (ITextComponent)new TranslationTextComponent("gui.xaero_delete_map_msg3"), (ITextComponent)new StringTextComponent(mapNameAndIdLine)));
                                } else {
                                    field_230706_i_.func_147108_a((Screen)mapScreen);
                                }
                            }, (ITextComponent)new TranslationTextComponent("gui.xaero_delete_map_msg1"), (ITextComponent)new TranslationTextComponent("gui.xaero_delete_map_msg2")));
                        }
                    });
                    mapScreen.addButton(this.deleteButton);
                    this.confirmButton = new Button(field_230708_k_ / 2 - 50, 50, 100, 20, (ITextComponent)new TranslationTextComponent("gui.xaero_confirm"), b -> {
                        Object object = this.mapProcessor.uiPauseSync;
                        synchronized (object) {
                            if (!this.canConfirm()) {
                                return;
                            }
                            this.confirm(mapScreen, field_230706_i_, field_230708_k_, field_230709_l_);
                        }
                    });
                    mapScreen.addButton(this.confirmButton);
                    this.updateButtons(dropdowns, mapScreen, field_230708_k_, field_230706_i_);
                } else {
                    this.switchingButton.field_230693_o_ = this.canToggleThisScreen();
                }
            }
        }
    }

    private GuiDropDown createDropdown(boolean paused, int width, GuiMap mapScreen, List<GuiDropDown> dropdowns, Minecraft minecraft) {
        List<String> mwDropdownNames;
        int selected = 0;
        if (!paused) {
            String currentMultiworld = this.settingsDimension.getFutureMultiworldUnsynced();
            ArrayList<KeySortableByOther<String>> sortableList = new ArrayList<KeySortableByOther<String>>();
            for (String mwId : this.settingsDimension.getMultiworldIdsCopy()) {
                sortableList.add(new KeySortableByOther<String>(mwId, new Comparable[]{this.settingsDimension.getMultiworldName(mwId).toLowerCase()}));
            }
            Collections.sort(sortableList);
            ArrayList<String> dropdownValuesList = new ArrayList<String>();
            for (KeySortableByOther keySortableByOther : sortableList) {
                dropdownValuesList.add((String)keySortableByOther.getKey());
            }
            selected = this.getDropdownSelectionIdFromValue(dropdownValuesList, currentMultiworld);
            if (selected == dropdownValuesList.size()) {
                dropdownValuesList.add(currentMultiworld);
            }
            this.mwDropdownValues = dropdownValuesList.toArray(new String[0]);
            mwDropdownNames = dropdownValuesList.stream().map(s -> this.settingsDimension.getMultiworldName((String)s)).collect(ArrayList::new, ArrayList::add, ArrayList::addAll);
            if (this.settingsDimension.getMapWorld().isMultiplayer()) {
                mwDropdownNames.add("\u00a78" + I18n.func_135052_a((String)"gui.xaero_create_new_map", (Object[])new Object[0]));
            }
        } else {
            mwDropdownNames = new ArrayList<String>();
            this.mwDropdownValues = null;
            mwDropdownNames.add("\u00a77" + I18n.func_135052_a((String)"gui.xaero_map_menu_please_wait", (Object[])new Object[0]));
        }
        GuiDropDown result = new GuiDropDown(mwDropdownNames.toArray(new String[0]), width / 2 - 100, 30, 200, selected, (dd, i) -> {
            Object object = this.mapProcessor.uiPauseSync;
            synchronized (object) {
                if (this.isUIPaused() || this.uiPausedOnUpdate) {
                    return false;
                }
                if (i < this.mwDropdownValues.length) {
                    this.mapProcessor.setMultiworld(this.settingsDimension, this.mwDropdownValues[i]);
                    this.updateButtons(dropdowns, mapScreen, width, minecraft);
                    return true;
                }
                minecraft.func_147108_a((Screen)new GuiMapName(this.mapProcessor, mapScreen, mapScreen, this.settingsDimension, null));
                return false;
            }
        }, true);
        result.setActive(!paused);
        return result;
    }

    private boolean isUIPaused() {
        return this.mapProcessor.isUIPaused() || this.mapProcessor.isWaitingForWorldUpdate();
    }

    private boolean isMapSelectionOptionEnabled() {
        return !this.isUIPaused() && !this.settingsDimension.isFutureMultiworldServerBased() && this.settingsDimension.getMapWorld().isMultiplayer();
    }

    private boolean canToggleThisScreen() {
        return !this.isUIPaused() && this.settingsDimension != null && this.settingsDimension.futureMultiworldWritable;
    }

    private boolean canDeleteMap() {
        return !this.isUIPaused() && this.settingsDimension.getMapWorld().isMultiplayer() && this.mwDropdownValues != null && this.mwDropdownValues.length > 1 && this.settingsDimension.getFutureCustomSelectedMultiworld() != null;
    }

    private boolean canRenameMap() {
        return !this.isUIPaused() && this.settingsDimension.getMapWorld().isMultiplayer();
    }

    private boolean canConfirm() {
        return !this.isUIPaused();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateButtons(List<GuiDropDown> dropdowns, GuiMap mapScreen, int width, Minecraft minecraft) {
        Object object = this.mapProcessor.uiPauseSync;
        synchronized (object) {
            boolean isPaused = this.isUIPaused();
            if (this.uiPausedOnUpdate != isPaused) {
                if (this.createdDropdown != null) {
                    dropdowns.remove((Object)this.createdDropdown);
                }
                GuiDropDown guiDropDown = this.createdDropdown = !this.active ? null : this.createDropdown(isPaused, width, mapScreen, dropdowns, minecraft);
                if (this.createdDropdown != null) {
                    dropdowns.add(this.createdDropdown);
                }
                this.uiPausedOnUpdate = isPaused;
            }
            this.switchingButton.field_230693_o_ = this.canToggleThisScreen();
            if (this.deleteButton != null) {
                this.deleteButton.field_230693_o_ = this.canDeleteMap();
            }
            if (this.renameButton != null) {
                this.renameButton.field_230693_o_ = this.canRenameMap();
            }
            if (this.multiworldTypeOptionButton != null) {
                this.multiworldTypeOptionButton.field_230693_o_ = this.isMapSelectionOptionEnabled();
            }
            if (this.confirmButton != null) {
                this.confirmButton.field_230693_o_ = this.canConfirm();
            }
        }
    }

    private String getMultiworldTypeButtonMessage() {
        int multiworldType = this.settingsDimension.getMapWorld().getFutureMultiworldType(this.settingsDimension);
        return I18n.func_135052_a((String)"gui.xaero_map_selection", (Object[])new Object[0]) + ": " + I18n.func_135052_a((String)(this.settingsDimension.isFutureMultiworldServerBased() ? "gui.xaero_mw_server" : (multiworldType == 0 ? "gui.xaero_mw_single" : (multiworldType == 1 ? "gui.xaero_mw_manual" : "gui.xaero_mw_spawn"))), (Object[])new Object[0]);
    }

    public void confirm(GuiMap mapScreen, Minecraft minecraft, int width, int height) {
        if (this.mapProcessor.confirmMultiworld(this.settingsDimension)) {
            this.active = false;
            mapScreen.func_231158_b_(minecraft, width, height);
        }
    }

    private int getDropdownSelectionIdFromValue(List<String> values, String value) {
        int selected = 0;
        for (selected = 0; selected < values.size() && !values.get(selected).equals(value); ++selected) {
        }
        return selected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preMapRender(GuiMap mapScreen, List<GuiDropDown> dropdowns, Minecraft minecraft, int width, int height) {
        String currentDropdownSelection;
        String currentMultiworld;
        MapDimension currentDim;
        MapDimension mapDimension = currentDim = !this.mapProcessor.isMapWorldUsable() ? null : this.mapProcessor.getMapWorld().getCurrentDimension();
        if (currentDim != this.settingsDimension) {
            this.active = false;
            mapScreen.func_231158_b_(minecraft, width, height);
        }
        if (!this.active && this.settingsDimension != null && !this.settingsDimension.futureMultiworldWritable) {
            this.active = true;
            mapScreen.func_231158_b_(minecraft, width, height);
        }
        if (this.mapSwitchingAllowed && (this.createdDropdown == null || this.createdDropdown.isClosed())) {
            Object object = this.mapProcessor.uiPauseSync;
            synchronized (object) {
                if (this.uiPausedOnUpdate != this.isUIPaused()) {
                    this.updateButtons(dropdowns, mapScreen, width, minecraft);
                }
            }
        }
        if (this.active && this.settingsDimension != null && dropdowns.get(0).isClosed() && !this.uiPausedOnUpdate && (!(currentMultiworld = this.settingsDimension.getFutureMultiworldUnsynced()).equals(currentDropdownSelection = this.mwDropdownValues[dropdowns.get(0).getSelected()]) || this.writableOnInit != this.settingsDimension.futureMultiworldWritable)) {
            mapScreen.func_231158_b_(minecraft, width, height);
        }
    }

    public void renderText(MatrixStack matrixStack, Minecraft minecraft, int mouseX, int mouseY, int width, int height) {
        if (!this.active) {
            return;
        }
        String selectMapString = I18n.func_135052_a((String)"gui.xaero_select_map", (Object[])new Object[0]) + ":";
        minecraft.field_71466_p.func_238405_a_(matrixStack, selectMapString, (float)(width / 2 - minecraft.field_71466_p.func_78256_a(selectMapString) / 2), 19.0f, -1);
    }

    public void postMapRender(MatrixStack matrixStack, Minecraft minecraft, int mouseX, int mouseY, int width, int height) {
    }
}

