/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.events;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.realmsclient.dto.RealmsServer;
import com.mojang.realmsclient.gui.screens.RealmsLongRunningMcoTaskScreen;
import java.lang.reflect.Field;
import java.util.Queue;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.screen.MainMenuScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.realms.action.ConnectingToRealmsAction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import xaero.map.MapProcessor;
import xaero.map.WorldMap;
import xaero.map.WorldMapSession;
import xaero.map.capabilities.ServerWorldCapabilities;
import xaero.map.file.worldsave.WorldDataHandler;
import xaero.map.misc.Misc;
import xaero.map.mods.SupportMods;
import xaero.map.patreon.GuiUpdateAll;
import xaero.map.patreon.Patreon;

public class Events {
    private RealmsServer latestRealm;
    private Field realmsTaskField;
    private Field realmsTaskServerField;

    @SubscribeEvent
    public void guiOpen(GuiOpenEvent event) {
        if (event.getGui() instanceof RealmsLongRunningMcoTaskScreen) {
            try {
                ConnectingToRealmsAction realmsTask;
                RealmsServer realm;
                RealmsLongRunningMcoTaskScreen realmsTaskScreen;
                Object task;
                if (this.realmsTaskField == null) {
                    try {
                        this.realmsTaskField = RealmsLongRunningMcoTaskScreen.class.getDeclaredField("field_224248_l");
                    }
                    catch (NoSuchFieldException nsfe) {
                        this.realmsTaskField = RealmsLongRunningMcoTaskScreen.class.getDeclaredField("task");
                    }
                    this.realmsTaskField.setAccessible(true);
                }
                if (this.realmsTaskServerField == null) {
                    try {
                        this.realmsTaskServerField = ConnectingToRealmsAction.class.getDeclaredField("field_238116_c_");
                    }
                    catch (NoSuchFieldException nsfe) {
                        this.realmsTaskServerField = ConnectingToRealmsAction.class.getDeclaredField("server");
                    }
                    this.realmsTaskServerField.setAccessible(true);
                }
                if ((task = this.realmsTaskField.get(realmsTaskScreen = (RealmsLongRunningMcoTaskScreen)event.getGui())) instanceof ConnectingToRealmsAction && (realm = (RealmsServer)this.realmsTaskServerField.get(realmsTask = (ConnectingToRealmsAction)task)) != null && (this.latestRealm == null || realm.field_230582_a_ != this.latestRealm.field_230582_a_)) {
                    this.latestRealm = realm;
                }
            }
            catch (Exception e) {
                WorldMap.LOGGER.error("suppressed exception", (Throwable)e);
            }
        }
    }

    @SubscribeEvent
    public void renderTick(TickEvent.RenderTickEvent event) throws Exception {
        WorldMapSession worldmapSession;
        Minecraft mc = Minecraft.func_71410_x();
        if (event.phase == TickEvent.Phase.END) {
            WorldMap.glObjectDeleter.work();
        }
        if (mc.field_71439_g != null && (worldmapSession = WorldMapSession.getCurrentSession()) != null) {
            MapProcessor mapProcessor = worldmapSession.getMapProcessor();
            if (event.phase == TickEvent.Phase.END) {
                mapProcessor.onRenderProcess(mc);
                mc.field_71454_w = false;
                mapProcessor.resetRenderStartTime();
                Queue<Runnable> minecraftScheduledTasks = mapProcessor.getMinecraftScheduledTasks();
                Runnable task = mapProcessor.getRenderStartTimeUpdater();
                Runnable[] currentTasks = minecraftScheduledTasks.toArray(new Runnable[0]);
                minecraftScheduledTasks.clear();
                minecraftScheduledTasks.add(task);
                for (Runnable t : currentTasks) {
                    minecraftScheduledTasks.add(t);
                }
            } else if (event.phase == TickEvent.Phase.START) {
                if (!SupportMods.vivecraft && Misc.screenShouldSkipWorldRender(mc.field_71462_r, true)) {
                    Misc.setShaderProgram(0);
                    RenderSystem.enableDepthTest();
                    mc.field_71460_t.func_195458_a(1.0f, Util.func_211178_c(), false);
                    mc.field_71454_w = true;
                }
                if (mapProcessor != null) {
                    mapProcessor.setMainValues();
                }
            }
        }
    }

    @SubscribeEvent
    public void renderTick(GuiScreenEvent.DrawScreenEvent.Post event) {
        if (Patreon.needsNotification() && event.getGui() instanceof MainMenuScreen && (!SupportMods.minimap() || SupportMods.xaeroMinimap.compatibilityVersion < 1)) {
            Minecraft.func_71410_x().func_147108_a((Screen)new GuiUpdateAll());
        } else if (WorldMap.isOutdated) {
            WorldMap.isOutdated = false;
        }
    }

    public void spawnSet(World world, BlockPos spawn) {
        WorldMapSession worldmapSession;
        if (world instanceof ClientWorld && (worldmapSession = WorldMapSession.getCurrentSession()) != null) {
            MapProcessor mapProcessor = worldmapSession.getMapProcessor();
            mapProcessor.updateWorldSpawn(spawn, (ClientWorld)world);
        }
    }

    @SubscribeEvent
    public void worldCapabilities(AttachCapabilitiesEvent<World> event) {
        if (event.getObject() instanceof ServerWorld) {
            ServerWorldCapabilities capabilityProvider = new ServerWorldCapabilities();
            event.addCapability(new ResourceLocation("xaeroworldmap", "server_world_caps"), (ICapabilityProvider)capabilityProvider);
            event.addListener(capabilityProvider::invalidateCaps);
        }
    }

    @SubscribeEvent
    public void worldUnload(WorldEvent.Unload event) {
        WorldMapSession worldmapSession;
        if (Minecraft.func_71410_x().field_71439_g != null && (worldmapSession = WorldMapSession.getCurrentSession()) != null) {
            MapProcessor mapProcessor = worldmapSession.getMapProcessor();
            if (event.getWorld() == mapProcessor.mainWorld) {
                mapProcessor.onWorldUnload();
            }
        }
        if (event.getWorld() instanceof ServerWorld) {
            ServerWorld sw = (ServerWorld)event.getWorld();
            WorldDataHandler.onServerWorldUnload(sw);
        }
    }

    public RealmsServer getLatestRealm() {
        return this.latestRealm;
    }

    @SubscribeEvent
    protected void handleRenderGameOverlayEventPost(RenderGameOverlayEvent.Post event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.CROSSHAIRS) {
            String crosshairMessage;
            WorldMapSession worldmapSession = WorldMapSession.getCurrentSession();
            MapProcessor mapProcessor = worldmapSession == null ? null : worldmapSession.getMapProcessor();
            String string = crosshairMessage = mapProcessor == null ? null : mapProcessor.getCrosshairMessage();
            if (crosshairMessage != null) {
                int messageWidth = Minecraft.func_71410_x().field_71466_p.func_78256_a(crosshairMessage);
                RenderSystem.disableBlend();
                MainWindow window = Minecraft.func_71410_x().func_228018_at_();
                Minecraft.func_71410_x().field_71466_p.func_238405_a_(event.getMatrixStack(), crosshairMessage, (float)(window.func_198107_o() / 2 - messageWidth / 2), (float)(window.func_198087_p() / 2 + 60), -1);
                RenderSystem.enableBlend();
                Minecraft.func_71410_x().func_110434_K().func_110577_a(AbstractGui.field_230665_h_);
            }
        }
    }

    @SubscribeEvent
    public void handleRenderPlayerEventPost(RenderPlayerEvent.Post event) {
        if (SupportMods.optifine) {
            Patreon.renderCapeFallback(WorldMap.fileLayoutID, event);
        }
    }
}

