/*
 * Decompiled with CFR 0.152.
 */
package fuzs.tinyskeletons.entity.ai.goal;

import net.minecraft.entity.Entity;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.RangedBowAttackGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.item.BowItem;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.util.math.MathHelper;

public class RangedBowEasyAttackGoal<T extends MonsterEntity>
extends RangedBowAttackGoal<T> {
    private final T entity;
    private final double moveSpeedAmplifier;
    private int attackCooldown;
    private final int maxAttackTime;
    private final float maxAttackDistance;
    private int attackTime = -1;
    private int seeTime;

    public RangedBowEasyAttackGoal(T mob, double chaseTargetSpeed, int attackCooldown, int maxAttackTime, float maxAttackDistance) {
        super(mob, chaseTargetSpeed, attackCooldown, maxAttackDistance);
        this.entity = mob;
        this.moveSpeedAmplifier = chaseTargetSpeed;
        this.attackCooldown = attackCooldown;
        this.maxAttackTime = maxAttackTime;
        this.maxAttackDistance = maxAttackDistance * maxAttackDistance;
    }

    public void func_189428_b(int attackCooldownIn) {
        this.attackCooldown = attackCooldownIn;
    }

    public void func_75251_c() {
        this.entity.func_213395_q(false);
        this.seeTime = 0;
        this.attackTime = -1;
        this.entity.func_184602_cy();
    }

    public void func_75246_d() {
        LivingEntity attackTarget = this.entity.func_70638_az();
        if (attackTarget != null) {
            double distanceToTarget = this.entity.func_70092_e(attackTarget.func_226277_ct_(), attackTarget.func_226278_cu_(), attackTarget.func_226281_cx_());
            boolean canSeeTarget = this.entity.func_70635_at().func_75522_a((Entity)attackTarget);
            if (canSeeTarget != this.seeTime > 0) {
                this.seeTime = 0;
            }
            this.seeTime = canSeeTarget ? ++this.seeTime : --this.seeTime;
            boolean moveTowardsTarget = false;
            if (distanceToTarget <= (double)this.maxAttackDistance && this.seeTime >= 20) {
                this.entity.func_70661_as().func_75499_g();
                moveTowardsTarget = distanceToTarget > (double)(this.maxAttackDistance * 0.75f);
            } else {
                this.entity.func_70661_as().func_75497_a((Entity)attackTarget, this.moveSpeedAmplifier);
            }
            if (moveTowardsTarget) {
                this.entity.func_70605_aq().func_188488_a(0.5f, 0.0f);
                this.entity.func_70625_a((Entity)attackTarget, 30.0f, 30.0f);
            } else {
                this.entity.func_70671_ap().func_75651_a((Entity)attackTarget, 30.0f, 30.0f);
            }
            if (this.entity.func_184587_cr()) {
                int useCount;
                if (!canSeeTarget && this.seeTime < -this.maxAttackTime) {
                    this.entity.func_184602_cy();
                } else if (canSeeTarget && (useCount = this.entity.func_184612_cw()) >= 20) {
                    this.entity.func_184602_cy();
                    double distanceVelocity = Math.sqrt(distanceToTarget) / Math.sqrt(this.maxAttackDistance);
                    ((IRangedAttackMob)this.entity).func_82196_d(attackTarget, MathHelper.func_76131_a((float)((float)distanceVelocity), (float)0.1f, (float)1.0f) * BowItem.func_185059_b((int)useCount));
                    this.attackTime = MathHelper.func_76128_c((double)(distanceVelocity * (double)((float)this.maxAttackTime - (float)this.attackCooldown / 2.0f) + (double)((float)this.attackCooldown / 2.0f)));
                }
            } else if (--this.attackTime <= 0 && this.seeTime >= -this.maxAttackTime) {
                this.entity.func_184598_c(ProjectileHelper.func_221274_a(this.entity, (Item)Items.field_151031_f));
            }
        }
    }
}

