/*
 * Decompiled with CFR 0.152.
 */
package fuzs.tinyskeletons.element;

import com.google.common.collect.Maps;
import fuzs.puzzleslib.PuzzlesLib;
import fuzs.puzzleslib.element.extension.ClientExtensibleElement;
import fuzs.tinyskeletons.client.element.TinySkeletonsExtension;
import fuzs.tinyskeletons.entity.monster.BabySkeletonEntity;
import fuzs.tinyskeletons.entity.monster.BabyStrayEntity;
import fuzs.tinyskeletons.entity.monster.BabyWitherSkeletonEntity;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.entity.living.LivingPackSizeEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ObjectHolder;

public class TinySkeletonsElement
extends ClientExtensibleElement<TinySkeletonsExtension> {
    @ObjectHolder(value="tinyskeletons:baby_skeleton")
    public static final EntityType<BabySkeletonEntity> BABY_SKELETON_ENTITY = null;
    @ObjectHolder(value="tinyskeletons:baby_wither_skeleton")
    public static final EntityType<BabyWitherSkeletonEntity> BABY_WITHER_SKELETON_ENTITY = null;
    @ObjectHolder(value="tinyskeletons:baby_stray")
    public static final EntityType<BabyStrayEntity> BABY_STRAY_ENTITY = null;
    private static final Map<EntityType<? extends MobEntity>, EntityType<? extends MobEntity>> BABY_MOB_CONVERSIONS = Maps.newHashMap();

    public TinySkeletonsElement() {
        super(element -> new TinySkeletonsExtension((TinySkeletonsElement)((Object)element)));
    }

    public String[] getDescription() {
        return new String[]{"Teeny, tiny skeletons, send shivers down your spine..."};
    }

    public void constructCommon() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onEntityAttributeCreation);
        this.addListener(this::onLivingPackSize);
        this.addListener(this::onSpecialSpawn);
        this.addListener(this::onEntityInteract);
        PuzzlesLib.getRegistryManagerV2().registerRawEntityType("baby_skeleton", () -> EntityType.Builder.func_220322_a(BabySkeletonEntity::new, (EntityClassification)EntityClassification.MONSTER).func_220321_a(0.6f, 1.99f).func_233606_a_(8));
        PuzzlesLib.getRegistryManagerV2().registerRawEntityType("baby_wither_skeleton", () -> EntityType.Builder.func_220322_a(BabyWitherSkeletonEntity::new, (EntityClassification)EntityClassification.MONSTER).func_220320_c().func_220321_a(0.7f, 2.4f).func_233606_a_(8));
        PuzzlesLib.getRegistryManagerV2().registerRawEntityType("baby_stray", () -> EntityType.Builder.func_220322_a(BabyStrayEntity::new, (EntityClassification)EntityClassification.MONSTER).func_220321_a(0.6f, 1.99f).func_233606_a_(8));
    }

    public void setupCommon2() {
        BABY_MOB_CONVERSIONS.put((EntityType<? extends MobEntity>)EntityType.field_200741_ag, BABY_SKELETON_ENTITY);
        BABY_MOB_CONVERSIONS.put((EntityType<? extends MobEntity>)EntityType.field_200722_aA, BABY_WITHER_SKELETON_ENTITY);
        BABY_MOB_CONVERSIONS.put((EntityType<? extends MobEntity>)EntityType.field_200750_ap, BABY_STRAY_ENTITY);
        EntitySpawnPlacementRegistry.func_209343_a(BABY_SKELETON_ENTITY, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MonsterEntity::func_223325_c);
        EntitySpawnPlacementRegistry.func_209343_a(BABY_WITHER_SKELETON_ENTITY, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MonsterEntity::func_223325_c);
        EntitySpawnPlacementRegistry.func_209343_a(BABY_STRAY_ENTITY, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, BabyStrayEntity::checkBabyStraySpawnRules);
    }

    private void onEntityAttributeCreation(EntityAttributeCreationEvent evt) {
        evt.put(BABY_SKELETON_ENTITY, MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233821_d_, 0.375).func_233813_a_());
        evt.put(BABY_WITHER_SKELETON_ENTITY, MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233821_d_, 0.375).func_233813_a_());
        evt.put(BABY_STRAY_ENTITY, MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233821_d_, 0.375).func_233813_a_());
    }

    public void onLivingPackSize(LivingPackSizeEvent evt) {
        EntityType<? extends MobEntity> babyType;
        if (evt.getEntity().field_70170_p instanceof ServerWorld && ZombieEntity.func_241399_a_((Random)evt.getEntity().field_70170_p.func_201674_k()) && (babyType = BABY_MOB_CONVERSIONS.get(evt.getEntity().func_200600_R())) != null) {
            TinySkeletonsElement.makeBabyMob((ServerWorld)evt.getEntity().field_70170_p, babyType, evt.getEntity(), SpawnReason.NATURAL).ifPresent(mobentity -> evt.getEntity().func_70106_y());
        }
    }

    public void onSpecialSpawn(LivingSpawnEvent.SpecialSpawn evt) {
        EntityType<? extends MobEntity> babyType;
        SpawnReason spawnReason = evt.getSpawnReason();
        if (spawnReason != SpawnReason.NATURAL && spawnReason != SpawnReason.SPAWNER && spawnReason != SpawnReason.COMMAND && evt.getWorld() instanceof ServerWorld && ZombieEntity.func_241399_a_((Random)evt.getWorld().func_201674_k()) && (babyType = BABY_MOB_CONVERSIONS.get(evt.getEntity().func_200600_R())) != null) {
            TinySkeletonsElement.makeBabyMob((ServerWorld)evt.getWorld(), babyType, evt.getEntity(), spawnReason).ifPresent(mobentity -> evt.setCanceled(true));
        }
    }

    public void onEntityInteract(PlayerInteractEvent.EntityInteract evt) {
        ItemStack itemstack;
        EntityType eggType;
        EntityType<? extends MobEntity> babyType;
        Entity target = evt.getTarget();
        if (target.func_70089_S() && evt.getItemStack().func_77973_b() instanceof SpawnEggItem && (babyType = BABY_MOB_CONVERSIONS.get(eggType = ((SpawnEggItem)(itemstack = evt.getItemStack()).func_77973_b()).func_208076_b(itemstack.func_77978_p()))) != null && (target.func_200600_R() == babyType || target.func_200600_R() == eggType)) {
            evt.setCanceled(true);
            if (evt.getWorld() instanceof ServerWorld) {
                Optional<MobEntity> mob = TinySkeletonsElement.makeBabyMob((ServerWorld)evt.getWorld(), babyType, target, SpawnReason.SPAWN_EGG);
                if (mob.isPresent()) {
                    this.finalizeSpawnEggMob(mob.get(), itemstack, evt.getPlayer());
                    evt.setCancellationResult(ActionResultType.SUCCESS);
                    return;
                }
                evt.setCancellationResult(ActionResultType.PASS);
            } else {
                evt.setCancellationResult(ActionResultType.CONSUME);
            }
        }
    }

    private void finalizeSpawnEggMob(MobEntity mobentity, ItemStack itemstack, PlayerEntity player) {
        mobentity.func_70642_aH();
        if (itemstack.func_82837_s()) {
            mobentity.func_200203_b(itemstack.func_200301_q());
        }
        if (!player.field_71075_bZ.field_75098_d) {
            itemstack.func_190918_g(1);
        }
        player.func_71029_a(Stats.field_75929_E.func_199076_b((Object)itemstack.func_77973_b()));
    }

    private static Optional<MobEntity> makeBabyMob(ServerWorld level, EntityType<? extends MobEntity> entityType, Entity parent, SpawnReason spawnReason) {
        Object mobentity = parent instanceof AgeableEntity ? ((AgeableEntity)parent).func_241840_a(level, (AgeableEntity)parent) : (MobEntity)entityType.func_200721_a((World)level);
        if (mobentity == null) {
            return Optional.empty();
        }
        if (!mobentity.func_70631_g_()) {
            throw new RuntimeException("baby mob must be a baby by default");
        }
        mobentity.func_70012_b(parent.func_226277_ct_(), parent.func_226278_cu_(), parent.func_226281_cx_(), MathHelper.func_76142_g((float)(level.field_73012_v.nextFloat() * 360.0f)), 0.0f);
        mobentity.field_70759_as = mobentity.field_70177_z;
        mobentity.field_70761_aq = mobentity.field_70177_z;
        mobentity.func_213386_a((IServerWorld)level, level.func_175649_E(mobentity.func_233580_cy_()), spawnReason, null, null);
        level.func_242417_l((Entity)mobentity);
        return Optional.of(mobentity);
    }
}

