/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.addons.oddities.block;

import java.util.HashSet;
import javax.annotation.Nonnull;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;
import vazkii.quark.addons.oddities.tile.PipeTileEntity;
import vazkii.quark.base.block.QuarkBlock;
import vazkii.quark.base.handler.RenderLayerHandler;
import vazkii.quark.base.module.QuarkModule;

public class PipeBlock
extends QuarkBlock
implements IWaterLoggable {
    private static final VoxelShape CENTER_SHAPE = VoxelShapes.func_197873_a((double)0.3125, (double)0.3125, (double)0.3125, (double)0.6875, (double)0.6875, (double)0.6875);
    private static final VoxelShape DOWN_SHAPE = VoxelShapes.func_197873_a((double)0.3125, (double)0.0, (double)0.3125, (double)0.6875, (double)0.6875, (double)0.6875);
    private static final VoxelShape UP_SHAPE = VoxelShapes.func_197873_a((double)0.3125, (double)0.3125, (double)0.3125, (double)0.6875, (double)1.0, (double)0.6875);
    private static final VoxelShape NORTH_SHAPE = VoxelShapes.func_197873_a((double)0.3125, (double)0.3125, (double)0.0, (double)0.6875, (double)0.6875, (double)0.6875);
    private static final VoxelShape SOUTH_SHAPE = VoxelShapes.func_197873_a((double)0.3125, (double)0.3125, (double)0.3125, (double)0.6875, (double)0.6875, (double)1.0);
    private static final VoxelShape WEST_SHAPE = VoxelShapes.func_197873_a((double)0.0, (double)0.3125, (double)0.3125, (double)0.6875, (double)0.6875, (double)0.6875);
    private static final VoxelShape EAST_SHAPE = VoxelShapes.func_197873_a((double)0.3125, (double)0.3125, (double)0.3125, (double)1.0, (double)0.6875, (double)0.6875);
    public static final BooleanProperty DOWN = BooleanProperty.func_177716_a((String)"down");
    public static final BooleanProperty UP = BooleanProperty.func_177716_a((String)"up");
    public static final BooleanProperty NORTH = BooleanProperty.func_177716_a((String)"north");
    public static final BooleanProperty SOUTH = BooleanProperty.func_177716_a((String)"south");
    public static final BooleanProperty WEST = BooleanProperty.func_177716_a((String)"west");
    public static final BooleanProperty EAST = BooleanProperty.func_177716_a((String)"east");
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    private static final BooleanProperty[] CONNECTIONS = new BooleanProperty[]{DOWN, UP, NORTH, SOUTH, WEST, EAST};
    private static final VoxelShape[] SIDE_BOXES = new VoxelShape[]{DOWN_SHAPE, UP_SHAPE, NORTH_SHAPE, SOUTH_SHAPE, WEST_SHAPE, EAST_SHAPE};
    private static final VoxelShape[] shapeCache = new VoxelShape[64];

    public PipeBlock(QuarkModule module) {
        super("pipe", module, ItemGroup.field_78028_d, AbstractBlock.Properties.func_200945_a((Material)Material.field_151592_s).func_200948_a(3.0f, 10.0f).func_200947_a(SoundType.field_185853_f).func_226896_b_());
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)DOWN, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)UP, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)NORTH, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)SOUTH, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)WEST, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)EAST, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        RenderLayerHandler.setRenderType((Block)this, RenderLayerHandler.RenderTypeSkeleton.CUTOUT);
    }

    public boolean isToolEffective(BlockState state, ToolType tool) {
        return tool == ToolType.PICKAXE;
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        ItemStack stack = player.func_184586_b(handIn);
        if (stack.func_77973_b() == Items.field_151055_y) {
            HashSet found = new HashSet();
            boolean fixedAny = false;
            HashSet<BlockPos> candidates = new HashSet<BlockPos>();
            HashSet<BlockPos> newCandidates = new HashSet<BlockPos>();
            candidates.add(pos);
            do {
                for (BlockPos cand : candidates) {
                    for (Direction d : Direction.values()) {
                        BlockPos offPos = cand.func_177972_a(d);
                        BlockState offState = worldIn.func_180495_p(offPos);
                        if (offState.func_177230_c() != this || candidates.contains(offPos) || found.contains(offPos)) continue;
                        newCandidates.add(offPos);
                    }
                    BlockState curr = worldIn.func_180495_p(cand);
                    BlockState target = this.getTargetState(worldIn, cand, (Boolean)curr.func_177229_b((Property)WATERLOGGED));
                    if (target.equals(curr)) continue;
                    fixedAny = true;
                    worldIn.func_180501_a(cand, target, 6);
                }
                found.addAll(candidates);
                candidates = newCandidates;
                newCandidates = new HashSet();
            } while (!candidates.isEmpty());
            if (fixedAny) {
                return ActionResultType.SUCCESS;
            }
        }
        return super.func_225533_a_(state, worldIn, pos, player, handIn, hit);
    }

    @Nonnull
    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        BlockState targetState = this.getTargetState(worldIn, pos, (Boolean)state.func_177229_b((Property)WATERLOGGED));
        if (!targetState.equals(state)) {
            worldIn.func_180501_a(pos, targetState, 6);
        }
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return this.getTargetState(context.func_195991_k(), context.func_195995_a(), context.func_195991_k().func_204610_c(context.func_195995_a()).func_206886_c() == Fluids.field_204546_a);
    }

    private BlockState getTargetState(World worldIn, BlockPos pos, boolean waterlog) {
        BlockState newState = this.func_176223_P();
        newState = (BlockState)newState.func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(waterlog));
        for (Direction facing : Direction.values()) {
            BooleanProperty prop = CONNECTIONS[facing.ordinal()];
            PipeTileEntity.ConnectionType type = PipeTileEntity.getConnectionTo((IBlockReader)worldIn, pos, facing);
            newState = (BlockState)newState.func_206870_a((Property)prop, (Comparable)Boolean.valueOf(type.isSolid));
        }
        return newState;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        int index = 0;
        for (Direction dir : Direction.values()) {
            int ord = dir.ordinal();
            if (!((Boolean)state.func_177229_b((Property)CONNECTIONS[ord])).booleanValue()) continue;
            index += 1 << ord;
        }
        VoxelShape cached = shapeCache[index];
        if (cached == null) {
            VoxelShape currShape = CENTER_SHAPE;
            for (Direction dir : Direction.values()) {
                boolean connected = PipeBlock.isConnected(state, dir);
                if (!connected) continue;
                currShape = VoxelShapes.func_197872_a((VoxelShape)currShape, (VoxelShape)SIDE_BOXES[dir.ordinal()]);
            }
            PipeBlock.shapeCache[index] = currShape;
            cached = currShape;
        }
        return cached;
    }

    public static boolean isConnected(BlockState state, Direction side) {
        BooleanProperty prop = CONNECTIONS[side.ordinal()];
        return (Boolean)state.func_177229_b((Property)prop);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{UP, DOWN, NORTH, SOUTH, WEST, EAST, WATERLOGGED});
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public int func_180641_l(BlockState blockState, World worldIn, BlockPos pos) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof PipeTileEntity) {
            return ((PipeTileEntity)tile).getComparatorOutput();
        }
        return 0;
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof PipeTileEntity) {
            ((PipeTileEntity)tileentity).dropAllItems();
        }
        super.func_196243_a(state, worldIn, pos, newState, isMoving);
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new PipeTileEntity();
    }
}

