/*
 * Decompiled with CFR 0.152.
 */
package com.fuzs.pickupnotifier.client.gui.entry;

import com.fuzs.pickupnotifier.config.ConfigValueHolder;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.item.Rarity;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import org.apache.commons.lang3.mutable.MutableFloat;

public abstract class DisplayEntry {
    protected final Minecraft mc = Minecraft.func_71410_x();
    public static final int HEIGHT = 18;
    private static final int MARGIN = 4;
    private final Rarity rarity;
    protected int count;
    private final MutableFloat life;

    protected DisplayEntry(int count, Rarity rarity) {
        this.count = Math.min(count, ConfigValueHolder.getGeneralConfig().maxCount);
        this.rarity = rarity;
        this.life = new MutableFloat((float)ConfigValueHolder.getGeneralConfig().displayTime);
    }

    public boolean isDead() {
        return this.life.compareTo(new MutableFloat(0.0f)) < 1;
    }

    public final void tick(float lostLife) {
        this.life.subtract(lostLife);
    }

    public final int getCount() {
        return this.count;
    }

    public abstract boolean canMerge(DisplayEntry var1);

    public final void addCount(int count) {
        this.count = Math.min(this.count + count, ConfigValueHolder.getGeneralConfig().maxCount);
    }

    protected abstract ITextComponent getName();

    private IFormattableTextComponent getFormattedName() {
        IFormattableTextComponent name = new StringTextComponent("").func_230529_a_(this.getName());
        if (this.count <= 0) {
            return name;
        }
        if (ConfigValueHolder.getDisplayConfig().position.isMirrored()) {
            name = new StringTextComponent(this.count + "x ").func_230529_a_((ITextComponent)name);
        } else {
            name.func_240702_b_(" x" + this.count);
        }
        return name.func_230530_a_(this.getStyle());
    }

    public final float getRelativeLife() {
        return 1.0f - Math.min(1.0f, this.getLife() / (float)Math.min(ConfigValueHolder.getGeneralConfig().moveTime, ConfigValueHolder.getGeneralConfig().displayTime));
    }

    protected final float getLife() {
        return Math.max(0.0f, this.life.floatValue());
    }

    public final void resetLife() {
        this.life.setValue((float)ConfigValueHolder.getGeneralConfig().displayTime);
    }

    public void merge(DisplayEntry entry) {
        this.addCount(entry.getCount());
        this.resetLife();
    }

    private Style getStyle() {
        if (!ConfigValueHolder.getGeneralConfig().ignoreRarity && this.rarity != Rarity.COMMON) {
            return Style.field_240709_b_.func_240712_a_(this.rarity.field_77937_e);
        }
        return Style.field_240709_b_.func_240712_a_(ConfigValueHolder.getGeneralConfig().textColor);
    }

    public int getTotalWidth() {
        int width = this.mc.field_71466_p.func_238414_a_((ITextProperties)this.getFormattedName());
        return ConfigValueHolder.getGeneralConfig().showSprite ? width + 4 + 16 : width;
    }

    public final void render(MatrixStack matrixstack, int posX, int posY, float alpha) {
        int fadeTime;
        boolean mirrored = ConfigValueHolder.getDisplayConfig().position.isMirrored();
        boolean sprite = ConfigValueHolder.getGeneralConfig().showSprite;
        int i = mirrored || !sprite ? posX : posX + 16 + 4;
        int textWidth = this.mc.field_71466_p.func_238414_a_((ITextProperties)this.getFormattedName());
        int opacity = this.mc.field_71474_y.func_216839_a(0);
        if (opacity != 0) {
            this.mc.field_71466_p.getClass();
            AbstractGui.func_238467_a_((MatrixStack)matrixstack, (int)(i - 2), (int)(posY + 3 - 2), (int)(i + textWidth + 2), (int)(posY + 3 + 9 + 2), (int)opacity);
        }
        int n = fadeTime = ConfigValueHolder.getGeneralConfig().fadeAway ? 255 - (int)(255.0f * alpha) : 255;
        if (fadeTime >= 5) {
            RenderSystem.pushMatrix();
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            AbstractGui.func_238475_b_((MatrixStack)matrixstack, (FontRenderer)this.mc.field_71466_p, (ITextComponent)this.getFormattedName(), (int)i, (int)(posY + 3), (int)(0xFFFFFF + (fadeTime << 24)));
            RenderSystem.disableBlend();
            if (sprite) {
                this.renderSprite(matrixstack, mirrored ? posX + textWidth + 4 : posX, posY);
            }
            RenderSystem.popMatrix();
        }
    }

    protected abstract void renderSprite(MatrixStack var1, int var2, int var3);
}

