/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.paxi;

import com.google.common.collect.Lists;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import com.google.gson.annotations.SerializedName;
import com.yungnickyoung.minecraft.paxi.Paxi;
import com.yungnickyoung.minecraft.paxi.PaxiResourcePackSource;
import com.yungnickyoung.minecraft.yungsapi.io.JSON;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.resources.FilePack;
import net.minecraft.resources.FolderPack;
import net.minecraft.resources.FolderPackFinder;
import net.minecraft.resources.IPackNameDecorator;
import net.minecraft.resources.IResourcePack;
import net.minecraft.resources.ResourcePackInfo;

public class PaxiFileResourcePackProvider
extends FolderPackFinder {
    private static final FileFilter POSSIBLE_PACK = file -> {
        boolean isValidPackZip = file.isFile() && file.getName().endsWith(".zip");
        boolean isValidPackFolder = file.isDirectory() && new File(file, "pack.mcmeta").isFile();
        return isValidPackZip || isValidPackFolder;
    };
    private File ordering;
    public List<String> orderedPaxiPacks = new ArrayList<String>();

    public PaxiFileResourcePackProvider(File packsFolder, File ordering) {
        super(packsFolder, PaxiResourcePackSource.PACK_SOURCE_PAXI);
        this.ordering = ordering;
    }

    public PaxiFileResourcePackProvider(File packsFolder) {
        super(packsFolder, PaxiResourcePackSource.PACK_SOURCE_PAXI);
    }

    @ParametersAreNonnullByDefault
    public void func_230230_a_(Consumer<ResourcePackInfo> profileAdder, ResourcePackInfo.IFactory factory) {
        File[] packs;
        if (!this.field_195736_b.isDirectory()) {
            this.field_195736_b.mkdirs();
        }
        if (this.ordering != null && !this.ordering.isFile()) {
            PackOrdering emptyPackOrdering = new PackOrdering(new String[0]);
            try {
                JSON.createJsonFileFromObject((Path)this.ordering.toPath(), (Object)emptyPackOrdering);
            }
            catch (IOException e) {
                Paxi.LOGGER.error("Unable to create default pack ordering file! This shouldn't happen.");
                Paxi.LOGGER.error(e.toString());
            }
        }
        if ((packs = this.loadPacksFromFiles()) != null) {
            for (File file : packs) {
                String packName = file.getName();
                ResourcePackInfo resourcePackProfile = ResourcePackInfo.func_195793_a((String)packName, (boolean)true, this.createResourcePack(file), (ResourcePackInfo.IFactory)factory, (ResourcePackInfo.Priority)ResourcePackInfo.Priority.TOP, (IPackNameDecorator)PaxiResourcePackSource.PACK_SOURCE_PAXI);
                if (resourcePackProfile == null) continue;
                profileAdder.accept(resourcePackProfile);
            }
        }
    }

    private File[] loadPacksFromFiles() {
        if (this.ordering != null) {
            PackOrdering packOrdering = null;
            try {
                packOrdering = (PackOrdering)JSON.loadObjectFromJsonFile((Path)this.ordering.toPath(), PackOrdering.class);
            }
            catch (JsonIOException | JsonSyntaxException | IOException e) {
                Paxi.LOGGER.error("Error loading Paxi datapack datapack_load_order.json file: {}", (Object)e.toString());
            }
            if (packOrdering == null) {
                Paxi.LOGGER.error("Unable to load datapack_load_order.json! Is it proper JSON formatting? Ignoring load order...");
                return this.field_195736_b.listFiles(POSSIBLE_PACK);
            }
            if (packOrdering.getOrderedPackNames() == null) {
                Paxi.LOGGER.error("Unable to find entry with name 'loadOrder' in datapack_load_order.json! Ignoring load order...");
                return this.field_195736_b.listFiles(POSSIBLE_PACK);
            }
            List<File> orderedPacks = this.filesFromNames(packOrdering.getOrderedPackNames(), POSSIBLE_PACK);
            orderedPacks.forEach(file -> this.orderedPaxiPacks.add(file.getName()));
            File[] allPacks = this.field_195736_b.listFiles(POSSIBLE_PACK);
            ArrayList leftoverPacks = allPacks == null ? Lists.newArrayList() : Arrays.stream(allPacks).filter(file -> !orderedPacks.contains(file)).collect(Collectors.toList());
            return (File[])Stream.of(orderedPacks, leftoverPacks).flatMap(Collection::stream).toArray(File[]::new);
        }
        return this.field_195736_b.listFiles(POSSIBLE_PACK);
    }

    private List<File> filesFromNames(String[] packFileNames, FileFilter filter) {
        ArrayList<File> packFiles = new ArrayList<File>();
        for (String fileName : packFileNames) {
            File packFile = new File(this.field_195736_b, fileName);
            if (!packFile.exists()) {
                Paxi.LOGGER.error("Unable to find pack with name {} specified in datapack_load_order.json! Skipping...", (Object)fileName);
                continue;
            }
            if (filter != null && !filter.accept(packFile)) continue;
            packFiles.add(packFile);
        }
        return packFiles;
    }

    private Supplier<IResourcePack> createResourcePack(File file) {
        return file.isDirectory() ? () -> new FolderPack(file) : () -> new FilePack(file);
    }

    private static class PackOrdering {
        @SerializedName(value="loadOrder")
        private String[] orderedPackNames;

        public PackOrdering(String[] orderedPackNames) {
            this.orderedPackNames = orderedPackNames;
        }

        public String[] getOrderedPackNames() {
            return this.orderedPackNames;
        }
    }
}

