/*
 * Decompiled with CFR 0.152.
 */
package shadow.com.terraformersmc.terraform.shapes.impl.layer.transform;

import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import shadow.com.terraformersmc.terraform.shapes.api.Position;
import shadow.com.terraformersmc.terraform.shapes.api.Quaternion;
import shadow.com.terraformersmc.terraform.shapes.api.Shape;
import shadow.com.terraformersmc.terraform.shapes.api.layer.Layer;

public class RotateLayer
implements Layer {
    private final Quaternion rotation;

    public RotateLayer(Quaternion rotation) {
        this.rotation = rotation;
    }

    public static RotateLayer of(Quaternion rotation) {
        return new RotateLayer(rotation);
    }

    @Override
    public Position modifyMax(Shape shape) {
        List translatedVertices = Position.vertices(shape.max(), shape.min()).stream().map(pos -> pos.rotateBy(this.rotation)).collect(Collectors.toList());
        return Position.of(translatedVertices.stream().map(Position::getX).max(Double::compareTo).get(), translatedVertices.stream().map(Position::getY).max(Double::compareTo).get(), translatedVertices.stream().map(Position::getZ).max(Double::compareTo).get());
    }

    @Override
    public Position modifyMin(Shape shape) {
        List translatedVertices = Position.vertices(shape.max(), shape.min()).stream().map(pos -> pos.rotateBy(this.rotation)).collect(Collectors.toList());
        return Position.of(translatedVertices.stream().map(Position::getX).min(Double::compareTo).get(), translatedVertices.stream().map(Position::getY).min(Double::compareTo).get(), translatedVertices.stream().map(Position::getZ).min(Double::compareTo).get());
    }

    @Override
    public Predicate<Position> modifyEquation(Shape shape) {
        return pos -> shape.equation().test(pos.rotateBy(this.rotation.conjugate()));
    }
}

