/*
 * Decompiled with CFR 0.152.
 */
package blueduck.outerend.entities;

import blueduck.outerend.registry.ItemRegistry;
import java.util.Random;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.GolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.server.ServerWorld;

public class PurpurGolemEntity
extends MonsterEntity {
    private static final DataParameter<Float> ARM_SWING = EntityDataManager.func_187226_a(PurpurGolemEntity.class, (IDataSerializer)DataSerializers.field_187193_c);

    public PurpurGolemEntity(EntityType<? extends MonsterEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70699_by = new GroundPathNavigator((MobEntity)this, worldIn);
    }

    public void func_184651_r() {
        this.field_70714_bg.func_75776_a(8, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.applyEntityAI();
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ARM_SWING, (Object)Float.valueOf(0.0f));
    }

    public void applyEntityAI() {
        this.field_70714_bg.func_75776_a(2, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, false));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]).func_220794_a(new Class[]{PurpurGolemEntity.class}));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, GolemEntity.class, 5, false, false, p_234199_0_ -> !(p_234199_0_ instanceof IMob)));
    }

    public static AttributeModifierMap createModifiers() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233821_d_, 0.2).func_233815_a_(Attributes.field_233823_f_, 16.0).func_233815_a_(Attributes.field_233826_i_, 0.0).func_233815_a_(Attributes.field_233824_g_, 8.0).func_233815_a_(Attributes.field_233819_b_, 12.0).func_233815_a_(Attributes.field_233820_c_, 1.0E8).func_233815_a_(Attributes.field_233818_a_, 80.0).func_233813_a_();
    }

    public Entity getNearest(Class<? extends LivingEntity> ... classes) {
        for (Class<? extends LivingEntity> clazz : classes) {
            LivingEntity e = this.field_70170_p.func_217360_a(clazz, EntityPredicate.field_221016_a.func_221014_c().func_221010_e().func_221012_a(entity -> {
                if (entity instanceof PlayerEntity) {
                    return !((PlayerEntity)entity).func_184812_l_();
                }
                return true;
            }), null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), new AxisAlignedBB(-16.0, -16.0, -16.0, 16.0, 16.0, 16.0).func_191194_a(this.func_213303_ch()));
            if (e == null) continue;
            return e;
        }
        return null;
    }

    public boolean func_70652_k(Entity entityIn) {
        this.setSwingProgress(0.1f);
        boolean flag = super.func_70652_k(entityIn);
        entityIn.func_213317_d(entityIn.func_213322_ci().func_72441_c(0.0, (double)0.4f, 0.0));
        return flag;
    }

    public void setSwingProgress(float amt) {
        this.field_70180_af.func_187227_b(ARM_SWING, (Object)Float.valueOf(amt));
    }

    public float getSwingProgress() {
        return ((Float)this.field_70180_af.func_187225_a(ARM_SWING)).floatValue();
    }

    public void incrementSwingProgress(float amt) {
        this.field_70180_af.func_187227_b(ARM_SWING, (Object)Float.valueOf(this.getSwingProgress() + amt));
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.getSwingProgress() != 0.0f) {
            this.incrementSwingProgress(0.15f);
            if (this.getSwingProgress() >= 2.0f) {
                this.setSwingProgress(0.0f);
            }
        }
        this.field_70143_R = 0.0f;
        this.func_70050_g(10);
    }

    public boolean func_195064_c(EffectInstance effectInstanceIn) {
        if (effectInstanceIn.func_188419_a().equals(Effects.field_76436_u) || effectInstanceIn.func_188419_a().equals(Effects.field_188424_y)) {
            return false;
        }
        return super.func_195064_c(effectInstanceIn);
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack((IItemProvider)ItemRegistry.PURPUR_GOLEM_SPAWN_EGG.get());
    }

    public static boolean canSpawn(EntityType<PurpurGolemEntity> type, IWorld world, SpawnReason spawnReason, BlockPos pos, Random random) {
        if (world instanceof ServerWorld && ((ServerWorld)world).func_241112_a_().func_235010_a_(pos, true, Structure.field_236379_o_).func_75069_d()) {
            return true;
        }
        int radius = 15;
        BlockPos min = pos.func_177982_a(-radius, -radius, -radius);
        BlockPos max = pos.func_177982_a(radius, radius, radius);
        for (BlockPos posAround : BlockPos.Mutable.func_218278_a((BlockPos)min, (BlockPos)max)) {
            if (!(world instanceof ServerWorld) || !((ServerWorld)world).func_241112_a_().func_235010_a_(posAround, true, Structure.field_236379_o_).func_75069_d()) continue;
            return true;
        }
        return false;
    }

    public SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187602_cF;
    }

    public SoundEvent func_184615_bR() {
        return SoundEvents.field_187599_cE;
    }

    public int func_70693_a(PlayerEntity player) {
        return player.func_130014_f_().func_201674_k().nextInt(50);
    }
}

