/*
 * Decompiled with CFR 0.152.
 */
package blueduck.outerend.entities;

import blueduck.outerend.registry.ItemRegistry;
import java.util.EnumSet;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.BodyController;
import net.minecraft.entity.ai.controller.LookController;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.FlyingPathNavigator;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ChorusSquidEntity
extends CreatureEntity {
    private static final DataParameter<ChorusSquidMode> MODE = EntityDataManager.func_187226_a(ChorusSquidEntity.class, (IDataSerializer)ChorusSquidMode.SERIALIZER);
    private static final DataParameter<Float> WANTED_TENTACLE_ANGLE = EntityDataManager.func_187226_a(ChorusSquidEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    public float prevTentacleAngle;
    public float tentacleAngle;
    public float wantedPitchOffset;
    public float prevPitchOffset;
    public float pitchOffset;

    public static boolean shouldSpawn(EntityType<ChorusSquidEntity> squid, IServerWorld world, SpawnReason reason, BlockPos pos, Random rand) {
        return !world.func_175623_d(pos.func_177977_b()) && world.func_175623_d(pos) && world.func_175623_d(pos.func_177984_a()) && world.func_175623_d(pos.func_177981_b(2));
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld world, DifficultyInstance difficulty, SpawnReason reason, @Nullable ILivingEntityData entityData, @Nullable CompoundNBT tag) {
        this.func_70107_b(this.func_226277_ct_(), this.func_226278_cu_() + 2.0, this.func_226281_cx_());
        return super.func_213386_a(world, difficulty, reason, entityData, tag);
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack((IItemProvider)ItemRegistry.CHORUS_SQUID_SPAWN_EGG.get());
    }

    public ChorusSquidEntity(EntityType<? extends ChorusSquidEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70146_Z.setSeed(this.func_145782_y());
        this.field_70765_h = new ChorusSquidMovementController(this);
        this.field_70749_g = new ChorusSquidLookController(this);
        this.tentacleAngle = 0.0f;
        this.prevTentacleAngle = 0.0f;
        this.wantedPitchOffset = 0.0f;
        this.pitchOffset = 0.0f;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(MODE, (Object)ChorusSquidMode.IDLE);
        this.field_70180_af.func_187214_a(WANTED_TENTACLE_ANGLE, (Object)Float.valueOf(0.0f));
    }

    public ChorusSquidMode getSquidMode() {
        return (ChorusSquidMode)((Object)this.field_70180_af.func_187225_a(MODE));
    }

    public void setSquidMode(ChorusSquidMode mode) {
        this.field_70180_af.func_187227_b(MODE, (Object)mode);
    }

    public static AttributeModifierMap createModifiers() {
        return CreatureEntity.func_233666_p_().func_233815_a_(Attributes.field_233822_e_, (double)0.4f).func_233815_a_(Attributes.field_233823_f_, 2.0).func_233815_a_(Attributes.field_233826_i_, 0.0).func_233815_a_(Attributes.field_233819_b_, 32.0).func_233815_a_(Attributes.field_233818_a_, 12.0).func_233813_a_();
    }

    protected PathNavigator func_175447_b(World worldIn) {
        FlyingPathNavigator flyingpathnavigator = new FlyingPathNavigator((MobEntity)this, worldIn);
        flyingpathnavigator.func_192879_a(false);
        flyingpathnavigator.func_212239_d(true);
        flyingpathnavigator.func_192878_b(true);
        return flyingpathnavigator;
    }

    protected BodyController func_184650_s() {
        return new ChorusSquidBodyController((MobEntity)this);
    }

    protected void func_184651_r() {
        this.field_70715_bh.func_75776_a(0, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(1, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, 50, true, false, null));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, AnimalEntity.class, 50, true, false, null));
        this.field_70714_bg.func_75776_a(0, (Goal)new AttackGoal(this, 2.0));
        this.field_70714_bg.func_75776_a(1, (Goal)new IdleGoal(this));
    }

    public void setWantedTentacleAngle(float angle) {
        this.field_70180_af.func_187227_b(WANTED_TENTACLE_ANGLE, (Object)Float.valueOf(angle));
    }

    public float getWantedTentacleAngle() {
        return ((Float)this.field_70180_af.func_187225_a(WANTED_TENTACLE_ANGLE)).floatValue();
    }

    public void func_70636_d() {
        this.prevTentacleAngle = this.tentacleAngle;
        this.prevPitchOffset = this.pitchOffset;
        this.func_189654_d(true);
        float pitchFactor = 0.1f;
        switch (this.getSquidMode()) {
            case MOVE: {
                this.wantedPitchOffset = 0.0f;
                pitchFactor = 0.05f;
                float wantedTentacleAngle = this.getWantedTentacleAngle();
                if (wantedTentacleAngle != 90.0f && wantedTentacleAngle != 0.0f) {
                    this.setWantedTentacleAngle(90.0f);
                }
                if (!(MathHelper.func_76135_e((float)(wantedTentacleAngle - this.tentacleAngle)) < 0.5f)) break;
                if (wantedTentacleAngle == 90.0f) {
                    this.setWantedTentacleAngle(0.0f);
                    break;
                }
                this.setWantedTentacleAngle(90.0f);
                break;
            }
            case IDLE: {
                this.wantedPitchOffset = 90.0f;
                pitchFactor = 0.1f;
                this.setWantedTentacleAngle(0.0f);
                break;
            }
            case LUNGE: {
                this.wantedPitchOffset = 160.0f;
                pitchFactor = 0.2f;
            }
        }
        this.pitchOffset += (this.wantedPitchOffset - this.pitchOffset) * pitchFactor;
        this.tentacleAngle += (this.getWantedTentacleAngle() - this.tentacleAngle) * 0.2f;
        super.func_70636_d();
    }

    public void func_70071_h_() {
        if (this.func_226278_cu_() < 1.0) {
            this.func_70665_d(DamageSource.field_76380_i, 5.0f);
        }
        super.func_70071_h_();
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        return super.func_70097_a(source, amount) && this.func_70643_av() != null;
    }

    public void func_213352_e(Vector3d travelVector) {
        if (this.func_70090_H()) {
            this.func_213309_a(0.02f, travelVector);
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            this.func_213317_d(this.func_213322_ci().func_186678_a((double)0.8f));
        } else if (this.func_180799_ab()) {
            this.func_213309_a(0.02f, travelVector);
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            this.func_213317_d(this.func_213322_ci().func_186678_a(0.5));
        } else {
            BlockPos ground = new BlockPos(this.func_226277_ct_(), this.func_226278_cu_() - 1.0, this.func_226281_cx_());
            float f = 0.91f;
            if (this.field_70122_E) {
                f = this.field_70170_p.func_180495_p(ground).getSlipperiness((IWorldReader)this.field_70170_p, ground, (Entity)this) * 0.91f;
            }
            float f1 = 0.16277137f / (f * f * f);
            f = 0.91f;
            if (this.field_70122_E) {
                f = this.field_70170_p.func_180495_p(ground).getSlipperiness((IWorldReader)this.field_70170_p, ground, (Entity)this) * 0.91f;
            }
            this.func_213309_a(this.field_70122_E ? 0.1f * f1 : 0.02f, travelVector);
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            this.func_213317_d(this.func_213322_ci().func_186678_a((double)f));
        }
        this.func_233629_a_((LivingEntity)this, false);
    }

    public int func_82143_as() {
        return 16;
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 19) {
            // empty if block
        }
        super.func_70103_a(id);
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return sizeIn.field_220316_b * 0.5f;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187829_fQ;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187833_fS;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187831_fR;
    }

    protected float func_70599_aP() {
        return 0.4f;
    }

    protected boolean func_225502_at_() {
        return false;
    }

    static {
        DataSerializers.func_187189_a((IDataSerializer)ChorusSquidMode.SERIALIZER);
    }

    class IdleGoal
    extends Goal {
        private ChorusSquidEntity squid;

        public IdleGoal(ChorusSquidEntity squid) {
            this.squid = squid;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public void func_75249_e() {
            this.squid.setSquidMode(ChorusSquidMode.IDLE);
        }

        public boolean func_75250_a() {
            if (this.squid.func_70638_az() != null && this.squid.func_70638_az().func_70089_S()) {
                return this.squid.func_70068_e((Entity)this.squid.func_70638_az()) > 576.0;
            }
            return true;
        }

        public void func_75246_d() {
            Vector3d posBelow;
            this.squid.field_70125_A *= 0.98f;
            this.squid.field_70177_z *= 0.92f;
            Vector3d pos = ChorusSquidEntity.this.func_213303_ch();
            BlockRayTraceResult hitBelow = ChorusSquidEntity.this.field_70170_p.func_217299_a(new RayTraceContext(pos, posBelow = ChorusSquidEntity.this.func_213303_ch().func_72441_c(0.0, -1.85, 0.0), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)this.squid));
            if (hitBelow.func_216346_c() != RayTraceResult.Type.BLOCK) {
                this.squid.func_213315_a(MoverType.SELF, new Vector3d(0.0, -0.04, 0.0));
            } else {
                double deltaY = this.squid.func_226278_cu_() - hitBelow.func_216347_e().field_72448_b;
                if (deltaY < 1.85) {
                    this.squid.func_213315_a(MoverType.SELF, new Vector3d(0.0, 0.04, 0.0));
                }
            }
        }
    }

    class AttackGoal
    extends MeleeAttackGoal {
        boolean isBiting;

        public AttackGoal(CreatureEntity squid, double speed) {
            super(squid, speed, true);
        }

        public void func_75249_e() {
            super.func_75249_e();
            ((ChorusSquidEntity)this.field_75441_b).setSquidMode(ChorusSquidMode.MOVE);
            this.isBiting = false;
        }

        public boolean func_75253_b() {
            return super.func_75253_b();
        }

        public void func_75246_d() {
            ChorusSquidEntity squid = (ChorusSquidEntity)this.field_75441_b;
            super.func_75246_d();
            try {
                if (squid.func_70638_az().func_70068_e((Entity)squid) <= this.func_179512_a((LivingEntity)squid)) {
                    squid.setSquidMode(ChorusSquidMode.LUNGE);
                    if (squid.tentacleAngle <= 15.0f) {
                        squid.setWantedTentacleAngle(80.0f);
                    } else if (squid.tentacleAngle >= 75.0f) {
                        squid.setWantedTentacleAngle(10.0f);
                    }
                } else {
                    squid.setSquidMode(ChorusSquidMode.MOVE);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        protected void func_190102_a(LivingEntity enemy, double distSq) {
            ChorusSquidEntity squid = (ChorusSquidEntity)this.field_75441_b;
            if (squid.pitchOffset > 120.0f && distSq <= this.func_179512_a(enemy) && !this.isBiting && squid.tentacleAngle >= 75.0f) {
                this.isBiting = true;
            }
            if (this.isBiting && squid.tentacleAngle <= 40.0f) {
                squid.func_70652_k((Entity)enemy);
                this.isBiting = false;
            }
        }

        protected double func_179512_a(LivingEntity enemy) {
            return 9.0f + this.field_75441_b.func_70638_az().func_213311_cf();
        }
    }

    class ChorusSquidBodyController
    extends BodyController {
        public ChorusSquidBodyController(MobEntity mob) {
            super(mob);
        }

        public void func_75664_a() {
            super.func_75664_a();
            ChorusSquidEntity squid = ChorusSquidEntity.this;
            squid.field_70759_as = squid.field_70761_aq;
            squid.field_70761_aq = squid.field_70177_z;
        }
    }

    class ChorusSquidLookController
    extends LookController {
        public ChorusSquidLookController(ChorusSquidEntity squid) {
            super((MobEntity)squid);
        }

        public void func_75649_a() {
            ChorusSquidEntity squid = (ChorusSquidEntity)this.field_75659_a;
            if (this.field_75655_d) {
                this.field_75655_d = false;
                squid.field_70177_z = this.func_220678_h();
                squid.field_70125_A = (this.func_220677_g() - squid.field_70125_A) * 0.5f;
            }
        }
    }

    class ChorusSquidMovementController
    extends MovementController {
        float moveSpeed;

        public ChorusSquidMovementController(ChorusSquidEntity squid) {
            super((MobEntity)squid);
            this.moveSpeed = 0.0f;
        }

        public void func_75641_c() {
            float wantedTentacleAngle;
            ChorusSquidEntity squid = (ChorusSquidEntity)this.field_75648_a;
            LivingEntity target = squid.func_70638_az();
            if (target == null || !target.func_70089_S() || squid.func_70068_e((Entity)target) > 576.0) {
                return;
            }
            this.moveSpeed = ChorusSquidEntity.this.getSquidMode() == ChorusSquidMode.MOVE ? ((wantedTentacleAngle = ChorusSquidEntity.this.getWantedTentacleAngle()) == 0.0f ? 0.4f + (90.0f - ChorusSquidEntity.this.tentacleAngle) / 90.0f * 0.8f : (float)((double)this.moveSpeed * 0.9)) : (ChorusSquidEntity.this.getSquidMode() == ChorusSquidMode.LUNGE ? 0.6f : 0.0f);
            float baseSpeed = (float)(this.field_75645_e * squid.func_233637_b_(Attributes.field_233822_e_));
            Vector3d delta = target.func_174824_e(0.0f).func_178788_d(squid.func_213303_ch());
            if (delta.func_189985_c() >= 0.25) {
                delta = delta.func_72432_b();
                double factor = baseSpeed * this.moveSpeed * 0.3f;
                delta = delta.func_216372_d(factor, factor, factor);
                squid.func_213315_a(MoverType.SELF, delta);
            }
        }
    }

    public static enum ChorusSquidMode {
        IDLE,
        LUNGE,
        MOVE;

        public static final Serializer SERIALIZER;

        static {
            SERIALIZER = new Serializer();
        }

        private static class Serializer
        implements IDataSerializer<ChorusSquidMode> {
            private Serializer() {
            }

            public void write(PacketBuffer packet, ChorusSquidMode mode) {
                packet.func_179249_a((Enum)mode);
            }

            public ChorusSquidMode read(PacketBuffer packet) {
                return (ChorusSquidMode)packet.func_179257_a(ChorusSquidMode.class);
            }

            public ChorusSquidMode copyValue(ChorusSquidMode mode) {
                return mode;
            }
        }
    }
}

