/*
 * Decompiled with CFR 0.152.
 */
package blueduck.outerend;

import blueduck.outerend.blocks.CrystalBudBlock;
import blueduck.outerend.client.ClientSetup;
import blueduck.outerend.common.CommonSetup;
import blueduck.outerend.config.ConfigHelper;
import blueduck.outerend.config.OuterEndConfig;
import blueduck.outerend.features.ConfiguredStructureFeatures;
import blueduck.outerend.items.OuterEndSpawnEgg;
import blueduck.outerend.registry.BiomeRegistry;
import blueduck.outerend.registry.BlockRegistry;
import blueduck.outerend.registry.EntityRegistry;
import blueduck.outerend.registry.FeatureRegistry;
import blueduck.outerend.registry.ItemRegistry;
import blueduck.outerend.registry.ProcessorRegistry;
import blueduck.outerend.registry.SoundRegistry;
import blueduck.outerend.registry.StructureRegistry;
import blueduck.outerend.server.BlockEventListener;
import blueduck.outerend.server.EntityEventListener;
import blueduck.outerend.server.ServerStartup;
import com.minecraftabnormals.abnormals_core.core.registry.BoatRegistry;
import com.minecraftabnormals.abnormals_core.core.util.registry.RegistryHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowerPotBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.TableLootEntry;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.FlatChunkGenerator;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.settings.DimensionStructuresSettings;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="outer_end")
public class OuterEndMod {
    public static final Logger LOGGER = LogManager.getLogger();
    public static String MODID = "outer_end";
    public static OuterEndConfig CONFIG;
    public static RegistryHelper HELPER;
    public static ArrayList<UUID> DEVS;

    public OuterEndMod() {
        CONFIG = ConfigHelper.register(ModConfig.Type.COMMON, OuterEndConfig::new);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(CommonSetup::onCommonSetup);
        MinecraftForge.EVENT_BUS.addListener(ServerStartup::onServerStarting);
        MinecraftForge.EVENT_BUS.addListener(EntityEventListener::onBonemeal);
        MinecraftForge.EVENT_BUS.addListener(BlockEventListener::onFluidChangeBlock);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::doClientStuff);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.NORMAL, this::addDimensionalSpacing);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.HIGH, this::biomeModification);
        BiomeRegistry.init();
        BlockRegistry.init();
        EntityRegistry.init();
        ItemRegistry.init();
        StructureRegistry.init();
        SoundRegistry.init();
        if (FMLEnvironment.dist.isClient()) {
            FMLJavaModLoadingContext.get().getModEventBus().addListener(ClientSetup::onSetup);
            DEVS.add(UUID.fromString("380df991-f603-344c-a090-369bad2a924a"));
            DEVS.add(UUID.fromString("c88a2cce-333f-450d-be8b-374c216ad4b5"));
            DEVS.add(UUID.fromString("d2b21209-ffe6-47f0-b86a-b13d40eeebc2"));
            DEVS.add(UUID.fromString("5a359e55-da1d-4c81-83d3-f9b63b9e59c7"));
            DEVS.add(UUID.fromString("0bd28a4b-2666-428b-8c04-2dff8a4c8fd9"));
            DEVS.add(UUID.fromString("631b7d0b-23c5-4341-bcc1-87fc02f8840a"));
            DEVS.add(UUID.fromString("264767a2-6a9b-4a35-9b3a-89c855164850"));
            DEVS.add(UUID.fromString("b0242a0f-e172-45f2-a79e-9fa14494bba9"));
            DEVS.add(UUID.fromString("3e7e37bd-95de-43c1-9ee4-b3b63dbdf66f"));
            DEVS.add(UUID.fromString("cf8bf0da-f86d-4ac0-b48a-3f6d940f6472"));
            DEVS.add(UUID.fromString("b62ad4bd-b2eb-47cb-b88b-564fc8ffb50f"));
            DEVS.add(UUID.fromString("3842d959-2871-4eb9-bcb9-aa0e35b36f2a"));
        }
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            StructureRegistry.setupStructures();
            ConfiguredStructureFeatures.registerConfiguredStructures();
            BlockRegistry.registerFlammables();
            ProcessorRegistry.registerProcessors();
        });
        BoatRegistry.registerBoat((String)"outer_end:azure", ItemRegistry.AZURE_BOAT, BlockRegistry.AZURE_PLANKS);
        FlowerPotBlock pot = (FlowerPotBlock)Blocks.field_150457_bL;
        pot.addPlant(new ResourceLocation("outer_end:azure_bud"), BlockRegistry.POTTED_AZURE_BUD);
        pot.addPlant(new ResourceLocation("outer_end:ender_roots"), BlockRegistry.POTTED_ENDER_ROOTS);
        pot.addPlant(new ResourceLocation("outer_end:azure_sprouts"), BlockRegistry.POTTED_AZURE_SPROUTS);
        CrystalBudBlock.CRYSTAL_MAP.put((Block)BlockRegistry.ROSE_CRYSTAL_BUD.get(), (Block)BlockRegistry.ROSE_CRYSTAL.get());
        CrystalBudBlock.CRYSTAL_MAP.put((Block)BlockRegistry.MINT_CRYSTAL_BUD.get(), (Block)BlockRegistry.MINT_CRYSTAL.get());
        CrystalBudBlock.CRYSTAL_MAP.put((Block)BlockRegistry.COBALT_CRYSTAL_BUD.get(), (Block)BlockRegistry.COBALT_CRYSTAL.get());
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        LOGGER.info("Got game settings {}", (Object)((Minecraft)event.getMinecraftSupplier().get()).field_71474_y);
    }

    public void biomeModification(BiomeLoadingEvent event) {
        if (event.getCategory().equals((Object)Biome.Category.THEEND) && !event.getName().equals((Object)new ResourceLocation("minecraft:the_end"))) {
            event.getGeneration().getStructures().add(() -> ConfiguredStructureFeatures.CONFIGURED_END_TOWER);
            event.getGeneration().getStructures().add(() -> ConfiguredStructureFeatures.CONFIGURED_CATACOMBS);
            event.getSpawns().func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners((EntityType)EntityRegistry.PURPUR_GOLEM.get(), 3, 1, 1));
        }
        if (event.getName().equals((Object)new ResourceLocation("minecraft:end_highlands"))) {
            event.getSpawns().func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners((EntityType)EntityRegistry.CHORUS_SQUID.get(), 8, 1, 1));
        }
        if (event.getName().equals((Object)new ResourceLocation("outer_end:crystal_crag"))) {
            event.getSpawns().func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners((EntityType)EntityRegistry.STALKER.get(), 1, 1, 4));
        }
        if (event.getName().equals((Object)new ResourceLocation("minecraft:small_end_islands"))) {
            event.getGeneration().getFeatures(GenerationStage.Decoration.RAW_GENERATION).add(() -> FeatureRegistry.CRAG_MOON_OUTSIDE_FEATURE);
        }
    }

    public void addDimensionalSpacing(WorldEvent.Load event) {
        if (event.getWorld() instanceof ServerWorld) {
            ServerWorld serverWorld = (ServerWorld)event.getWorld();
            if (serverWorld.func_72863_F().func_201711_g() instanceof FlatChunkGenerator && serverWorld.func_234923_W_().equals(World.field_234918_g_)) {
                return;
            }
            if (serverWorld.func_234923_W_().func_240901_a_().equals((Object)new ResourceLocation("minecraft:the_end"))) {
                HashMap<IForgeRegistryEntry, Object> tempMap = new HashMap<IForgeRegistryEntry, Object>(serverWorld.func_72863_F().field_186029_c.func_235957_b_().func_236195_a_());
                tempMap.put(StructureRegistry.END_TOWER.get(), DimensionStructuresSettings.field_236191_b_.get((Object)StructureRegistry.END_TOWER.get()));
                tempMap.put(StructureRegistry.CATACOMBS.get(), DimensionStructuresSettings.field_236191_b_.get((Object)StructureRegistry.CATACOMBS.get()));
                serverWorld.func_72863_F().field_186029_c.func_235957_b_().field_236193_d_ = tempMap;
            }
        }
    }

    private static LootEntry getInjectEntry(ResourceLocation location, int weight, int quality) {
        return TableLootEntry.func_216171_a((ResourceLocation)location).func_216086_a(weight).func_216085_b(quality).func_216081_b();
    }

    private static void addEntry(LootPool pool, LootEntry entry) throws IllegalAccessException {
        List lootEntries = (List)ObfuscationReflectionHelper.findField(LootPool.class, (String)"field_186453_a").get(pool);
        if (lootEntries.stream().anyMatch(e -> e == entry)) {
            throw new RuntimeException("Attempted to add a duplicate entry to pool: " + entry);
        }
        lootEntries.add(entry);
    }

    static {
        HELPER = new RegistryHelper("outer_end");
        DEVS = new ArrayList();
    }

    @Mod.EventBusSubscriber(modid="outer_end")
    public static class LootEvents {
        @SubscribeEvent
        public static void onLootLoad(LootTableLoadEvent event) throws IllegalAccessException {
            LootPool pool;
            ResourceLocation name = event.getName();
            if (name.equals((Object)new ResourceLocation("minecraft", "chests/end_city_treasure")) && (pool = event.getTable().getPool("main")) != null) {
                OuterEndMod.addEntry(pool, OuterEndMod.getInjectEntry(new ResourceLocation("outer_end:chests/end_city_treasure"), 10, 0));
            }
        }
    }

    @Mod.EventBusSubscriber(modid="outer_end", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientEventBusSubscriber {
        @SubscribeEvent
        public void onPostRegisterEntities(RegistryEvent.Register<EntityType<?>> event) {
            OuterEndSpawnEgg.doDispenserSetup();
        }

        @SubscribeEvent
        public void onItemColorEvent(ColorHandlerEvent.Item event) {
            for (SpawnEggItem spawnEggItem : OuterEndSpawnEgg.OUTER_END_SPAWN_EGGS) {
                event.getItemColors().func_199877_a((stack, i) -> egg.func_195983_a(i), new IItemProvider[]{spawnEggItem});
            }
        }
    }
}

