/*
 * Decompiled with CFR 0.152.
 */
package net.arcanecitadel.morepaths.registries;

import java.util.HashMap;
import net.arcanecitadel.morepaths.blocks.OtherPathBlock;
import net.arcanecitadel.morepaths.config.ServerConfig;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.GrassPathBlock;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class BlockRegistry {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"morepaths");
    public static final RegistryObject<Block> GRAVEL_PATH = BLOCKS.register("gravel_path", () -> BlockRegistry.createBlock(Blocks.field_150351_n));
    public static final RegistryObject<Block> COARSE_DIRT_PATH = BLOCKS.register("coarse_dirt_path", () -> BlockRegistry.createBlock(Blocks.field_196660_k));
    public static final RegistryObject<Block> SAND_PATH = BLOCKS.register("sand_path", () -> BlockRegistry.createBlock(Blocks.field_150354_m));
    public static final RegistryObject<Block> SNOW_PATH = BLOCKS.register("snow_path", () -> BlockRegistry.createBlock(Blocks.field_196604_cC));
    public static final RegistryObject<Block> RED_SAND_PATH = BLOCKS.register("red_sand_path", () -> BlockRegistry.createBlock(Blocks.field_196611_F));
    public static final RegistryObject<Block> PODZOL_PATH = BLOCKS.register("podzol_path", () -> BlockRegistry.createBlock(Blocks.field_196661_l));
    public static final RegistryObject<Block> MYCELIUM_PATH = BLOCKS.register("mycelium_path", () -> BlockRegistry.createBlock(Blocks.field_150391_bh));
    public static final RegistryObject<Block> CRIMSON_GRASS_PATH = BLOCKS.register("crimson_nylium_path", () -> BlockRegistry.createBlock(Blocks.field_235381_mu_));
    public static final RegistryObject<Block> WARPED_GRASS_PATH = BLOCKS.register("warped_nylium_path", () -> BlockRegistry.createBlock(Blocks.field_235372_ml_));
    static HashMap<Block, GrassPathBlock> ALL_PATHS = new HashMap();

    private static OtherPathBlock createBlock(Block fromBlock) {
        OtherPathBlock regBlock = new OtherPathBlock(fromBlock);
        ALL_PATHS.put(fromBlock, regBlock);
        return regBlock;
    }

    public static Block getPathForBlock(Block fromBlock) {
        if (!ServerConfig.getPathTypeEnabled(fromBlock).booleanValue()) {
            return null;
        }
        GrassPathBlock path = ALL_PATHS.get(fromBlock);
        return path;
    }

    public static void registerDirtAsPathable() {
        ALL_PATHS.put(Blocks.field_150346_d, (GrassPathBlock)Blocks.field_185774_da);
    }
}

