/*
 * Decompiled with CFR 0.152.
 */
package net.arcanecitadel.morepaths.blocks;

import java.util.Random;
import net.arcanecitadel.morepaths.registries.BlockRegistry;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.FallingBlock;
import net.minecraft.block.GrassPathBlock;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class OtherPathBlock
extends GrassPathBlock {
    private Block _pathedFrom;
    private boolean _isFallingBlock;

    public OtherPathBlock(Block pathedFrom) {
        super(OtherPathBlock.getProperties(pathedFrom));
        this._pathedFrom = pathedFrom;
        this._isFallingBlock = pathedFrom instanceof FallingBlock;
    }

    private static AbstractBlock.Properties getProperties(Block pathedFrom) {
        BlockState state = pathedFrom.func_176223_P();
        AbstractBlock.Properties newPathProperties = AbstractBlock.Properties.func_200949_a((Material)state.func_185904_a(), (MaterialColor)state.func_185909_g(null, null)).func_200943_b(state.func_185887_b(null, null)).func_200947_a(state.func_215695_r()).harvestTool(ToolType.SHOVEL);
        return newPathProperties;
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (this.checkIfFalling(worldIn, currentPos)) {
            worldIn.func_205220_G_().func_205360_a(currentPos, (Object)this, 1);
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
        worldIn.func_175656_a(pos, OtherPathBlock.func_199601_a((BlockState)state, (BlockState)this._pathedFrom.func_176223_P(), (World)worldIn, (BlockPos)pos));
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return !this.func_176223_P().func_196955_c((IWorldReader)context.func_195991_k(), context.func_195995_a()) ? Block.func_199601_a((BlockState)this.func_176223_P(), (BlockState)this._pathedFrom.func_176223_P(), (World)context.func_195991_k(), (BlockPos)context.func_195995_a()) : super.func_196258_a(context);
    }

    private boolean checkIfFalling(IWorld worldIn, BlockPos currentPos) {
        if (!this._isFallingBlock) {
            return false;
        }
        return worldIn.func_175623_d(currentPos.func_177977_b()) || FallingBlock.func_185759_i((BlockState)worldIn.func_180495_p(currentPos.func_177977_b())) && currentPos.func_177956_o() >= 0;
    }

    @SubscribeEvent
    public static void doPlayerHarvestCheck(PlayerEvent.HarvestCheck harvestEvent) {
        PlayerEntity p = harvestEvent.getPlayer();
        BlockState block = harvestEvent.getTargetBlock();
        Block snowPath = (Block)BlockRegistry.SNOW_PATH.get();
        if (block.func_177230_c() != snowPath) {
            return;
        }
        ItemStack held = p.func_184614_ca();
        Item item = held.func_77973_b();
        boolean isShovel = item.getToolTypes(held).contains(ToolType.SHOVEL);
        if (!isShovel) {
            return;
        }
        harvestEvent.setCanHarvest(true);
    }
}

