/*
 * Decompiled with CFR 0.152.
 */
package net.arcanecitadel.morepaths;

import net.arcanecitadel.morepaths.registries.BlockRegistry;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ShovelInteraction {
    @SubscribeEvent
    public static void onRightClick(PlayerInteractEvent.RightClickBlock event) {
        PlayerEntity p = event.getPlayer();
        ItemStack held = p.func_184614_ca();
        Item item = held.func_77973_b();
        boolean isShovel = item.getToolTypes(held).contains(ToolType.SHOVEL);
        if (!isShovel) {
            return;
        }
        Direction facing = event.getFace();
        if (facing == null) {
            return;
        }
        BlockPos pos = event.getPos();
        boolean playerCanEditBlock = p.func_175151_a(pos.func_177972_a(facing), facing, held);
        if (!playerCanEditBlock) {
            return;
        }
        World world = event.getWorld();
        Material blockAbove = world.func_180495_p(pos.func_177984_a()).func_185904_a();
        if (blockAbove != Material.field_151579_a) {
            return;
        }
        Block targetBlock = world.func_180495_p(pos).func_177230_c();
        Block pathBlock = BlockRegistry.getPathForBlock(targetBlock);
        if (pathBlock == null) {
            return;
        }
        world.func_184133_a(p, pos, SoundEvents.field_187771_eN, SoundCategory.BLOCKS, 1.0f, 1.0f);
        if (!world.field_72995_K) {
            world.func_175656_a(event.getPos(), pathBlock.func_176223_P());
            held.func_222118_a(1, (LivingEntity)p, pl -> pl.func_213361_c(EquipmentSlotType.MAINHAND));
        }
        event.setCanceled(true);
        event.setCancellationResult(ActionResultType.SUCCESS);
    }
}

