/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.tile;

import com.google.common.collect.Maps;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.fml.common.thread.EffectiveSide;
import net.minecraftforge.registries.ForgeRegistries;
import snownee.kiwi.client.model.TextureModel;
import snownee.kiwi.tile.BaseTile;
import snownee.kiwi.util.NBTHelper;
import snownee.kiwi.util.Util;

public class TextureTile
extends BaseTile {
    @Nullable
    protected Map<String, String> textures;
    @Nullable
    protected Map<String, Item> marks;
    protected IModelData modelData;

    public TextureTile(TileEntityType<?> tileEntityTypeIn, String ... textureKeys) {
        super(tileEntityTypeIn);
        this.persistData = true;
        this.textures = textureKeys.length == 0 ? null : Maps.newHashMapWithExpectedSize((int)textureKeys.length);
        for (String key : textureKeys) {
            this.textures.put(key, "");
        }
        if (EffectiveSide.get().isClient()) {
            this.modelData = this.textures == null ? EmptyModelData.INSTANCE : new ModelDataMap.Builder().withInitial(TextureModel.TEXTURES, this.textures).build();
        }
    }

    public void setTexture(String key, String path) {
        TextureTile.setTexture(this.textures, key, path);
    }

    public static void setTexture(Map<String, String> textures, String key, String path) {
        if (!textures.containsKey(key)) {
            return;
        }
        textures.put(key, path);
    }

    public void setTexture(String key, BlockState state) {
        TextureTile.setTexture(this.textures, key, state);
        if (this.isMark(key)) {
            Item item = state.func_177230_c().func_199767_j();
            if (item == Items.field_190931_a) {
                return;
            }
            if (this.marks == null) {
                this.marks = Maps.newHashMap();
            }
            this.marks.put(key, item);
        }
    }

    public static void setTexture(Map<String, String> textures, String key, BlockState state) {
        if (textures == null || !textures.containsKey(key)) {
            return;
        }
        if (EffectiveSide.get().isServer()) {
            String value = NBTUtil.func_190009_a((BlockState)state).toString();
            textures.put(key, value);
        } else {
            textures.put(key, TextureTile.getTextureFromState(state));
        }
    }

    public void setTexture(String key, Item item) {
        TextureTile.setTexture(this.textures, key, item);
        if (this.isMark(key)) {
            if (this.marks == null) {
                this.marks = Maps.newHashMap();
            }
            this.marks.put(key, item);
        }
    }

    public static void setTexture(Map<String, String> textures, String key, Item item) {
        Block block = Block.func_149634_a((Item)item);
        if (block != null) {
            TextureTile.setTexture(textures, key, block.func_176223_P());
        }
    }

    public Item getMark(String key) {
        return this.marks == null ? Items.field_190931_a : this.marks.getOrDefault(key, Items.field_190931_a);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static String getTextureFromState(BlockState state) {
        return Util.trimRL(Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178122_a(state).func_195668_m());
    }

    @Override
    public void refresh() {
        if (this.field_145850_b != null && this.field_145850_b.field_72995_K) {
            this.requestModelDataUpdate();
        } else {
            super.refresh();
        }
    }

    public void onLoad() {
        super.requestModelDataUpdate();
    }

    public void requestModelDataUpdate() {
        if (this.textures == null) {
            return;
        }
        super.requestModelDataUpdate();
        if (this.field_145850_b != null && this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 8);
        }
    }

    @Override
    protected void readPacketData(CompoundNBT data) {
        if (!data.func_150297_b("Textures", 10)) {
            return;
        }
        boolean shouldRefresh = TextureTile.readTextures(this.textures, data.func_74775_l("Textures"));
        if (data.func_150297_b("Items", 10)) {
            NBTHelper helper = NBTHelper.of(data.func_74775_l("Items"));
            for (String k : helper.keySet("")) {
                Item item;
                ResourceLocation locator;
                if (!this.isMark(k)) continue;
                if (this.marks == null) {
                    this.marks = Maps.newHashMap();
                }
                if ((locator = ResourceLocation.func_208304_a((String)helper.getString(k))) == null || (item = (Item)ForgeRegistries.ITEMS.getValue(locator)) == null) continue;
                this.marks.put(k, item);
            }
        }
        if (shouldRefresh) {
            this.refresh();
        }
    }

    public static boolean readTextures(Map<String, String> textures, CompoundNBT data) {
        if (textures == null) {
            return false;
        }
        boolean shouldRefresh = false;
        NBTHelper helper = NBTHelper.of(data);
        for (String k : textures.keySet()) {
            String v = helper.getString(k);
            if (v == null) continue;
            if (EffectiveSide.get().isClient() && v.startsWith("{")) {
                try {
                    CompoundNBT stateNbt = JsonToNBT.func_180713_a((String)v);
                    BlockState state = NBTUtil.func_190008_d((CompoundNBT)stateNbt);
                    v = TextureTile.getTextureFromState(state);
                }
                catch (CommandSyntaxException e) {
                    continue;
                }
            }
            if (textures.get(k).equals(v)) continue;
            shouldRefresh = true;
            textures.put(k, v);
        }
        return shouldRefresh;
    }

    public boolean isMark(String key) {
        return false;
    }

    @Override
    protected CompoundNBT writePacketData(CompoundNBT data) {
        TextureTile.writeTextures(this.textures, data);
        if (this.marks != null) {
            NBTHelper helper = NBTHelper.of(data);
            this.marks.forEach((k, v) -> {
                if (this.isMark((String)k)) {
                    helper.setString("Items." + k, Util.trimRL(v.getRegistryName()));
                }
            });
        }
        return data;
    }

    public static CompoundNBT writeTextures(Map<String, String> textures, CompoundNBT data) {
        if (textures != null) {
            NBTHelper tag = NBTHelper.of(data);
            textures.forEach((k, v) -> tag.setString("Textures." + k, (String)v));
        }
        return data;
    }

    public IModelData getModelData() {
        return this.modelData;
    }
}

