/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.contributor.network;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import snownee.kiwi.contributor.Contributors;
import snownee.kiwi.network.NetworkChannel;
import snownee.kiwi.network.Packet;
import snownee.kiwi.util.Util;

public class SSyncEffectPacket
extends Packet {
    private final Map<String, ResourceLocation> map;

    public SSyncEffectPacket(Map<String, ResourceLocation> map) {
        this.map = map;
    }

    public void sendExcept(ServerPlayerEntity player) {
        NetworkChannel.sendToAllExcept(player, this);
    }

    public static class Handler
    extends Packet.PacketHandler<SSyncEffectPacket> {
        @Override
        public void encode(SSyncEffectPacket msg, PacketBuffer buffer) {
            buffer.func_150787_b(msg.map.size());
            msg.map.forEach((k, v) -> {
                buffer.func_180714_a(k);
                buffer.func_192572_a(v);
            });
        }

        @Override
        public SSyncEffectPacket decode(PacketBuffer buffer) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            int size = buffer.func_150792_a();
            for (int i = 0; i < size; ++i) {
                String k = buffer.func_218666_n();
                String v = buffer.func_218666_n();
                builder.put((Object)k, (Object)Util.RL(v));
            }
            return new SSyncEffectPacket((Map<String, ResourceLocation>)builder.build());
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public void handle(SSyncEffectPacket msg, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> Contributors.changeEffect(msg.map));
            ctx.get().setPacketHandled(true);
        }

        @Override
        public NetworkDirection direction() {
            return NetworkDirection.PLAY_TO_CLIENT;
        }
    }
}

