/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Arrays;
import java.util.List;
import mcp.mobius.waila.gui.config.OptionsListWidget;
import mcp.mobius.waila.gui.config.value.OptionsEntryValue;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public abstract class GuiOptions
extends Screen {
    private final Screen parent;
    private final Runnable saver;
    private final Runnable canceller;
    private OptionsListWidget options;

    public GuiOptions(Screen parent, ITextComponent title, Runnable saver, Runnable canceller) {
        super(title);
        this.parent = parent;
        this.saver = saver;
        this.canceller = canceller;
    }

    public GuiOptions(Screen parent, String title, Runnable saver, Runnable canceller) {
        this(parent, OptionsListWidget.Entry.makeTitle(title), saver, canceller);
    }

    public GuiOptions(Screen parent, String title) {
        this(parent, title, null, null);
    }

    public void func_231158_b_(Minecraft client, int width, int height) {
        super.func_231158_b_(client, width, height);
        this.options = this.getOptions();
        this.field_230705_e_.add(this.options);
        this.func_231035_a_((IGuiEventListener)this.options);
        if (this.saver != null && this.canceller != null) {
            this.func_230480_a_((Widget)new Button(width / 2 - 100, height - 25, 100, 20, (ITextComponent)new TranslationTextComponent("gui.done"), w -> {
                this.options.save();
                this.saver.run();
                this.field_230706_i_.func_147108_a(this.parent);
            }));
            this.func_230480_a_((Widget)new Button(width / 2 + 5, height - 25, 100, 20, (ITextComponent)new TranslationTextComponent("gui.cancel"), w -> {
                this.canceller.run();
                this.field_230706_i_.func_147108_a(this.parent);
            }));
        } else {
            this.func_230480_a_((Widget)new Button(width / 2 - 50, height - 25, 100, 20, (ITextComponent)new TranslationTextComponent("gui.done"), w -> {
                this.options.save();
                this.field_230706_i_.func_147108_a(this.parent);
            }));
        }
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        OptionsEntryValue value;
        this.func_230446_a_(matrixStack);
        this.options.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        GuiOptions.func_238472_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (ITextComponent)this.field_230704_d_, (int)(this.field_230708_k_ / 2), (int)12, (int)0xFFFFFF);
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        if (mouseY < 32 || mouseY > this.field_230709_l_ - 32) {
            return;
        }
        OptionsListWidget.Entry entry = (OptionsListWidget.Entry)this.options.func_230958_g_();
        if (entry instanceof OptionsEntryValue && I18n.func_188566_a((String)(value = (OptionsEntryValue)entry).getDescription())) {
            int valueX = value.getX() + 10;
            String title = value.getTitle().getString();
            if (mouseX < valueX || mouseX > valueX + this.field_230712_o_.func_78256_a(title)) {
                return;
            }
            List<IReorderingProcessor> tooltip = Arrays.asList(new StringTextComponent(title).func_241878_f());
            tooltip.addAll(this.field_230712_o_.func_238425_b_((ITextProperties)new TranslationTextComponent(value.getDescription()), 200));
            this.func_238654_b_(matrixStack, tooltip, mouseX, mouseY);
        }
    }

    public IGuiEventListener func_230481_d_(IGuiEventListener listener) {
        this.field_230705_e_.add(listener);
        return listener;
    }

    public abstract OptionsListWidget getOptions();

    public boolean func_231043_a_(double mouseX, double mouseY, double delta) {
        return this.options.func_231043_a_(mouseX, mouseY, delta);
    }

    public void func_231175_as__() {
        if (this.canceller != null) {
            this.canceller.run();
        }
        super.func_231175_as__();
    }
}

