/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.jeitweaker.zen.recipe;

import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import com.blamejared.jeitweaker.zen.category.JeiCategory;
import com.blamejared.jeitweaker.zen.component.RawJeiIngredient;
import com.blamejared.jeitweaker.zen.recipe.RecipeGraphics;
import java.util.Arrays;
import java.util.function.Consumer;
import org.openzen.zencode.java.ZenCodeType;

@Document(value="mods/JEITweaker/API/Recipe/JeiRecipe")
@ZenCodeType.Name(value="mods.jei.recipe.JeiRecipe")
@ZenRegister
public final class JeiRecipe {
    private final JeiCategory owningCategory;
    private final RawJeiIngredient[][] inputs;
    private final RawJeiIngredient[][] outputs;
    private final Consumer<RecipeGraphics> graphics;

    JeiRecipe(JeiCategory owningCategory, RawJeiIngredient[][] inputs, RawJeiIngredient[][] outputs, Consumer<RecipeGraphics> graphics) {
        this.owningCategory = owningCategory;
        this.inputs = inputs;
        this.outputs = outputs;
        this.graphics = graphics;
    }

    public JeiCategory getOwningCategory() {
        return this.owningCategory;
    }

    public RawJeiIngredient[][] getInputs() {
        return this.inputs;
    }

    public RawJeiIngredient[][] getOutputs() {
        return this.outputs;
    }

    public void doGraphics(RecipeGraphics graphics) {
        this.graphics.accept(graphics);
    }

    public String toString() {
        return String.format("JeiRecipe[category='%s',outputs=%s,inputs=%s]", this.owningCategory, Arrays.deepToString((Object[])this.outputs), Arrays.deepToString((Object[])this.inputs));
    }
}

