/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.jeitweaker.zen.component;

import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import com.blamejared.jeitweaker.library.ninepatch.NinePatchDrawable;
import com.blamejared.jeitweaker.zen.component.JeiDrawableAnimation;
import com.blamejared.jeitweaker.zen.component.RawJeiIngredient;
import java.util.function.Function;
import java.util.function.Supplier;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.helpers.IGuiHelper;
import net.minecraft.util.ResourceLocation;
import org.openzen.zencode.java.ZenCodeType;

@Document(value="mods/JEITweaker/API/Component/JeiDrawable")
@ZenCodeType.Name(value="mods.jei.component.JeiDrawable")
@ZenRegister
public final class JeiDrawable {
    private volatile Function<IGuiHelper, IDrawable> delegate;
    private volatile IDrawable content;

    private JeiDrawable(Function<IGuiHelper, IDrawable> delegate) {
        this.delegate = delegate;
    }

    @ZenCodeType.Method
    public static JeiDrawable blank(int width, int height) {
        return new JeiDrawable(helper -> helper.createBlankDrawable(width, height));
    }

    @ZenCodeType.Method
    public static JeiDrawable of(RawJeiIngredient ingredient) {
        return new JeiDrawable(helper -> helper.createDrawableIngredient(ingredient.cast().getType().toJeiType(ingredient.cast().getWrapped())));
    }

    @ZenCodeType.Method
    public static JeiDrawable of(ResourceLocation texture, int u, int v, int width, int height) {
        return new JeiDrawable(helper -> helper.createDrawable(texture, u, v, width, height));
    }

    @ZenCodeType.Method
    public static JeiDrawable ofAnimated(JeiDrawable delegate, int ticks, JeiDrawableAnimation animation) {
        return new JeiDrawable(helper -> helper.createAnimatedDrawable((IDrawableStatic)delegate.getDrawable((IGuiHelper)helper), ticks, animation.direction(), animation.inverted()));
    }

    @ZenCodeType.Method
    public static JeiDrawable ofAnimated(ResourceLocation texture, int u, int v, int width, int height, int ticks, JeiDrawableAnimation animation) {
        return JeiDrawable.ofAnimated(JeiDrawable.of(texture, u, v, width, height), ticks, animation);
    }

    @ZenCodeType.Method
    public static JeiDrawable ofNinePatch(ResourceLocation texture, int u, int v, int width, int height, int expectedWidth, int expectedHeight) {
        return new JeiDrawable(ignore -> NinePatchDrawable.of(texture, u, v, width, height, expectedWidth, expectedHeight));
    }

    public static JeiDrawable of(Supplier<IDrawable> drawableSupplier) {
        return new JeiDrawable(ignore -> (IDrawable)drawableSupplier.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IDrawable getDrawable(IGuiHelper helper) {
        if (this.content == null) {
            JeiDrawable jeiDrawable = this;
            synchronized (jeiDrawable) {
                if (this.content == null) {
                    this.content = this.delegate.apply(helper);
                    this.delegate = null;
                }
            }
        }
        return this.content;
    }
}

