/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.jeitweaker.zen.category;

import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.api.logger.ILogger;
import com.blamejared.crafttweaker.impl.util.text.MCTextComponent;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import com.blamejared.jeitweaker.api.IngredientType;
import com.blamejared.jeitweaker.zen.category.JeiCategory;
import com.blamejared.jeitweaker.zen.component.JeiDrawable;
import com.blamejared.jeitweaker.zen.component.RawJeiIngredient;
import com.blamejared.jeitweaker.zen.recipe.JeiRecipe;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import net.minecraft.util.ResourceLocation;
import org.openzen.zencode.java.ZenCodeType;

@Document(value="mods/JEITweaker/API/Category/SimpleJeiCategory")
@ZenCodeType.Name(value="mods.jei.category.SimpleJeiCategory")
@ZenRegister
public abstract class SimpleJeiCategory
implements JeiCategory {
    static final ResourceLocation GUI_ATLAS = new ResourceLocation("jeitweaker", "textures/gui/jei/atlas.png");
    private final ResourceLocation id;
    private final MCTextComponent name;
    private final JeiDrawable icon;
    private final RawJeiIngredient[] catalysts;
    private List<JeiRecipe> recipes;

    public SimpleJeiCategory(ResourceLocation id, MCTextComponent name, JeiDrawable icon, RawJeiIngredient ... catalysts) {
        this.id = id;
        this.name = name;
        this.icon = icon;
        this.catalysts = catalysts;
    }

    @Override
    public final ResourceLocation id() {
        return this.id;
    }

    @Override
    public final MCTextComponent name() {
        return this.name;
    }

    @Override
    public final JeiDrawable icon() {
        return this.icon;
    }

    @Override
    public final RawJeiIngredient[] catalysts() {
        return this.catalysts;
    }

    @Override
    public void addRecipe(JeiRecipe recipe) {
        (this.recipes == null ? (this.recipes = new ArrayList<JeiRecipe>()) : this.recipes).add(recipe);
    }

    @Override
    public List<JeiRecipe> getTargetRecipes() {
        return this.recipes == null ? Collections.emptyList() : this.recipes;
    }

    @Override
    public BiPredicate<JeiRecipe, ILogger> getRecipeValidator() {
        return (recipe, logger) -> {
            this.verifyNoMixedSlotsIn((ILogger)logger, recipe.getInputs(), () -> "inputs of recipe " + recipe);
            this.verifyNoMixedSlotsIn((ILogger)logger, recipe.getOutputs(), () -> "outputs of recipe " + recipe);
            return true;
        };
    }

    public String toString() {
        return String.format("JeiCategory[id='%s',type=%s]", this.id, this.getClass().getSimpleName());
    }

    private void verifyNoMixedSlotsIn(ILogger logger, RawJeiIngredient[][] slots, Supplier<String> in) {
        Arrays.stream(slots).forEach(slot -> {
            if (((RawJeiIngredient[])slot).length > 1) {
                IngredientType first = slot[0].cast().getType();
                long mismatchingTypes = Arrays.stream(slot, 1, ((RawJeiIngredient[])slot).length).filter(it -> it.cast().getType() != first).count();
                if (mismatchingTypes > 0L) {
                    logger.warning(String.format("Found multiple ingredients in %s of different types: this might not work", in.get()));
                }
            }
        });
    }
}

