/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.jeitweaker.zen.category;

import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.api.logger.ILogger;
import com.blamejared.crafttweaker.impl.util.text.MCTextComponent;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import com.blamejared.jeitweaker.bridge.JeiCategoryPluginBridge;
import com.blamejared.jeitweaker.bridge.OutputListCategoryBridge;
import com.blamejared.jeitweaker.zen.category.SimpleJeiCategory;
import com.blamejared.jeitweaker.zen.component.JeiDrawable;
import com.blamejared.jeitweaker.zen.component.RawJeiIngredient;
import com.blamejared.jeitweaker.zen.recipe.JeiRecipe;
import com.google.common.base.Suppliers;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import net.minecraft.util.ResourceLocation;
import org.openzen.zencode.java.ZenCodeType;

@Document(value="mods/JEITweaker/API/Category/OutputList")
@ZenCodeType.Name(value="mods.jei.category.OutputList")
@ZenRegister
public final class OutputListCategory
extends SimpleJeiCategory {
    private final Supplier<JeiDrawable> backgroundSupplier = Suppliers.memoize(() -> JeiDrawable.ofNinePatch(GUI_ATLAS, 92, 0, 164, 20, 162, 18 * this.rows));
    private int rows = 1;

    public OutputListCategory(ResourceLocation id, MCTextComponent name, JeiDrawable icon, RawJeiIngredient ... catalysts) {
        super(id, name, icon, catalysts);
    }

    @ZenCodeType.Setter(value="rows")
    public void setRows(int rows) {
        this.rows = Math.max(1, rows);
    }

    @Override
    public JeiDrawable background() {
        return this.backgroundSupplier.get();
    }

    @Override
    public BiPredicate<JeiRecipe, ILogger> getRecipeValidator() {
        BiPredicate<JeiRecipe, ILogger> validator = (recipe, logger) -> {
            if (recipe.getInputs().length != 0) {
                logger.warning("Recipe " + recipe + " has inputs: they will be ignored in OutputList");
            }
            if (recipe.getOutputs().length > this.rows * 9) {
                logger.error(String.format("Recipe %s has %d outputs, but only %d are supported with this configuration of OutputList", recipe, recipe.getOutputs().length, this.rows * 9));
                return false;
            }
            return true;
        };
        return validator.and(super.getRecipeValidator());
    }

    @Override
    public Supplier<JeiCategoryPluginBridge> getBridgeCreator() {
        return () -> new OutputListCategoryBridge(() -> this.rows);
    }
}

