/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.jeitweaker.zen.category;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.api.logger.ILogger;
import com.blamejared.crafttweaker.impl.util.text.MCTextComponent;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import com.blamejared.jeitweaker.bridge.CatalystRequiringRecipeCategoryBridge;
import com.blamejared.jeitweaker.bridge.JeiCategoryPluginBridge;
import com.blamejared.jeitweaker.zen.category.SimpleJeiCategory;
import com.blamejared.jeitweaker.zen.component.JeiDrawable;
import com.blamejared.jeitweaker.zen.component.RawJeiIngredient;
import com.blamejared.jeitweaker.zen.recipe.JeiRecipe;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import net.minecraft.util.ResourceLocation;
import org.openzen.zencode.java.ZenCodeType;

@Document(value="mods/JEITweaker/API/Category/CatalystRequiringRecipe")
@ZenCodeType.Name(value="mods.jei.category.CatalystRequiringRecipe")
@ZenRegister
public final class CatalystRequiringRecipeCategory
extends SimpleJeiCategory {
    private static final JeiDrawable BACKGROUND = JeiDrawable.of(GUI_ATLAS, 94, 69, 162, 44);
    private static final JeiDrawable SLOT_COVER = JeiDrawable.of(GUI_ATLAS, 154, 238, 18, 18);
    private static final int MAX_INPUTS = 3;
    private static final int MAX_OUTPUTS = 3;
    private JeiDrawable catalystDrawable = null;
    private int inputs = 1;
    private int outputs = 1;

    public CatalystRequiringRecipeCategory(ResourceLocation id, MCTextComponent name, JeiDrawable icon, RawJeiIngredient ... catalysts) {
        super(id, name, icon, catalysts);
    }

    @ZenCodeType.Setter(value="catalystDrawable")
    public void setCatalystDrawable(@ZenCodeType.Nullable JeiDrawable catalystDrawable) {
        this.catalystDrawable = catalystDrawable;
    }

    @ZenCodeType.Setter(value="inputs")
    public void setInputs(int inputs) {
        if (inputs <= 0) {
            CraftTweakerAPI.logError((String)"Unable to use a CatalystRequiringRecipe without any input", (Object[])new Object[0]);
            return;
        }
        if (inputs > 3) {
            CraftTweakerAPI.logError((String)"Unable to set inputs of a CatalystRequiringRecipe to {}: max is {}", (Object[])new Object[]{inputs, 3});
            return;
        }
        this.inputs = inputs;
    }

    @ZenCodeType.Setter(value="outputs")
    public void setOutputs(int outputs) {
        if (outputs <= 0) {
            CraftTweakerAPI.logError((String)"Unable to use a CatalystRequiringRecipe without any output", (Object[])new Object[0]);
            return;
        }
        if (outputs > 3) {
            CraftTweakerAPI.logError((String)"Unable to set outputs of a CatalystRequiringRecipe to {}: max is {}", (Object[])new Object[]{outputs, 3});
            return;
        }
        this.outputs = outputs;
    }

    @Override
    public JeiDrawable background() {
        return BACKGROUND;
    }

    @Override
    public BiPredicate<JeiRecipe, ILogger> getRecipeValidator() {
        boolean hasCatalyst = this.catalystDrawable == null;
        BiPredicate<JeiRecipe, ILogger> validator = (recipe, logger) -> {
            if (recipe.getOutputs().length > this.outputs) {
                logger.error("Recipe " + recipe + " has " + recipe.getOutputs().length + " outputs: expected " + this.outputs);
                return false;
            }
            if (recipe.getInputs().length > this.inputs + (hasCatalyst ? 1 : 0)) {
                logger.error("Recipe " + recipe + " has " + recipe.getInputs().length + " outputs: expected " + this.inputs);
                return false;
            }
            if (hasCatalyst && recipe.getInputs().length == 1) {
                logger.error("Recipe " + recipe + " specifies only a catalyst and no inputs");
                return false;
            }
            return true;
        };
        return validator.and(super.getRecipeValidator());
    }

    @Override
    public Supplier<JeiCategoryPluginBridge> getBridgeCreator() {
        return () -> new CatalystRequiringRecipeCategoryBridge(SLOT_COVER, this.catalystDrawable, this.inputs, this.outputs, 3, 3);
    }
}

