/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.jeitweaker.zen;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.actions.IAction;
import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.api.fluid.IFluidStack;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.managers.IRecipeManager;
import com.blamejared.crafttweaker.impl.util.text.MCTextComponent;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import com.blamejared.jeitweaker.actions.ActionAddInfo;
import com.blamejared.jeitweaker.actions.ActionAddIngredient;
import com.blamejared.jeitweaker.actions.ActionAddRecipeCategory;
import com.blamejared.jeitweaker.actions.ActionHideCategory;
import com.blamejared.jeitweaker.actions.ActionHideIngredient;
import com.blamejared.jeitweaker.actions.ActionHideMod;
import com.blamejared.jeitweaker.actions.ActionHideRecipe;
import com.blamejared.jeitweaker.actions.ActionHideRegex;
import com.blamejared.jeitweaker.zen.category.JeiCategory;
import com.blamejared.jeitweaker.zen.component.IFluidStackExpansions;
import com.blamejared.jeitweaker.zen.component.IItemStackExpansions;
import com.blamejared.jeitweaker.zen.component.RawJeiIngredient;
import java.util.Arrays;
import net.minecraft.util.ResourceLocation;
import org.openzen.zencode.java.ZenCodeType;

@Document(value="mods/JEITweaker/API/JEI")
@ZenCodeType.Name(value="mods.jei.JEI")
@ZenRegister
public final class JeiManager {
    @ZenCodeType.Method
    public static void addCategory(JeiCategory category) {
        CraftTweakerAPI.apply((IAction)new ActionAddRecipeCategory(category));
    }

    @ZenCodeType.Method
    public static void addDescription(RawJeiIngredient ingredient, MCTextComponent ... description) {
        CraftTweakerAPI.apply(new ActionAddInfo(ingredient.cast(), description));
    }

    @ZenCodeType.Method
    public static void addIngredient(RawJeiIngredient ingredient) {
        CraftTweakerAPI.apply(new ActionAddIngredient(ingredient.cast()));
    }

    @Deprecated
    @ZenCodeType.Method
    public static void addItem(IItemStack stack) {
        JeiManager.addIngredient(IItemStackExpansions.asJeiIngredient(stack));
    }

    @Deprecated
    @ZenCodeType.Method
    public static void addInfo(IItemStack stack, String ... description) {
        JeiManager.addDescription(IItemStackExpansions.asJeiIngredient(stack), (MCTextComponent[])Arrays.stream(description).map(MCTextComponent::createTranslationTextComponent).toArray(MCTextComponent[]::new));
    }

    @Deprecated
    @ZenCodeType.Method
    public static void addInfo(IFluidStack stack, String ... description) {
        JeiManager.addDescription(IFluidStackExpansions.asJeiIngredient(stack), (MCTextComponent[])Arrays.stream(description).map(MCTextComponent::createTranslationTextComponent).toArray(MCTextComponent[]::new));
    }

    @ZenCodeType.Method
    public static void hideCategory(String category) {
        CraftTweakerAPI.apply((IAction)new ActionHideCategory(new ResourceLocation(category)));
    }

    @ZenCodeType.Method
    public static void hideIngredient(RawJeiIngredient ingredient) {
        CraftTweakerAPI.apply(new ActionHideIngredient(ingredient.cast()));
    }

    @ZenCodeType.Method
    public static void hideMod(String modId, @ZenCodeType.Optional(value="(name as string) => {return false;}") IRecipeManager.RecipeFilter exclude) {
        CraftTweakerAPI.apply((IAction)new ActionHideMod(modId, exclude));
    }

    @ZenCodeType.Method
    public static void hideRecipe(String categoryId, String recipeName) {
        CraftTweakerAPI.apply((IAction)new ActionHideRecipe(new ResourceLocation(categoryId), new ResourceLocation(recipeName)));
    }

    @ZenCodeType.Method
    public static void hideRegex(String regex) {
        CraftTweakerAPI.apply((IAction)new ActionHideRegex(regex));
    }

    @Deprecated
    @ZenCodeType.Method
    public static void hideItem(IItemStack stack) {
        JeiManager.hideIngredient(IItemStackExpansions.asJeiIngredient(stack));
    }

    @Deprecated
    @ZenCodeType.Method
    public static void hideFluid(IFluidStack stack) {
        JeiManager.hideIngredient(IFluidStackExpansions.asJeiIngredient(stack));
    }
}

