/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.jeitweaker.library.ninepatch;

import com.blamejared.jeitweaker.library.ninepatch.InvalidNinePatchDataException;
import com.blamejared.jeitweaker.library.ninepatch.NinePatchBehavior;
import com.blamejared.jeitweaker.library.ninepatch.NinePatchImage;
import com.blamejared.jeitweaker.library.ninepatch.NinePatchRegion;
import net.minecraft.client.renderer.texture.NativeImage;

final class NinePatchReader {
    NinePatchReader() {
    }

    static NinePatchImage read(NinePatchCreator creator, NativeImage image, int x, int y, int w, int h, int tw, int ty) throws InvalidNinePatchDataException {
        if (image.func_211678_c() != NativeImage.PixelFormat.RGBA) {
            throw new InvalidNinePatchDataException("Image must be in RGBA format");
        }
        double widthScale = (double)image.func_195702_a() / (double)tw;
        double heightScale = (double)image.func_195714_b() / (double)ty;
        if (Math.ceil(widthScale) != widthScale || Math.ceil(heightScale) != heightScale) {
            throw new InvalidNinePatchDataException("Image size is not 256 or a multiple of it: found " + image.func_195702_a() + "x" + image.func_195714_b());
        }
        return NinePatchReader.readScaled(creator, image, x, y, w, h, (int)widthScale, (int)heightScale);
    }

    private static NinePatchImage readScaled(NinePatchCreator creator, NativeImage image, int x, int y, int w, int h, int sx, int sy) throws InvalidNinePatchDataException {
        NinePatchReader.verifyVersion(image, x, y, sx, sy);
        NinePatchRegion top = NinePatchReader.readHorizontal(image, NinePatchBehavior.STRETCH, x + 1, y, w - 2, sx, sy);
        NinePatchRegion left = NinePatchReader.readVertical(image, NinePatchBehavior.STRETCH, x, y + 1, h - 2, sx, sy);
        NinePatchRegion right = NinePatchReader.readVertical(image, NinePatchBehavior.TILE, x + w - 1, y + 1, h - 2, sx, sy);
        NinePatchRegion bottom = NinePatchReader.readHorizontal(image, NinePatchBehavior.TILE, x + 1, y + h - 1, w - 2, sx, sy);
        return NinePatchReader.merge(creator, top, left, bottom, right);
    }

    private static void verifyVersion(NativeImage image, int x, int y, int sx, int sy) throws InvalidNinePatchDataException {
        int color = NinePatchReader.readColor(image, x, y, sx, sy);
        if (NinePatchReader.isTransparent(color) || (color & 0xFFFFFF) != 0xFFFF00) {
            throw new InvalidNinePatchDataException("Unknown 9-patch version: 0x" + Integer.toHexString(color));
        }
    }

    private static NinePatchRegion readHorizontal(NativeImage image, NinePatchBehavior type, int bx, int y, int w, int sx, int sy) throws InvalidNinePatchDataException {
        int x;
        for (x = bx; x < w && !NinePatchReader.isBlackRegion(image, x, y, sx, sy); ++x) {
        }
        if (x == w) {
            return null;
        }
        int prevX = x;
        while (x < w && NinePatchReader.isBlackRegion(image, x, y, sx, sy)) {
            ++x;
        }
        NinePatchRegion region = NinePatchRegion.of(type, prevX, x - prevX);
        while (x < w && !NinePatchReader.isBlackRegion(image, x, y, sx, sy)) {
            ++x;
        }
        if (x != w) {
            throw new InvalidNinePatchDataException("Patch data has been truncated");
        }
        return region;
    }

    private static NinePatchRegion readVertical(NativeImage image, NinePatchBehavior type, int bx, int by, int h, int sx, int sy) throws InvalidNinePatchDataException {
        int y;
        for (y = by; y < h && !NinePatchReader.isBlackRegion(image, bx, y, sx, sy); ++y) {
        }
        if (y == h) {
            return null;
        }
        int prevY = y;
        while (y < h && NinePatchReader.isBlackRegion(image, bx, y, sx, sy)) {
            ++y;
        }
        NinePatchRegion region = NinePatchRegion.of(type, prevY, y - prevY);
        while (y < h && !NinePatchReader.isBlackRegion(image, bx, y, sx, sy)) {
            ++y;
        }
        if (y != h) {
            throw new InvalidNinePatchDataException("9-patch data has been truncated");
        }
        return region;
    }

    private static boolean isBlackRegion(NativeImage image, int rx, int ry, int sx, int sy) throws InvalidNinePatchDataException {
        boolean blackRegion;
        int color = NinePatchReader.readColor(image, rx, ry, sx, sy);
        boolean transparentRegion = NinePatchReader.isTransparent(color);
        boolean bl = blackRegion = !transparentRegion && NinePatchReader.isBlack(color);
        if (!blackRegion && !transparentRegion) {
            throw new InvalidNinePatchDataException("Invalid color for 9-patch pixel @ (" + rx + ',' + ry + "): 0x" + Integer.toHexString(color));
        }
        return blackRegion;
    }

    private static int readColor(NativeImage image, int rx, int ry, int sx, int sy) throws InvalidNinePatchDataException {
        int color = image.func_195709_a(rx * sx, ry * sy);
        int m = (rx + 1) * sx;
        for (int i = rx * sx; i < m; ++i) {
            int n = (ry + 1) * sx;
            for (int j = ry * sy; j < n; ++j) {
                int subpixelColor = image.func_195709_a(i, j);
                if (subpixelColor == color) continue;
                throw new InvalidNinePatchDataException("Multiple colors for subpixel @ (" + rx + ',' + ry + "): initial was 0x" + color);
            }
        }
        return color;
    }

    private static boolean isTransparent(int color) {
        return (color >> 24 & 0xFF) == 0;
    }

    private static boolean isBlack(int color) {
        return !NinePatchReader.isTransparent(color) && (color & 0xFFFFFF) == 0;
    }

    private static NinePatchImage merge(NinePatchCreator creator, NinePatchRegion top, NinePatchRegion left, NinePatchRegion bottom, NinePatchRegion right) throws InvalidNinePatchDataException {
        NinePatchReader.validateCompatibleData(top, bottom);
        NinePatchReader.validateCompatibleData(left, right);
        NinePatchRegion horizontal = top == null ? bottom : top;
        NinePatchRegion vertical = left == null ? right : left;
        return creator.of(horizontal, vertical);
    }

    private static void validateCompatibleData(NinePatchRegion a, NinePatchRegion b) throws InvalidNinePatchDataException {
        if (a != null && b != null) {
            throw new InvalidNinePatchDataException("Malformed 9-patch data: cannot both stretch and tile a section (not yet supported or an actual error)");
        }
    }

    @FunctionalInterface
    static interface NinePatchCreator {
        public NinePatchImage of(NinePatchRegion var1, NinePatchRegion var2);
    }
}

