/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.jeitweaker.library.ninepatch;

import com.blamejared.jeitweaker.library.ninepatch.InvalidNinePatchDataException;
import com.blamejared.jeitweaker.library.ninepatch.NinePatchReader;
import com.blamejared.jeitweaker.library.ninepatch.NinePatchRegion;
import java.io.IOException;
import java.io.InputStream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.resources.IResource;
import net.minecraft.util.ResourceLocation;

final class NinePatchImage {
    private final ResourceLocation atlas;
    private final int u;
    private final int v;
    private final int width;
    private final int height;
    private final NinePatchRegion horizontal;
    private final NinePatchRegion vertical;

    private NinePatchImage(ResourceLocation atlas, int u, int v, int width, int height, NinePatchRegion horizontal, NinePatchRegion vertical) {
        this.atlas = atlas;
        this.u = u;
        this.v = v;
        this.width = width;
        this.height = height;
        this.horizontal = NinePatchImage.convertToImageSpace(horizontal);
        this.vertical = NinePatchImage.convertToImageSpace(vertical);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static NinePatchImage from(ResourceLocation atlas, int u, int v, int width, int height, int texWidth, int texHeight) throws InvalidNinePatchDataException {
        try (IResource resource = Minecraft.func_71410_x().func_195551_G().func_199002_a(atlas);){
            NativeImage image = NativeImage.func_195713_a((InputStream)resource.func_199027_b());
            NinePatchImage ninePatchImage = NinePatchReader.read((horizontal, vertical) -> new NinePatchImage(atlas, u + 1, v + 1, width - 2, height - 2, horizontal, vertical), image, u, v, width, height, texWidth, texHeight);
            return ninePatchImage;
        }
        catch (IOException e) {
            throw new InvalidNinePatchDataException(e);
        }
    }

    private static NinePatchRegion convertToImageSpace(NinePatchRegion region) {
        try {
            return region == null ? null : NinePatchRegion.of(region.behavior(), region.beginning() - 1, region.size());
        }
        catch (InvalidNinePatchDataException e) {
            throw new RuntimeException("Impossible", e);
        }
    }

    public ResourceLocation atlas() {
        return this.atlas;
    }

    public int u() {
        return this.u;
    }

    public int v() {
        return this.v;
    }

    public int width() {
        return this.width;
    }

    public int height() {
        return this.height;
    }

    public NinePatchRegion horizontal() {
        return this.horizontal;
    }

    public NinePatchRegion vertical() {
        return this.vertical;
    }
}

