/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.jeitweaker.jei;

import com.blamejared.crafttweaker.impl.util.text.MCTextComponent;
import com.blamejared.jeitweaker.api.CoordinateFixer;
import com.blamejared.jeitweaker.api.IngredientType;
import com.blamejared.jeitweaker.bridge.CustomTooltipRecipeGraphics;
import com.blamejared.jeitweaker.bridge.ShapelessOnlyRecipeGraphics;
import com.blamejared.jeitweaker.implementation.CoordinateFixerManager;
import com.blamejared.jeitweaker.zen.category.JeiCategory;
import com.blamejared.jeitweaker.zen.component.RawJeiIngredient;
import com.blamejared.jeitweaker.zen.recipe.JeiRecipe;
import com.blamejared.jeitweaker.zen.recipe.RecipeGraphics;
import com.google.common.base.Suppliers;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ingredient.IGuiIngredientGroup;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.runtime.IIngredientManager;

public final class JeiTweakerRecipe {
    private final JeiRecipe recipe;
    private final IIngredientManager manager;
    private final CoordinateFixerManager fixerManager;
    private final Supplier<Map<IIngredientType<?>, List<List<?>>>> ingredients;
    private final Supplier<Map<IIngredientType<?>, List<List<?>>>> results;
    private final Supplier<Set<IIngredientType<?>>> consideredTypes;
    private final Supplier<List<CustomTooltipRecipeGraphics.TipData>> toolTips;

    JeiTweakerRecipe(JeiRecipe recipe, IIngredientManager manager, CoordinateFixerManager fixerManager) {
        this.recipe = recipe;
        this.manager = manager;
        this.fixerManager = fixerManager;
        this.ingredients = Suppliers.memoize(() -> this.computeJeiMaps(this.manager, this.recipe.getInputs()));
        this.results = Suppliers.memoize(() -> this.computeJeiMaps(this.manager, this.recipe.getOutputs()));
        this.consideredTypes = Suppliers.memoize(() -> this.computeJeiTypes(this.ingredients.get(), this.results.get()));
        this.toolTips = Suppliers.memoize(() -> this.computeTooltips(this.recipe));
    }

    JeiCategory getOwningCategory() {
        return this.recipe.getOwningCategory();
    }

    void setIngredients(IIngredients ingredients) {
        this.setIngredients(this.ingredients.get(), (arg_0, arg_1) -> ((IIngredients)ingredients).setInputLists(arg_0, arg_1));
        this.setIngredients(this.results.get(), (arg_0, arg_1) -> ((IIngredients)ingredients).setOutputLists(arg_0, arg_1));
    }

    void setRecipe(IRecipeLayout layout, BiConsumer<IGuiIngredientGroup<?>, CoordinateFixer> layoutMaker, long slotsData, boolean allowShapeless) {
        this.initializeRecipeGui(layout, layoutMaker);
        this.placeIngredients(layout, (int)slotsData, (int)(slotsData >>> 32));
        if (allowShapeless) {
            this.showShapelessMarkerIfRequired(layout);
        }
    }

    void populateGraphics(RecipeGraphics graphics) {
        this.recipe.doGraphics(graphics);
    }

    List<MCTextComponent> getTooltips(double x, double y) {
        return this.toolTips.get().stream().filter(it -> this.isInside((CustomTooltipRecipeGraphics.TipData)it, x, y)).map(CustomTooltipRecipeGraphics.TipData::tooltip).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private void setIngredients(Map<IIngredientType<?>, List<List<?>>> data, IngredientSetter setter) {
        data.forEach((type, ingredient) -> setter.set(type, (List)this.uncheck(ingredient)));
    }

    private void initializeRecipeGui(IRecipeLayout layout, BiConsumer<IGuiIngredientGroup<?>, CoordinateFixer> layoutMaker) {
        this.consideredTypes.get().forEach(it -> layoutMaker.accept(layout.getIngredientsGroup(it), this.fixerManager.findFor((IIngredientType<?>)it)));
    }

    private void placeIngredients(IRecipeLayout layout, int inSlots, int outSlots) {
        this.placeIngredientsIn(layout, this.ingredients.get(), 0, inSlots);
        this.placeIngredientsIn(layout, this.results.get(), inSlots, outSlots);
    }

    private void placeIngredientsIn(IRecipeLayout layout, Map<IIngredientType<?>, List<List<?>>> data, int startIndex, int slotAmount) {
        data.forEach((type, slots) -> {
            IGuiIngredientGroup group = layout.getIngredientsGroup(type);
            IntStream.range(0, Math.min(slots.size(), slotAmount)).forEach(slot -> group.set(slot + startIndex, this.uncheckIngredientList((List)slots.get(slot))));
        });
    }

    private void showShapelessMarkerIfRequired(IRecipeLayout layout) {
        this.recipe.doGraphics(new ShapelessOnlyRecipeGraphics(() -> ((IRecipeLayout)layout).setShapeless()));
    }

    private boolean isInside(CustomTooltipRecipeGraphics.TipData tipData, double x, double y) {
        return (double)tipData.x() <= x && x < (double)tipData.width() && (double)tipData.y() <= y && y < (double)tipData.height();
    }

    private Map<IIngredientType<?>, List<List<?>>> computeJeiMaps(IIngredientManager manager, RawJeiIngredient[][] array) {
        List<List<Pair<IngredientType<?, ?>, ?>>> jeiLists = this.computeJeiLists(array);
        LinkedHashMap returnValue = new LinkedHashMap();
        IntStream.range(0, jeiLists.size()).forEach(slot -> {
            List validElementsForSlot = (List)jeiLists.get(slot);
            validElementsForSlot.forEach(ingredientData -> {
                IIngredientType type = ((IngredientType)ingredientData.getFirst()).toJeiIngredientType(manager);
                List ingredientTypedSlots = returnValue.computeIfAbsent(type, it -> new ArrayList());
                if (ingredientTypedSlots.size() <= slot) {
                    IntStream.rangeClosed(ingredientTypedSlots.size(), slot).forEach(ignore -> ingredientTypedSlots.add(new ArrayList()));
                }
                ((List)ingredientTypedSlots.get(slot)).add(this.uncheck(ingredientData.getSecond()));
            });
        });
        return returnValue;
    }

    private List<List<Pair<IngredientType<?, ?>, ?>>> computeJeiLists(RawJeiIngredient[][] array) {
        return Arrays.stream(array).map(outer -> Arrays.stream(outer).map(RawJeiIngredient::cast).map(it -> Pair.of(it.getType(), it.getType().toJeiType(it.getWrapped()))).collect(Collectors.toList())).map(this::uncheckList).collect(Collectors.toList());
    }

    private Set<IIngredientType<?>> computeJeiTypes(Map<IIngredientType<?>, ?> in, Map<IIngredientType<?>, ?> out) {
        return Stream.concat(in.keySet().stream(), out.keySet().stream()).collect(Collectors.toSet());
    }

    private List<CustomTooltipRecipeGraphics.TipData> computeTooltips(JeiRecipe recipe) {
        CustomTooltipRecipeGraphics graphics = new CustomTooltipRecipeGraphics();
        recipe.doGraphics(graphics);
        return graphics.tipData();
    }

    private <T, U> U uncheck(T t) {
        return (U)t;
    }

    private <T, U> List<Pair<IngredientType<?, ?>, ?>> uncheckList(List<Pair<T, U>> list) {
        return list;
    }

    private <T, U> List<U> uncheckIngredientList(List<T> list) {
        return list;
    }

    @FunctionalInterface
    private static interface IngredientSetter {
        public <U> void set(IIngredientType<U> var1, List<List<U>> var2);
    }
}

