/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.jeitweaker.implementation;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.jeitweaker.api.JeiTweakerPlugin;
import com.blamejared.jeitweaker.api.JeiTweakerPluginProvider;
import com.blamejared.jeitweaker.helper.category.JeiCategoryHelper;
import com.blamejared.jeitweaker.implementation.RegistrationManager;
import java.lang.reflect.Constructor;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.ModFileScanData;
import org.objectweb.asm.Type;

public final class JeiTweakerInitializer {
    private JeiTweakerInitializer() {
    }

    public static void initialize() {
        JeiTweakerInitializer.registerData(JeiTweakerInitializer.findPlugins());
        JeiCategoryHelper.initialize();
    }

    private static List<JeiTweakerPluginProvider> findPlugins() {
        return ModList.get().getAllScanData().stream().flatMap(JeiTweakerInitializer::findValidAnnotations).map(JeiTweakerInitializer::initialize).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private static Stream<Type> findValidAnnotations(ModFileScanData data) {
        Type annotationType = Type.getType(JeiTweakerPlugin.class);
        return data.getAnnotations().stream().filter(it -> annotationType.equals((Object)it.getAnnotationType())).map(ModFileScanData.AnnotationData::getClassType);
    }

    private static JeiTweakerPluginProvider initialize(Type type) {
        try {
            Class<?> clazz = Class.forName(type.getClassName(), false, JeiTweakerInitializer.class.getClassLoader());
            if (!JeiTweakerPluginProvider.class.isAssignableFrom(clazz)) {
                throw new ClassCastException(clazz.getName() + " does not extend JeiTweakerPluginProvider");
            }
            Constructor<?> constructor = clazz.getConstructor(new Class[0]);
            return (JeiTweakerPluginProvider)constructor.newInstance(new Object[0]);
        }
        catch (ClassCastException | ReflectiveOperationException e) {
            CraftTweakerAPI.logThrowing((String)"Unable to initialize JeiTweaker Plugin {}", (Throwable)e, (Object[])new Object[]{type.getClassName()});
            return null;
        }
    }

    private static void registerData(List<JeiTweakerPluginProvider> providers) {
        RegistrationManager manager = new RegistrationManager();
        providers.forEach(provider -> {
            provider.registerIngredientTypes(manager);
            provider.registerCoordinateFixers(manager);
            provider.registerIngredientEnumerators(manager);
        });
    }
}

