/*
 * Decompiled with CFR 0.152.
 */
package dlovin.inventoryhud.gui.renderers;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import dlovin.inventoryhud.gui.renderers.PotionRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;

public class VerticalPotionRenderer
extends PotionRenderer {
    private final ResourceLocation PBG = new ResourceLocation("inventoryhud", "textures/gui/potion_bg.png");

    public VerticalPotionRenderer(Minecraft mc) {
        super(mc);
    }

    @Override
    int getX(int width, int c) {
        int result = 0;
        switch (this.PotAligns.HorAlign) {
            case LEFT: {
                result = this.potX;
                break;
            }
            case MIDDLE: {
                result = width / 2 - 30 - this.potX;
                break;
            }
            case RIGHT: {
                result = width - this.potX;
            }
        }
        return result;
    }

    @Override
    int getY(int height, int effCount) {
        int result = 0;
        switch (this.PotAligns.VertAlign) {
            case TOP: {
                result = this.potY;
                break;
            }
            case CENTER: {
                if (this.potY > 0) {
                    result = height / 2 - 12 - this.potY;
                    break;
                }
                if (this.potY < 0) {
                    result = height / 2 - 12 - (effCount - 1) * (24 + this.potGap) - this.potY;
                    break;
                }
                result = (int)((float)(height / 2 - 12) - (float)(effCount - 1) * ((float)this.potGap / 2.0f + 12.0f) - (float)this.potY);
                break;
            }
            case BOTTOM: {
                result = height - this.potY - (effCount - 1) * (this.potGap + 24);
            }
        }
        return result;
    }

    @Override
    void renderBG(MatrixStack mat, int x, int y, int c) {
        RenderSystem.pushMatrix();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)this.potAlpha);
        RenderSystem.enableAlphaTest();
        RenderSystem.enableBlend();
        this.mc.func_110434_K().func_110577_a(this.PBG);
        VerticalPotionRenderer.func_238463_a_((MatrixStack)mat, (int)x, (int)(y + c * (24 + this.potGap)), (float)60.0f, (float)24.0f, (int)60, (int)24, (int)(60 * this.potSide), (int)24);
        RenderSystem.disableBlend();
        RenderSystem.disableAlphaTest();
        RenderSystem.popMatrix();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Override
    void renderIcon(MatrixStack mat, int x, int y, int c, TextureAtlasSprite s) {
        VerticalPotionRenderer.func_238470_a_((MatrixStack)mat, (int)(x + 3 + this.potIconSide), (int)(y + c * (24 + this.potGap) + 3), (int)this.func_230927_p_(), (int)18, (int)18, (TextureAtlasSprite)s);
    }

    @Override
    void renderLevel(MatrixStack mat, int x, int y, int c) {
        VerticalPotionRenderer.func_238463_a_((MatrixStack)mat, (int)(x + 15 + this.potIconSide), (int)(y + c * (24 + this.potGap)), (float)9.0f, (float)9.0f, (int)9, (int)9, (int)9, (int)9);
    }

    @Override
    void renderTimer(MatrixStack mat, int x, int y, int c, int dur) {
        String time = "";
        if ((dur /= 20) > 1600) {
            time = " **:**";
        } else {
            String mins = dur / 60 + "";
            String secs = dur % 60 + "";
            if (dur / 60 < 10) {
                mins = "0" + mins;
            }
            if (dur % 60 < 10) {
                secs = "0" + secs;
            }
            time = dur > 10 ? mins + ":" + secs : TextFormatting.RED + mins + TextFormatting.WHITE + ":" + TextFormatting.RED + secs;
        }
        this.fontRenderer.func_238405_a_(mat, time, (float)(x + 28 + this.potTextSide), (float)(y + c * (24 + this.potGap) + 8), 0xFFFFFF);
    }
}

