/*
 * Decompiled with CFR 0.152.
 */
package dlovin.inventoryhud.gui.renderers;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import dlovin.inventoryhud.gui.renderers.PotionRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;

public class HorizontalPotionRenderer
extends PotionRenderer {
    private final ResourceLocation PBG = new ResourceLocation("inventoryhud", "textures/gui/potion_bg_hor.png");

    public HorizontalPotionRenderer(Minecraft mc) {
        super(mc);
    }

    @Override
    int getX(int width, int effCount) {
        int result = 0;
        switch (this.PotAligns.HorAlign) {
            case LEFT: {
                result = this.potX;
                break;
            }
            case MIDDLE: {
                if (this.potX > 0) {
                    result = width / 2 - 18 - this.potX;
                    break;
                }
                if (this.potX < 0) {
                    result = width / 2 - 18 - (effCount - 1) * (36 + this.potGap) - this.potX;
                    break;
                }
                result = (int)((float)(width / 2 - 18) - (float)(effCount - 1) * ((float)this.potGap / 2.0f + 18.0f) - (float)this.potX);
                break;
            }
            case RIGHT: {
                result = width - this.potX - (effCount - 1) * (this.potGap + 36);
            }
        }
        return result;
    }

    @Override
    int getY(int height, int c) {
        int result = 0;
        switch (this.PotAligns.VertAlign) {
            case TOP: {
                result = this.potY;
                break;
            }
            case CENTER: {
                result = height / 2 - 18 - this.potY;
                break;
            }
            case BOTTOM: {
                result = height - this.potY;
            }
        }
        return result;
    }

    @Override
    void renderBG(MatrixStack mat, int w, int h, int c) {
        RenderSystem.pushMatrix();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)this.potAlpha);
        RenderSystem.enableAlphaTest();
        RenderSystem.enableBlend();
        this.mc.func_110434_K().func_110577_a(this.PBG);
        HorizontalPotionRenderer.func_238463_a_((MatrixStack)mat, (int)(w + c * (36 + this.potGap)), (int)h, (float)36.0f, (float)38.0f, (int)36, (int)38, (int)36, (int)38);
        RenderSystem.disableBlend();
        RenderSystem.disableAlphaTest();
        RenderSystem.popMatrix();
    }

    @Override
    void renderIcon(MatrixStack mat, int w, int h, int c, TextureAtlasSprite s) {
        HorizontalPotionRenderer.func_238470_a_((MatrixStack)mat, (int)(w + c * (36 + this.potGap) + 9), (int)(h + 3), (int)this.func_230927_p_(), (int)18, (int)18, (TextureAtlasSprite)s);
    }

    @Override
    void renderLevel(MatrixStack mat, int w, int h, int c) {
        HorizontalPotionRenderer.func_238463_a_((MatrixStack)mat, (int)(w + c * (36 + this.potGap) + 21), (int)h, (float)9.0f, (float)9.0f, (int)9, (int)9, (int)9, (int)9);
    }

    @Override
    void renderTimer(MatrixStack mat, int w, int h, int c, int dur) {
        String time = "";
        if ((dur /= 20) > 1600) {
            time = " **:**";
        } else {
            String mins = dur / 60 + "";
            String secs = dur % 60 + "";
            if (dur / 60 < 10) {
                mins = "0" + mins;
            }
            if (dur % 60 < 10) {
                secs = "0" + secs;
            }
            time = dur > 10 ? mins + ":" + secs : TextFormatting.RED + mins + TextFormatting.WHITE + ":" + TextFormatting.RED + secs;
        }
        this.fontRenderer.func_238405_a_(mat, time, (float)(w + c * (36 + this.potGap) + 5), (float)(h + 25), 0xFFFFFF);
    }
}

